/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.NameDescriptor;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.indices.StructureOfIndices;
import java.util.Arrays;

final class NameDescriptorForMetricAndKronecker
extends NameDescriptor {
    private final String[] names;

    public NameDescriptorForMetricAndKronecker(String[] names, byte type, int id) {
        super(NameDescriptorForMetricAndKronecker.createIndicesTypeStructures(type), id);
        this.names = names;
    }

    private static StructureOfIndices[] createIndicesTypeStructures(byte type) {
        StructureOfIndices[] structures = new StructureOfIndices[]{!CC.isMetric(type) ? StructureOfIndices.create(type, 2, true, false) : StructureOfIndices.create(type, 2)};
        return structures;
    }

    @Override
    NameAndStructureOfIndices[] getKeys() {
        return new NameAndStructureOfIndices[]{new NameAndStructureOfIndices(this.names[0], this.structuresOfIndices), new NameAndStructureOfIndices(this.names[1], this.structuresOfIndices)};
    }

    @Override
    public String getName(SimpleIndices indices, OutputFormat format) {
        boolean metric = IndicesUtils.haveEqualStates(indices.get(0), indices.get(1));
        if (format.is(OutputFormat.Maple)) {
            return metric ? "g_" : "KroneckerDelta";
        }
        return metric ? this.names[1] : this.names[0];
    }

    @Override
    public String toString() {
        return this.names[0] + ":" + Arrays.toString(this.structuresOfIndices);
    }
}

