/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.context;

import cc.redberry.core.context.Context;
import cc.redberry.core.context.ContextSettings;
import cc.redberry.core.context.defaults.DefaultContextFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class ContextManager {
    private static final ThreadLocal<ContextContainer> threadLocalContainer = new ThreadLocal<ContextContainer>(){

        @Override
        protected ContextContainer initialValue() {
            return new ContextContainer();
        }
    };
    private static final ThreadLocal<ExecutorService> executorService = new ThreadLocal<ExecutorService>(){

        @Override
        protected ExecutorService initialValue() {
            return Executors.newCachedThreadPool(new CThreadFactory((ContextContainer)threadLocalContainer.get()));
        }
    };

    private ContextManager() {
    }

    public static Context getCurrentContext() {
        return ContextManager.threadLocalContainer.get().context;
    }

    public static Context initializeNew() {
        Context context;
        ContextManager.threadLocalContainer.get().context = context = DefaultContextFactory.INSTANCE.createContext();
        return context;
    }

    public static Context initializeNew(ContextSettings contextSettings) {
        Context context;
        ContextManager.threadLocalContainer.get().context = context = new Context(contextSettings);
        return context;
    }

    public static void setCurrentContext(Context context) {
        ContextManager.threadLocalContainer.get().context = context;
    }

    public static ExecutorService getExecutorService() {
        return executorService.get();
    }

    private static class RunnableWrapper
    implements Runnable {
        private final ContextContainer container;
        private final Runnable innerRunnable;

        public RunnableWrapper(ContextContainer container, Runnable innerRunnable) {
            this.container = container;
            this.innerRunnable = innerRunnable;
        }

        @Override
        public void run() {
            threadLocalContainer.set(this.container);
            this.innerRunnable.run();
        }
    }

    private static class CThreadFactory
    implements ThreadFactory {
        private final ContextContainer container;

        public CThreadFactory(ContextContainer container) {
            this.container = container;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(new RunnableWrapper(this.container, r));
        }
    }

    private static class ContextContainer {
        volatile Context context = DefaultContextFactory.INSTANCE.createContext();

        private ContextContainer() {
        }
    }
}

