/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.numeric.PnStiffMatrix;

public class PnStiffAniso
extends PnStiffMatrix {
    protected double m_featureDetect = Double.MAX_VALUE;
    protected boolean m_bUseStepFunc = false;
    static /* synthetic */ Class class$jvx$numeric$PnStiffAniso;

    public PnStiffAniso(PgElementSet pgElementSet) {
        this(pgElementSet, Double.MAX_VALUE);
    }

    public PnStiffAniso(PgElementSet pgElementSet, double d) {
        super(pgElementSet);
        int n;
        this.m_featureDetect = d;
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        this.setSize(pgElementSet.getNumVertices());
        this.m_noe = pgElementSet.getNumElements();
        this.m_snoe.setConstant(0);
        for (n = 0; n < this.m_noe; ++n) {
            int n2 = piVectorArray[n].getSize();
            for (int i = 0; i < n2; ++i) {
                if (piVectorArray2[n].m_data[i] >= 0 && piVectorArray2[n].m_data[i] <= n) continue;
                int n3 = piVectorArray[n].m_data[(i + 1) % n2];
                this.m_snoe.m_data[n3] = this.m_snoe.m_data[n3] + 1;
                int n4 = piVectorArray[n].m_data[(i + 2) % n2];
                this.m_snoe.m_data[n4] = this.m_snoe.m_data[n4] + 1;
            }
        }
        for (n = 0; n < this.m_iSize; ++n) {
            if (this.m_snoe.m_data[n] <= 0) continue;
            int n5 = n;
            this.m_snoe.m_data[n5] = this.m_snoe.m_data[n5] + 1;
        }
        for (n = 0; n < this.m_iSize; ++n) {
            if (this.m_sindx[n] == null) {
                this.m_sindx[n] = new PiVector(this.m_snoe.m_data[n]);
            } else {
                this.m_sindx[n].setSize(this.m_snoe.m_data[n]);
            }
            if (this.m_stiff[n] == null) {
                this.m_stiff[n] = new PdVector(this.m_snoe.m_data[n]);
                continue;
            }
            this.m_stiff[n].setSize(this.m_snoe.m_data[n]);
        }
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnStiffAniso == null ? (class$jvx$numeric$PnStiffAniso = PnStiffAniso.class$("jvx.numeric.PnStiffAniso")) : class$jvx$numeric$PnStiffAniso)) {
            this.init(pgElementSet);
        }
    }

    public void init(PgElementSet pgElementSet) {
        int n;
        int n2;
        if (pgElementSet.getNumVertices() != this.m_iSize || pgElementSet.getNumElements() != this.m_noe) {
            return;
        }
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        for (n2 = 0; n2 < this.m_iSize; ++n2) {
            this.m_snoe.m_data[n2] = this.m_sindx[n2].m_data.length;
            if (this.m_snoe.m_data[n2] <= 0) continue;
            this.m_sindx[n2].setConstant(-1);
            this.m_stiff[n2].setConstant(0.0);
        }
        PdVector pdVector = new PdVector(3);
        double[] dArray = pdVector.m_data;
        PdVector pdVector2 = new PdVector(3);
        double[] dArray2 = pdVector2.m_data;
        boolean bl = false;
        for (n2 = 0; n2 < this.m_noe; ++n2) {
            int[] nArray = piVectorArray[n2].m_data;
            PuVectorGeom.ctg((double[])dArray, (PdVector)pdVectorArray[nArray[0]], (PdVector)pdVectorArray[nArray[1]], (PdVector)pdVectorArray[nArray[2]]);
            if (!bl && pdVector.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + n2 + "\n\tctg = [" + dArray[0] + ", " + dArray[1] + ", " + dArray[2] + "]"));
            }
            pdVector.multScalar(0.5);
            for (n = 0; n < 3; ++n) {
                if (piVectorArray2[n2].m_data[n] < n2) continue;
                int[] nArray2 = piVectorArray[piVectorArray2[n2].m_data[n]].m_data;
                PuVectorGeom.ctg((double[])dArray2, (PdVector)pdVectorArray[nArray2[0]], (PdVector)pdVectorArray[nArray2[1]], (PdVector)pdVectorArray[nArray2[2]]);
                pdVector2.multScalar(0.5);
                int n3 = (n + 1) % 3;
                int n4 = (n + 2) % 3;
                int n5 = pgElementSet.getOppVertexLocInd(n2, n);
                int n6 = (n5 + 1) % 3;
                int n7 = (n5 + 2) % 3;
                double d = 0.0;
                for (int i = 0; i < 3; ++i) {
                    double d2 = dArray[n3] * (pdVectorArray[nArray[n4]].m_data[i] - pdVectorArray[nArray[n]].m_data[i]) + dArray[n4] * (pdVectorArray[nArray[n3]].m_data[i] - pdVectorArray[nArray[n]].m_data[i]) + dArray2[n6] * (pdVectorArray[nArray2[n7]].m_data[i] - pdVectorArray[nArray2[n5]].m_data[i]) + dArray2[n7] * (pdVectorArray[nArray2[n6]].m_data[i] - pdVectorArray[nArray2[n5]].m_data[i]);
                    d += d2 * d2;
                }
                if (d > this.m_featureDetect * this.m_featureDetect) {
                    if (this.m_bUseStepFunc) continue;
                    d = Math.sqrt(d);
                    double d3 = 10.0;
                    double d4 = this.m_featureDetect;
                    d = d4 * d4 / (d4 * d4 + d3 * (d - d4) * (d - d4));
                } else {
                    d = 1.0;
                }
                int n8 = this.getIndex(nArray[n3], nArray[n4]);
                this.m_stiff[nArray[n3]].m_data[n8] = this.m_stiff[nArray[n3]].m_data[n8] + (dArray[n3] + dArray2[n7]) * d;
                int n9 = this.getIndex(nArray[n3], nArray[n3]);
                this.m_stiff[nArray[n3]].m_data[n9] = this.m_stiff[nArray[n3]].m_data[n9] + (dArray[n4] + dArray2[n6]) * d;
                int n10 = this.getIndex(nArray[n3], nArray2[n5]);
                this.m_stiff[nArray[n3]].m_data[n10] = this.m_stiff[nArray[n3]].m_data[n10] - (dArray2[n6] + dArray2[n7]) * d;
                int n11 = this.getIndex(nArray[n3], nArray[n]);
                this.m_stiff[nArray[n3]].m_data[n11] = this.m_stiff[nArray[n3]].m_data[n11] - (dArray[n3] + dArray[n4]) * d;
                int n12 = this.getIndex(nArray[n4], nArray[n4]);
                this.m_stiff[nArray[n4]].m_data[n12] = this.m_stiff[nArray[n4]].m_data[n12] + (dArray[n3] + dArray2[n7]) * d;
                int n13 = this.getIndex(nArray[n4], nArray[n3]);
                this.m_stiff[nArray[n4]].m_data[n13] = this.m_stiff[nArray[n4]].m_data[n13] + (dArray[n4] + dArray2[n6]) * d;
                int n14 = this.getIndex(nArray[n4], nArray2[n5]);
                this.m_stiff[nArray[n4]].m_data[n14] = this.m_stiff[nArray[n4]].m_data[n14] - (dArray2[n6] + dArray2[n7]) * d;
                int n15 = this.getIndex(nArray[n4], nArray[n]);
                this.m_stiff[nArray[n4]].m_data[n15] = this.m_stiff[nArray[n4]].m_data[n15] - (dArray[n3] + dArray[n4]) * d;
            }
        }
        for (n2 = 0; n2 < this.m_iSize; ++n2) {
            for (n = this.m_snoe.m_data[n2] - 1; n >= 0; --n) {
                if (this.m_sindx[n2].m_data[n] < 0) continue;
                this.m_snoe.m_data[n2] = n + 1;
                break;
            }
            if (n != -1) continue;
            this.m_snoe.m_data[n2] = 0;
        }
    }

    public void setFeatureDetect(double d) {
        if (d > 0.0) {
            this.m_featureDetect = d;
        } else {
            this.m_featureDetect = Math.abs(d);
            PsDebug.warning((String)"Given feature detection parameter is negative, absolute of the given value is used.");
        }
    }

    public double getFeatureDetect() {
        return this.m_featureDetect;
    }

    public void useStepFunction(boolean bl) {
        this.m_bUseStepFunc = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

