/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;

public class PnOde
extends PsObject {
    protected int m_order;
    protected double m_x0;
    protected double[] m_y0;
    protected double m_stepSize;
    protected double m_length;
    static /* synthetic */ Class class$jvx$numeric$PnOde;

    public PnOde() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnOde == null ? (class$jvx$numeric$PnOde = PnOde.class$("jvx.numeric.PnOde")) : class$jvx$numeric$PnOde)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void setOrder(int n) {
        if (n == this.m_order) {
            return;
        }
        this.m_order = n;
        this.m_y0 = new double[this.m_order];
    }

    public void setInitialData(double d, double[] dArray, double d2, double d3) {
        this.m_x0 = d;
        for (int i = 0; i < this.m_order; ++i) {
            this.m_y0[i] = dArray[i];
        }
        this.m_stepSize = d2;
        this.m_length = d3;
    }

    public void solve(PgPolygon pgPolygon) {
        PnOde.solve(pgPolygon, this, this.m_x0, this.m_y0, this.m_stepSize, this.m_length);
    }

    public void diffEquation(double d, double[] dArray, double[] dArray2) {
        dArray2[0] = d;
    }

    public static boolean solve(PgPolygon pgPolygon, PnOde pnOde, double d, double[] dArray, double d2, double d3) {
        if (pgPolygon == null) {
            PsDebug.warning((String)"missing polygon");
            return false;
        }
        if (dArray == null || d2 == 0.0 || d3 < d2) {
            PsDebug.warning((String)"wrong argument");
            return false;
        }
        int n = dArray.length;
        if (n == 0) {
            PsDebug.warning((String)"dim of initial value yStart is 0");
            return false;
        }
        int n2 = (int)(d3 / d2);
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        double d4 = d;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        pgPolygon.setNumVertices(n2);
        pgPolygon.setVertex(0, d4, dArray2[0], 0.0);
        for (int i = 1; i < n2; ++i) {
            PnOde.rungeKutta(pnOde, d4, dArray2, d2, dArray3);
            System.arraycopy(dArray3, 0, dArray2, 0, n);
            pgPolygon.setVertex(i, d4 += d2, dArray2[0], 0.0);
        }
        return true;
    }

    public static void rungeKutta(PnOde pnOde, double d, double[] dArray, double d2, double[] dArray2) {
        int n;
        if (pnOde == null || dArray == null || dArray2 == null) {
            PsDebug.warning((String)"missing argument");
            return;
        }
        int n2 = dArray.length;
        if (n2 == 0) {
            PsDebug.warning((String)"dim of 'y' argument is 0");
            return;
        }
        double[][] dArray3 = new double[4][n2];
        double[] dArray4 = new double[n2];
        pnOde.diffEquation(d, dArray, dArray3[0]);
        for (n = 0; n < n2; ++n) {
            dArray4[n] = dArray[n] + d2 / 2.0 * dArray3[0][n];
        }
        pnOde.diffEquation(d + d2 / 2.0, dArray4, dArray3[1]);
        for (n = 0; n < n2; ++n) {
            dArray4[n] = dArray[n] + d2 / 2.0 * dArray3[1][n];
        }
        pnOde.diffEquation(d + d2 / 2.0, dArray4, dArray3[2]);
        for (n = 0; n < n2; ++n) {
            dArray4[n] = dArray[n] + d2 * dArray3[2][n];
        }
        pnOde.diffEquation(d + d2, dArray4, dArray3[3]);
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n] + d2 / 6.0 * (dArray3[0][n] + 2.0 * dArray3[1][n] + 2.0 * dArray3[2][n] + dArray3[3][n]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

