/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.objectGui.PsScanline;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.geom.PwTexture;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnNoise;

public class PnLIC {
    protected PgElementSet m_geom;
    protected int m_maxhits = 3;
    protected PnGeodesicRK m_rk;
    protected double m_integralh = 1.0;
    protected int m_width;
    protected int m_height;
    protected int[] m_pix;
    protected PdVector[][] m_texCoords;
    protected double m_steplen;
    protected int m_kernelwidth = 100;
    protected int m_minKernel = 1;
    protected double m_kernelwidthWorld = 1.0;
    protected double m_minKernelWorld = 0.0;
    protected float m_coarseness = 1.0f;
    protected PnNoise m_noise = new PnNoise();
    private PgPolygonOnElementSet m_poly;
    private PiVector m_evalelem;
    private PdVector[] m_evalbary;
    private int m_evalsize;
    private PiVector m_evalx;
    private PiVector m_evaly;
    private PdVector m_noiseCol;
    private PiVector m_kernelW;
    private int m_nextKernelW;
    private int m_nextPolySize;
    private boolean m_bNextEdgeReached;
    private double m_kernelFac;
    private static final int m_maxIter = 30;
    private PdBary m_point = new PdBary(3);
    private PdVector m_texPoint = new PdVector(2);
    private PdBary m_eval = new PdBary(3);
    private PdVector[] m_coord;

    public PnLIC() {
        this.m_poly = new PgPolygonOnElementSet(3);
    }

    public PnLIC(PgElementSet pgElementSet) {
        this();
        this.setGeometry(pgElementSet);
    }

    public PnLIC(PgElementSet pgElementSet, int n, PnGeodesicRK pnGeodesicRK) {
        this(pgElementSet);
        this.setRungeKutta(pnGeodesicRK);
        this.setSize(n);
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"geometry must be a triangulation");
            PgElementSet.triangulate((PgElementSet)pgElementSet);
        }
        this.m_geom = pgElementSet;
        this.m_poly.setGeometry(this.m_geom);
    }

    public void setSize(int n) {
        double[] dArray = PwTexture.makeElementTextureCoords(this.m_geom, n);
        this.m_texCoords = this.m_geom.getElementTextures();
        if (dArray[0] < 1.0E-10) {
            return;
        }
        this.m_steplen = 1.0 / dArray[0];
        this.m_width = (int)dArray[1];
        this.m_height = (int)dArray[2];
        if (this.m_pix != null && this.m_pix.length == this.m_width * this.m_height) {
            this.reset();
        }
        this.m_evalsize = (this.m_width + this.m_height) / 2;
        this.m_evalbary = new PdVector[3];
        for (int i = 0; i < 3; ++i) {
            this.m_evalbary[i] = new PdVector(this.m_evalsize);
        }
        this.m_evalelem = new PiVector(this.m_evalsize);
        this.m_evalx = new PiVector(this.m_evalsize);
        this.m_evaly = new PiVector(this.m_evalsize);
        this.m_kernelW = new PiVector(this.m_evalsize);
        this.m_noiseCol = new PdVector(this.m_evalsize);
    }

    public void setRungeKutta(PnGeodesicRK pnGeodesicRK) {
        this.m_rk = pnGeodesicRK;
    }

    public int getTextureWidth() {
        return this.m_width;
    }

    public int getTextureHeight() {
        return this.m_height;
    }

    public boolean setCoarseness(double d) {
        if (d < 0.0 || d > 1.0) {
            return false;
        }
        this.m_coarseness = (float)(1.0 - d);
        return true;
    }

    public double getCoarseness() {
        return 1.0 - (double)this.m_coarseness;
    }

    public boolean setConvolutionWidth(int n) {
        if (n < 1) {
            return false;
        }
        this.m_kernelwidth = n;
        return true;
    }

    public int getConvolutionWidth() {
        return this.m_kernelwidth;
    }

    public boolean setWorldConvolutionWidth(double d) {
        this.m_kernelwidthWorld = d;
        return !(d < 0.0);
    }

    public double getWorldConvolutionWidth() {
        return this.m_kernelwidthWorld;
    }

    public boolean setMinConvolutionWidth(int n) {
        if (n < 1 || n > this.m_kernelwidth) {
            return false;
        }
        this.m_minKernel = n;
        return true;
    }

    public int getMinConvolutionWidth() {
        return this.m_minKernel;
    }

    public void setStepSize(double d) {
        this.m_integralh = d;
    }

    public double getStepSize() {
        return this.m_integralh;
    }

    public void makeElement(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n;
        PdVector[] pdVectorArray = this.m_texCoords[n6];
        if (pdVectorArray[0].m_data[0] == pdVectorArray[1].m_data[0] && pdVectorArray[0].m_data[0] == pdVectorArray[2].m_data[0] && pdVectorArray[0].m_data[1] == pdVectorArray[1].m_data[1] && pdVectorArray[0].m_data[1] == pdVectorArray[2].m_data[1]) {
            return;
        }
        if (this.m_pix == null || this.m_pix.length != this.m_width * this.m_height) {
            this.m_pix = new int[this.m_width * this.m_height];
        }
        if (this.m_kernelwidthWorld >= 0.0) {
            this.m_kernelwidth = (int)(this.m_kernelwidthWorld / this.m_steplen);
        }
        this.m_kernelFac = this.m_steplen / this.m_integralh * (double)(this.m_kernelwidth - this.m_minKernel);
        int n7 = this.m_evalx.getSize();
        PsScanline psScanline = new PsScanline();
        int n8 = (int)(pdVectorArray[0].m_data[0] * (double)(this.m_width - 1));
        int n9 = (int)((1.0 - pdVectorArray[0].m_data[1]) * (double)(this.m_height - 1));
        int n10 = (int)(pdVectorArray[1].m_data[0] * (double)(this.m_width - 1));
        int n11 = (int)((1.0 - pdVectorArray[1].m_data[1]) * (double)(this.m_height - 1));
        int n12 = (int)(pdVectorArray[2].m_data[0] * (double)(this.m_width - 1));
        int n13 = (int)((1.0 - pdVectorArray[2].m_data[1]) * (double)(this.m_height - 1));
        psScanline.makeScanlines(n8, n9, n10, n11, n12, n13);
        for (int i = 0; i < psScanline.m_length; ++i) {
            int n14;
            int n15;
            n5 = psScanline.m_xa[i];
            n4 = psScanline.m_xe[i];
            n3 = i + psScanline.m_ymin;
            int n16 = n4 - n5;
            float f = psScanline.m_aAnteile[0][i];
            float f2 = psScanline.m_aAnteile[1][i];
            float f3 = psScanline.m_aAnteile[2][i];
            float f4 = (psScanline.m_eAnteile[0][i] - f) / (float)n16;
            float f5 = (psScanline.m_eAnteile[1][i] - f2) / (float)n16;
            float f6 = (psScanline.m_eAnteile[2][i] - f3) / (float)n16;
            for (n2 = n5; n2 <= n4; ++n2) {
                if (n2 + n3 * this.m_width < 0 || n2 + n3 * this.m_width >= this.m_pix.length) {
                    System.err.println("OUCH!");
                }
                if (this.m_pix[n2 + n3 * this.m_width] >> 24 <= this.m_maxhits) {
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    this.m_point.m_data[0] = f;
                    this.m_point.m_data[1] = f2;
                    this.m_point.m_data[2] = f3;
                    for (n15 = 0; n15 < 3; ++n15) {
                        if (!(this.m_point.m_data[n15] < 0.0)) continue;
                        this.m_point.m_data[n15] = 0.0;
                        this.m_point.validate();
                    }
                    this.m_rk.prepareSolve(this.m_poly, n6, this.m_point, this.m_integralh);
                    boolean bl = false;
                    boolean bl2 = false;
                    int n21 = 0;
                    int n22 = 0;
                    int n23 = 0;
                    float f7 = 0.0f;
                    this.makeNextStep();
                    block3: do {
                        int n24 = this.m_nextPolySize;
                        n20 = this.m_nextKernelW;
                        bl = this.m_bNextEdgeReached;
                        if (n7 < n23 + n24 + 1) {
                            n7 = this.m_evalsize > n24 + 1 ? (n7 += this.m_evalsize) : (n7 += n24 + 1);
                            this.m_evalx.setSize(n7);
                            this.m_evaly.setSize(n7);
                            this.m_kernelW.setSize(n7);
                            this.m_noiseCol.setSize(n7);
                        }
                        n19 = n23 + n24;
                        for (n15 = n23; n15 < n19; ++n15) {
                            this.makeEvalXY(n15 - n23, n15);
                            float f8 = this.m_noise.intNoise(this.m_coarseness * (float)this.m_evalx.m_data[n15], this.m_coarseness * (float)this.m_evaly.m_data[n15]);
                            this.m_noiseCol.m_data[n15] = f8;
                        }
                        this.makeNextStep();
                        float f9 = (float)(this.m_nextKernelW - n20) / (float)n24;
                        float f10 = n20;
                        for (n15 = 0; n15 < n24; ++n15) {
                            this.m_kernelW.m_data[n23] = (int)f10;
                            f10 += f9;
                            ++n23;
                        }
                        n20 = this.m_kernelW.m_data[n22];
                        while (n22 < n23 && n23 - n22 >= n20) {
                            n14 = this.m_evalx.m_data[n22] + this.m_evaly.m_data[n22] * this.m_width;
                            if (this.m_pix[n14] >> 24 > this.m_maxhits) {
                                if (n21 > this.m_maxhits) {
                                    bl2 = true;
                                    continue block3;
                                }
                                ++n21;
                            }
                            f7 = 0.0f;
                            n19 = n22 + n20;
                            for (n15 = n22; n15 < n19; ++n15) {
                                f7 = (float)((double)f7 + this.m_noiseCol.m_data[n15]);
                            }
                            n18 = 0x1000000 + (int)(f7 /= (float)n20);
                            int n25 = n14;
                            this.m_pix[n25] = this.m_pix[n25] + n18;
                            if (n22 == 0 && (this.m_evalx.m_data[0] != n2 || this.m_evaly.m_data[0] != n3)) {
                                int n26 = n17 = n3 * this.m_width + n2;
                                this.m_pix[n26] = this.m_pix[n26] + n18;
                            }
                            if (this.m_kernelW.m_data.length <= ++n22) {
                                System.err.println("brrR");
                            }
                            n20 = this.m_kernelW.m_data[n22];
                        }
                    } while (!bl && !bl2);
                    if (bl) {
                        while (n22 < n23) {
                            n14 = this.m_evalx.m_data[n22] + this.m_evaly.m_data[n22] * this.m_width;
                            n20 = this.m_kernelW.m_data[n22];
                            float f11 = 0.0f;
                            n19 = n22 + n20;
                            for (n15 = n22; n15 < n19; ++n15) {
                                f11 = (float)((double)f11 + this.m_noiseCol.m_data[n15 % n23]);
                            }
                            n18 = 0x1000000 + (int)(f11 /= (float)n20);
                            int n27 = n14;
                            this.m_pix[n27] = this.m_pix[n27] + n18;
                            if (n22 == 0 && (this.m_evalx.m_data[0] != n2 || this.m_evaly.m_data[0] != n3)) {
                                int n28 = n17 = n3 * this.m_width + n2;
                                this.m_pix[n28] = this.m_pix[n28] + n18;
                            }
                            ++n22;
                        }
                    }
                }
                f += f4;
                f2 += f5;
                f3 += f6;
            }
            n14 = n3 * this.m_width;
            for (n15 = 1; n15 <= 2; ++n15) {
                if (n5 - n15 >= 0) {
                    int n29 = n14 + n5 - n15;
                    this.m_pix[n29] = this.m_pix[n29] + this.m_pix[n14 + n5];
                }
                if (n4 + n15 >= this.m_width) continue;
                int n30 = n14 + n4 + n15;
                this.m_pix[n30] = this.m_pix[n30] + this.m_pix[n14 + n4];
            }
        }
        if (psScanline.m_length >= 1) {
            n3 = psScanline.m_length + psScanline.m_ymin;
            n5 = psScanline.m_xa[psScanline.m_length - 1];
            n4 = psScanline.m_xe[psScanline.m_length - 1];
            if (n3 < this.m_height) {
                for (n2 = n5 - 2; n2 <= n4 + 2; ++n2) {
                    if (n2 < 0 || n2 >= this.m_width) continue;
                    int n31 = n3 * this.m_width + n2;
                    this.m_pix[n31] = this.m_pix[n31] + this.m_pix[(n3 - 1) * this.m_width + n2];
                }
            }
            n3 = psScanline.m_ymin - 1;
            n5 = psScanline.m_xa[0];
            n4 = psScanline.m_xe[0];
            if (n3 >= 0) {
                for (n2 = n5 - 2; n2 <= n4 + 2; ++n2) {
                    if (n2 < 0 || n2 >= this.m_width) continue;
                    int n32 = n3 * this.m_width + n2;
                    this.m_pix[n32] = this.m_pix[n32] + this.m_pix[(n3 + 1) * this.m_width + n2];
                }
            }
        }
    }

    private void makeNextStep() {
        int n = 0;
        int n2 = this.m_poly.getNumVertices() - 1;
        this.m_poly.swap(0, n2);
        this.m_poly.setNumVertices(1);
        this.m_bNextEdgeReached = false;
        for (double d = 0.0; !this.m_bNextEdgeReached && d < this.m_steplen; d += this.m_rk.getStepLength()) {
            this.m_bNextEdgeReached = !this.m_rk.nextStep() || ++n >= 30;
        }
        this.m_nextPolySize = this.m_poly.eval(this.m_evalbary, this.m_evalelem, this.m_steplen);
        this.m_nextKernelW = (int)(this.m_kernelFac * (double)this.m_nextPolySize / (double)n + (double)this.m_minKernel);
        if (this.m_nextPolySize <= 1) {
            this.m_nextKernelW = 1;
            if (this.m_nextPolySize < 1) {
                ++this.m_nextPolySize;
            }
        }
    }

    private void makeEvalXY(int n, int n2) {
        int n3 = this.m_evalelem.m_data[n];
        this.m_coord = this.m_texCoords[n3];
        for (int i = 0; i < 3; ++i) {
            this.m_eval.m_data[i] = this.m_evalbary[i].m_data[n];
        }
        this.m_eval.getVertex(this.m_texPoint, this.m_coord[0], this.m_coord[1], this.m_coord[2]);
        this.m_evalx.m_data[n2] = (int)(this.m_texPoint.m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.99);
        this.m_evaly.m_data[n2] = (int)((1.0 - this.m_texPoint.m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.99);
    }

    public int[] getPixArray(int[] nArray) {
        return this.getPixArray(nArray, 10.0);
    }

    public int[] getPixArray(int[] nArray, double d) {
        int n;
        int n2;
        if (this.m_pix == null) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[this.m_pix.length];
        }
        if ((n2 = this.m_pix.length) > nArray.length) {
            n2 = nArray.length;
        }
        int[] nArray2 = new int[256];
        for (n = 0; n < 256; ++n) {
            nArray2[n] = (int)(256.0 / (1.0 + Math.exp(-d * (double)(n - 128) / 256.0)));
        }
        for (n = 0; n < n2; ++n) {
            int n3 = this.m_pix[n] >> 24 & 0xFF;
            int n4 = this.m_pix[n] & 0xFFFFFF;
            if (n3 != 0) {
                n4 /= n3;
            }
            if (n4 >= 255) {
                n4 = 255;
            } else if (n4 != 0) {
                n4 = nArray2[n4];
            }
            nArray[n] = -16777216 + (n4 << 16) + (n4 << 8) + n4;
        }
        return nArray;
    }

    public void makeLIC() {
        this.reset();
        int n = this.m_geom.getNumElements();
        for (int i = n - 1; i >= 0; --i) {
            this.makeElement(i);
        }
    }

    public void reset() {
        if (this.m_pix == null) {
            return;
        }
        for (int i = this.m_pix.length - 1; i >= 0; --i) {
            this.m_pix[i] = 0;
        }
    }

    public void makeFastLIC() {
        int n;
        this.reset();
        int n2 = this.m_geom.getNumElements();
        PdVector[] pdVectorArray = new PdVector[n2];
        PdBaryDir[] pdBaryDirArray = new PdBaryDir[n2];
        double[] dArray = new double[n2];
        PdVector[] pdVectorArray2 = new PdVector[3 * n2];
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = false;
            blArray2[n] = false;
        }
        for (n = n2 - 1; n >= 0; --n) {
            this.makeFastElement(n, pdVectorArray, pdBaryDirArray, dArray, pdVectorArray2, blArray, blArray2);
        }
    }

    public void makeFastElement(int n, PdVector[] pdVectorArray, PdBaryDir[] pdBaryDirArray, double[] dArray, PdVector[] pdVectorArray2, boolean[] blArray, boolean[] blArray2) {
        int n2;
        int n3;
        int n4;
        PiVector[] piVectorArray = this.m_geom.getNeighbours();
        PdVector[] pdVectorArray3 = this.m_texCoords[n];
        if (pdVectorArray3[0].m_data[0] == pdVectorArray3[1].m_data[0] && pdVectorArray3[0].m_data[0] == pdVectorArray3[2].m_data[0] && pdVectorArray3[0].m_data[1] == pdVectorArray3[1].m_data[1] && pdVectorArray3[0].m_data[1] == pdVectorArray3[2].m_data[1]) {
            return;
        }
        if (this.m_pix == null || this.m_pix.length != this.m_width * this.m_height) {
            this.m_pix = new int[this.m_width * this.m_height];
        }
        this.m_noise.preComputeNoise(this.m_coarseness, 0, 0, this.m_width - 1, this.m_height - 1);
        PsScanline psScanline = new PsScanline();
        int n5 = 3 * n;
        if (pdVectorArray2[n5] == null || !blArray2[n]) {
            if (pdVectorArray2[n5] == null) {
                pdVectorArray2[n5] = new PdVector(2);
                pdVectorArray2[n5 + 1] = new PdVector(2);
                pdVectorArray2[n5 + 2] = new PdVector(2);
            }
            pdVectorArray3 = this.m_texCoords[n];
            pdVectorArray2[n5].set((double)((int)(pdVectorArray3[0].m_data[0] * (double)(this.m_width - 1))), (double)((int)((1.0 - pdVectorArray3[0].m_data[1]) * (double)(this.m_height - 1))));
            pdVectorArray2[n5 + 1].set((double)((int)(pdVectorArray3[1].m_data[0] * (double)(this.m_width - 1))), (double)((int)((1.0 - pdVectorArray3[1].m_data[1]) * (double)(this.m_height - 1))));
            pdVectorArray2[n5 + 2].set((double)((int)(pdVectorArray3[2].m_data[0] * (double)(this.m_width - 1))), (double)((int)((1.0 - pdVectorArray3[2].m_data[1]) * (double)(this.m_height - 1))));
            blArray2[n] = true;
        }
        psScanline.makeScanlines((int)pdVectorArray2[n5].m_data[0], (int)pdVectorArray2[n5].m_data[1], (int)pdVectorArray2[n5 + 1].m_data[0], (int)pdVectorArray2[n5 + 1].m_data[1], (int)pdVectorArray2[n5 + 2].m_data[0], (int)pdVectorArray2[n5 + 2].m_data[1]);
        if (this.m_kernelwidthWorld < 0.0) {
            this.m_kernelwidthWorld = this.m_steplen * (double)this.m_kernelwidth;
        }
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = null;
        double[] dArray5 = null;
        int[] nArray = null;
        double d = this.m_integralh * 10.0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = -2;
        int n10 = -1;
        double d2 = 0.0;
        double d3 = 1.0E-10;
        double d4 = -d3;
        boolean bl = false;
        int n11 = psScanline.m_ymin;
        int n12 = psScanline.m_ymin * this.m_width;
        for (int i = 0; i < psScanline.m_length; ++i) {
            n4 = psScanline.m_xa[i];
            n3 = psScanline.m_xe[i];
            int n13 = n3 - n4;
            double d5 = psScanline.m_aAnteile[0][i];
            double d6 = psScanline.m_aAnteile[1][i];
            double d7 = psScanline.m_aAnteile[2][i];
            double d8 = ((double)psScanline.m_eAnteile[0][i] - d5) / (double)n13;
            double d9 = ((double)psScanline.m_eAnteile[1][i] - d6) / (double)n13;
            double d10 = ((double)psScanline.m_eAnteile[2][i] - d7) / (double)n13;
            int n14 = n12 + n4;
            for (n2 = n4; n2 <= n3; ++n2) {
                double d11 = n11;
                double d12 = n2;
                n7 = this.m_noise.getPreComputedNoise((int)d12, (int)d11);
                n6 = 1;
                double d13 = 0.0;
                if (n8 != n) {
                    n9 = -1;
                    n8 = n;
                }
                dArray2[0] = d5;
                dArray2[1] = d6;
                dArray2[2] = d7;
                n10 = -1;
                while (d13 < this.m_kernelwidthWorld) {
                    double d14;
                    if (n9 != n8) {
                        n9 = n8;
                        if (pdVectorArray[n8] == null || !blArray[n8]) {
                            if (pdBaryDirArray[n8] == null) {
                                pdBaryDirArray[n8] = new PdBaryDir(3);
                            }
                            this.m_rk.eval(n8, PdBary.TRIANGLE_CENTER, pdBaryDirArray[n8]);
                            n5 = 3 * n8;
                            pdVectorArray[n8] = PdBaryDir.getVector((PdVector)pdVectorArray[n8], (PdBaryDir)pdBaryDirArray[n8], (PdVector)pdVectorArray2[n5], (PdVector)pdVectorArray2[n5 + 1], (PdVector)pdVectorArray2[n5 + 2]);
                            dArray[n8] = PwBary.norm(this.m_geom, n8, pdBaryDirArray[n8], false);
                            if (dArray[n8] < d3 && dArray[n8] > d4) {
                                pdVectorArray[n8].m_data[0] = 0.0;
                                pdVectorArray[n8].m_data[1] = 0.0;
                                pdBaryDirArray[n8].m_data[0] = 0.0;
                                pdBaryDirArray[n8].m_data[1] = 0.0;
                                pdBaryDirArray[n8].m_data[2] = 0.0;
                            } else {
                                pdVectorArray[n8].multScalar(d * this.m_steplen / dArray[n8]);
                                pdBaryDirArray[n8].multScalar(d * this.m_steplen / dArray[n8]);
                            }
                            blArray[n8] = true;
                        }
                        dArray4 = pdVectorArray[n8].m_data;
                        dArray5 = pdBaryDirArray[n8].m_data;
                        nArray = piVectorArray[n8].m_data;
                        if (dArray4[0] < d3 && dArray4[0] > d4 && dArray4[1] < d3 && dArray4[1] > d4) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        d2 = d * this.m_steplen / dArray[n8];
                    }
                    if (bl) break;
                    dArray2[0] = dArray2[0] + dArray5[0];
                    dArray2[1] = dArray2[1] + dArray5[1];
                    dArray2[2] = dArray2[2] + dArray5[2];
                    n7 += this.m_noise.getPreComputedNoise((int)(d12 += dArray4[0]), (int)(d11 += dArray4[1]));
                    ++n6;
                    d13 += d2;
                    int n15 = -1;
                    if (dArray2[0] < 0.0) {
                        n15 = 0;
                    } else if (dArray2[1] < 0.0) {
                        n15 = 1;
                    } else if (dArray2[2] < 0.0) {
                        n15 = 2;
                    }
                    if (n15 == -1 || nArray[n15] == -1 || nArray[n15] == n10) continue;
                    n10 = n8;
                    n8 = nArray[n15];
                    nArray = piVectorArray[n8].m_data;
                    if (dArray5[n15] < d3 && dArray5[n15] > d4) {
                        d14 = dArray2[n15] / dArray5[n15];
                        dArray2[0] = dArray2[0] - dArray5[0] * d14;
                        dArray2[1] = dArray2[1] - dArray5[1] * d14;
                        dArray2[2] = dArray2[2] - dArray5[2] * d14;
                        d13 -= this.m_steplen / dArray[n9] * d14 / 2.0;
                    }
                    for (n5 = 0; n5 < 3 && piVectorArray[n8].m_data[n5] != n9; ++n5) {
                    }
                    dArray3[n5] = 0.0;
                    dArray3[(n5 + 1) % 3] = dArray2[(n15 + 2) % 3];
                    dArray3[(n5 + 2) % 3] = dArray2[(n15 + 1) % 3];
                    d14 = dArray3[0] + dArray3[1] + dArray3[2];
                    dArray2[0] = dArray3[0] / d14;
                    dArray2[1] = dArray3[1] / d14;
                    dArray2[2] = dArray3[2] / d14;
                    n5 = 3 * n8;
                    if (pdVectorArray2[n5] == null || !blArray2[n8]) {
                        if (pdVectorArray2[n5] == null) {
                            pdVectorArray2[n5] = new PdVector(2);
                            pdVectorArray2[n5 + 1] = new PdVector(2);
                            pdVectorArray2[n5 + 2] = new PdVector(2);
                        }
                        pdVectorArray3 = this.m_texCoords[n8];
                        pdVectorArray2[n5].set((double)((int)Math.round(pdVectorArray3[0].m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.49)), (double)((int)Math.round((1.0 - pdVectorArray3[0].m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.49)));
                        pdVectorArray2[n5 + 1].set((double)((int)Math.round(pdVectorArray3[1].m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.49)), (double)((int)Math.round((1.0 - pdVectorArray3[1].m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.49)));
                        pdVectorArray2[n5 + 2].set((double)((int)Math.round(pdVectorArray3[2].m_data[0] * ((double)(this.m_width - 1) - 0.98) + 0.49)), (double)((int)Math.round((1.0 - pdVectorArray3[2].m_data[1]) * ((double)(this.m_height - 1) - 0.98) + 0.49)));
                    }
                    d12 = dArray2[0] * pdVectorArray2[n5].m_data[0] + dArray2[1] * pdVectorArray2[n5 + 1].m_data[0] + dArray2[2] * pdVectorArray2[n5 + 2].m_data[0];
                    d11 = dArray2[0] * pdVectorArray2[n5].m_data[1] + dArray2[1] * pdVectorArray2[n5 + 1].m_data[1] + dArray2[2] * pdVectorArray2[n5 + 2].m_data[1];
                }
                this.m_pix[n14] = 0x1000000 + (n7 /= n6);
                ++n14;
                d5 += d8;
                d6 += d9;
                d7 += d10;
            }
            for (n6 = 1; n6 <= 2; ++n6) {
                if (n4 - n6 >= 0) {
                    this.m_pix[n12 + n4 - n6] = this.m_pix[n12 + n4];
                }
                if (n3 + n6 >= this.m_width) continue;
                this.m_pix[n12 + n3 + n6] = this.m_pix[n12 + n3];
            }
            ++n11;
            n12 += this.m_width;
        }
        if (psScanline.m_length >= 1) {
            n11 = psScanline.m_length + psScanline.m_ymin;
            if (n11 < this.m_height) {
                n4 = psScanline.m_xa[psScanline.m_length - 1];
                n3 = psScanline.m_xe[psScanline.m_length - 1];
                for (n2 = n4 - 2; n2 <= n3 + 2; ++n2) {
                    if (n2 < 0 || n2 >= this.m_width) continue;
                    int n16 = n11 * this.m_width + n2;
                    this.m_pix[n16] = this.m_pix[n16] + this.m_pix[(n11 - 1) * this.m_width + n2];
                }
            }
            if ((n11 = psScanline.m_ymin - 1) >= 0) {
                n4 = psScanline.m_xa[0];
                n3 = psScanline.m_xe[0];
                for (n2 = n4 - 2; n2 <= n3 + 2; ++n2) {
                    if (n2 < 0 || n2 >= this.m_width) continue;
                    int n17 = n11 * this.m_width + n2;
                    this.m_pix[n17] = this.m_pix[n17] + this.m_pix[(n11 + 1) * this.m_width + n2];
                }
            }
        }
    }
}

