/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgDxfLoader
extends PgAbstractLoader {
    protected static final int ENTITY_LINE = 100;
    protected static final int ENTITY_POINT = 101;
    protected static final int ENTITY_CIRCLE = 102;
    protected static final int ENTITY_ARC = 103;
    protected static final int ENTITY_TRACE = 104;
    protected static final int ENTITY_SOLID = 105;
    protected static final int ENTITY_TEXT = 106;
    protected static final int ENTITY_SHAPE = 107;
    protected static final int ENTITY_BLOCK = 108;
    protected static final int ENTITY_ENDBLK = 109;
    protected static final int ENTITY_INSERT = 110;
    protected static final int ENTITY_ATTDEF = 111;
    protected static final int ENTITY_ATTRIB = 112;
    protected static final int ENTITY_POLYLINE = 113;
    protected static final int ENTITY_VERTEX = 114;
    protected static final int ENTITY_SEQEND = 115;
    protected static final int ENTITY_3DFACE = 116;
    protected static final int ENTITY_VIEWPORT = 117;
    protected static final int ENTITY_DIMENSION = 118;
    protected static final int ENTITY_LINEAR = 119;
    protected static final int ENTITY_ANGULAR = 120;
    protected static final int ENTITY_DIAMETER = 121;
    protected static final int ENTITY_RADIUS = 122;
    protected static final int ENTITY_ORDINATE = 123;
    protected static final int ENTITY_LWPOLYLINE = 124;
    protected static final int ENTITY_RAY = 125;
    protected static final int ENTITY_HATCH = 126;
    protected int m_numVertices = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected Vector m_vVertex;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    private int m_code;
    private int m_ival;
    private double m_dval;
    private String m_sval;

    public PgDxfLoader() {
        this.m_bIsEnabledOptimization = true;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.parse(bufferedReader);
        if (pgJvxSrcArray == null) {
            PsDebug.warning((String)"error during parsing of reader");
            return null;
        }
        return pgJvxSrcArray;
    }

    /*
     * Unable to fully structure code
     */
    protected PgJvxSrc[] parse(BufferedReader var1_1) {
        var2_2 = new StreamTokenizer(var1_1);
        var2_2.eolIsSignificant(true);
        var2_2.commentChar(35);
        var2_2.quoteChar(34);
        var2_2.ordinaryChar(45);
        var2_2.ordinaryChar(43);
        var2_2.ordinaryChar(46);
        var2_2.ordinaryChars(48, 48);
        var2_2.ordinaryChars(49, 57);
        var2_2.wordChars(94, 94);
        var2_2.wordChars(38, 38);
        var2_2.wordChars(36, 36);
        var2_2.wordChars(40, 40);
        var2_2.wordChars(41, 41);
        var2_2.wordChars(91, 91);
        var2_2.wordChars(93, 93);
        var2_2.wordChars(126, 126);
        var2_2.wordChars(64, 64);
        var2_2.wordChars(45, 45);
        var2_2.wordChars(43, 43);
        var2_2.wordChars(42, 42);
        var2_2.wordChars(48, 48);
        var2_2.wordChars(49, 57);
        var2_2.wordChars(46, 46);
        var2_2.wordChars(44, 44);
        var2_2.wordChars(59, 59);
        var2_2.wordChars(95, 95);
        var2_2.wordChars(58, 58);
        var2_2.whitespaceChars(44, 44);
        var2_2.whitespaceChars(61, 61);
        var3_3 = new Vector<Object>();
        var4_4 = new Vector<Object>();
        var5_5 = null;
        var6_6 = false;
        try {
            block16: while (true) {
                block236: {
                    if ((var7_7 = this.parseGroup(var2_2)) == 999) {
                        continue;
                    }
                    if (var7_7 == 0) {
                        if (this.m_sval.equals("SECTION") || this.m_sval.equals("TABLE") || this.m_sval.equals("ENDTAB")) continue;
                        if (this.m_sval.equals("EOF")) {
                            var10_13 = new PgJvxSrc[var3_3.size()];
                            var8_8 = 0;
                            var11_15 = var3_3.elements();
                            while (var11_15.hasMoreElements()) {
                                var10_13[var8_8++] = (PgJvxSrc)var11_15.nextElement();
                            }
                            PsDebug.notify((String)"... finished");
                            return var10_13;
                        }
                        if (this.m_sval.equals("LINE") || this.m_sval.equals("3DFACE") || !this.m_sval.equals("LAYER")) continue;
                        continue;
                    }
                    if (var7_7 != 2) continue;
                    if (!this.m_sval.equals("HEADER")) break block236;
                    var7_7 = this.parseGroup(var2_2);
                    while (true) {
                        block237: {
                            if (var7_7 == 0 && this.m_sval.equals("ENDSEC") || var2_2.ttype == -1) continue block16;
                            if (var7_7 != 9) break block237;
                            if (!this.m_sval.equals("$ACADVER")) ** GOTO lbl65
                            var7_7 = this.parseGroup(var2_2);
                            if (var7_7 == 1) {
                                if (!this.m_sval.equals("AC1006") && !this.m_sval.equals("AC1008") && this.m_sval.equals("AC1009")) {
                                    // empty if block
                                }
                            } else {
                                throw new IOException("unexpected code=" + var7_7 + " in group=" + this.m_sval + " at line=" + var2_2.lineno());
lbl65:
                                // 1 sources

                                if (this.m_sval.equals("$ANGBASE") || this.m_sval.equals("$ANGDIR") || this.m_sval.equals("$ATTDIA") || this.m_sval.equals("$ATTMODE") || this.m_sval.equals("$ATTREQ") || this.m_sval.equals("$AUNITS") || this.m_sval.equals("$AUPREC") || this.m_sval.equals("$AXISMODE") || this.m_sval.equals("$AXISUNIT") || this.m_sval.equals("$BLIPMODE") || this.m_sval.equals("$CECOLOR") || this.m_sval.equals("$CELTYPE") || this.m_sval.equals("$CHAMFERA") || this.m_sval.equals("$CHAMFERB") || this.m_sval.equals("$CLAYER") || this.m_sval.equals("$COORDS") || this.m_sval.equals("$DIMALT") || this.m_sval.equals("$DIMALTD") || this.m_sval.equals("$DIMALTF") || this.m_sval.equals("$DIMAPOST") || this.m_sval.equals("$DIMASO") || this.m_sval.equals("$DIMASZ") || this.m_sval.equals("$DIMBLK") || this.m_sval.equals("$DIMBLK1") || this.m_sval.equals("$DIMBLK2") || this.m_sval.equals("$DIMCEN") || this.m_sval.equals("$DIMCLRD") || this.m_sval.equals("$DIMCLRE") || this.m_sval.equals("$DIMCLRT") || this.m_sval.equals("$DIMDLE") || this.m_sval.equals("$DIMDLI") || this.m_sval.equals("$DIMEXE") || this.m_sval.equals("$DIMEXO") || this.m_sval.equals("$DIMGAP") || this.m_sval.equals("$DIMLFAC") || this.m_sval.equals("$DIMLIM") || this.m_sval.equals("$DIMPOST") || this.m_sval.equals("$DIMRND") || this.m_sval.equals("$DIMSAH") || this.m_sval.equals("$DIMSCALE") || this.m_sval.equals("$DIMSE1") || this.m_sval.equals("$DIMSE2") || this.m_sval.equals("$DIMSHO") || this.m_sval.equals("$DIMSOXD") || this.m_sval.equals("$DIMSTYLE") || this.m_sval.equals("$DIMTAD") || this.m_sval.equals("$DIMTFAC") || this.m_sval.equals("$DIMTIH") || this.m_sval.equals("$DIMTIX") || this.m_sval.equals("$DIMTM") || this.m_sval.equals("$DIMTOFL") || this.m_sval.equals("$DIMTOH") || this.m_sval.equals("$DIMTOL") || this.m_sval.equals("$DIMTP") || this.m_sval.equals("$DIMTSZ") || this.m_sval.equals("$DIMTVP") || this.m_sval.equals("$DIMTXT") || this.m_sval.equals("$DIMZIN") || this.m_sval.equals("$DWGCODEPAGE") || this.m_sval.equals("$DRAGMODE") || this.m_sval.equals("$ELEVATION") || this.m_sval.equals("$EXTMAX") || this.m_sval.equals("$EXTMIN") || this.m_sval.equals("$FILLETRAD") || this.m_sval.equals("$FILLMODE") || this.m_sval.equals("$HANDLING") || this.m_sval.equals("$HANDSEED") || this.m_sval.equals("$INSBASE") || this.m_sval.equals("$LIMCHECK") || this.m_sval.equals("$LIMMAX") || this.m_sval.equals("$LIMMIN") || this.m_sval.equals("$LTSCALE") || this.m_sval.equals("$LUNITS") || this.m_sval.equals("$LUPREC") || this.m_sval.equals("$MAXACTVP") || this.m_sval.equals("$MENU") || this.m_sval.equals("$MIRRTEXT") || this.m_sval.equals("$ORTHOMODE") || this.m_sval.equals("$OSMODE") || this.m_sval.equals("$PDMODE") || this.m_sval.equals("$PDSIZE") || this.m_sval.equals("$PELEVATION") || this.m_sval.equals("$PEXTMAX") || this.m_sval.equals("$PEXTMIN") || this.m_sval.equals("$PLIMCHECK") || this.m_sval.equals("$PLIMMAX") || this.m_sval.equals("$PLIMMIN") || this.m_sval.equals("$PLINEGEN") || this.m_sval.equals("$PLINEWID") || this.m_sval.equals("$PSLTSCALE") || this.m_sval.equals("$PUCSNAME") || this.m_sval.equals("$PUCSORG") || this.m_sval.equals("$PUCSXDIR") || this.m_sval.equals("$PUCSYDIR") || this.m_sval.equals("$QTEXTMODE") || this.m_sval.equals("$REGENMODE") || this.m_sval.equals("$SHADEDGE") || this.m_sval.equals("$SHADEDIF") || this.m_sval.equals("$SKETCHINC") || this.m_sval.equals("$SKPOLY") || this.m_sval.equals("$SPLFRAME") || this.m_sval.equals("$SPLINESEGS") || this.m_sval.equals("$SPLINETYPE") || this.m_sval.equals("$SURFTAB1") || this.m_sval.equals("$SURFTAB2") || this.m_sval.equals("$SURFTYPE") || this.m_sval.equals("$SURFU") || this.m_sval.equals("$SURFV") || this.m_sval.equals("$TDCREATE") || this.m_sval.equals("$TDINDWG") || this.m_sval.equals("$TDUPDATE") || this.m_sval.equals("$TDUSRTIMER") || this.m_sval.equals("$TEXTSIZE") || this.m_sval.equals("$TEXTSTYLE") || this.m_sval.equals("$THICKNESS") || this.m_sval.equals("$TILEMODE") || this.m_sval.equals("$TRACEWID") || this.m_sval.equals("$UCSNAME") || this.m_sval.equals("$UCSORG") || this.m_sval.equals("$UCSXDIR") || this.m_sval.equals("$UCSYDIR") || this.m_sval.equals("$UNITMODE") || this.m_sval.equals("$USERI1") || this.m_sval.equals("$USERI2") || this.m_sval.equals("$USERI3") || this.m_sval.equals("$USERI4") || this.m_sval.equals("$USERI5") || this.m_sval.equals("$USERR1") || this.m_sval.equals("$USERR2") || this.m_sval.equals("$USERR3") || this.m_sval.equals("$USERR4") || this.m_sval.equals("$USERR5") || this.m_sval.equals("$USRTIMER") || this.m_sval.equals("$VISRETAIN") || this.m_sval.equals("$WORLDVIEW")) {
                                    // empty if block
                                }
                            }
                        }
                        var7_7 = this.parseGroup(var2_2);
                    }
                }
                if (this.m_sval.equals("CLASSES")) {
                    var7_7 = this.parseGroup(var2_2);
                    while (true) {
                        if (var7_7 == 0 && this.m_sval.equals("ENDSEC") || var2_2.ttype == -1) continue block16;
                        var7_7 = this.parseGroup(var2_2);
                    }
                }
                if (this.m_sval.equals("OBJECTS")) {
                    var7_7 = this.parseGroup(var2_2);
                    while (true) {
                        if (var7_7 == 0 && this.m_sval.equals("ENDSEC") || var2_2.ttype == -1) continue block16;
                        var7_7 = this.parseGroup(var2_2);
                    }
                }
                if (this.m_sval.equals("TABLES")) {
                    var7_7 = this.parseGroup(var2_2);
                    while (true) {
                        if (var7_7 == 0 && this.m_sval.equals("ENDSEC") || var2_2.ttype == -1) continue block16;
                        var7_7 = this.parseGroup(var2_2);
                    }
                }
                if (this.m_sval.equals("BLOCKS")) {
                    var7_7 = this.parseGroup(var2_2);
                    while (true) {
                        if (var7_7 == 0 && this.m_sval.equals("ENDSEC") || var2_2.ttype == -1) continue block16;
                        var7_7 = this.parseGroup(var2_2);
                    }
                }
                if (this.m_sval.equals("ENTITIES")) {
                    this.m_numVertices = 0;
                    this.m_numElements = 0;
                    var10_12 = 0;
                    var11_14 = 0;
                    var12_16 = false;
                    var13_17 = false;
                    var14_18 = 0;
                    var15_19 = 0;
                    var16_20 = 0;
                    var17_21 = 0;
                    this.m_vVertex = new Vector<E>();
                    this.m_vElement = new Vector<E>();
                    this.m_vPolygon = new Vector<E>();
                    var18_22 = new PgJvxSrc();
                    var19_23 = 0;
                    var20_24 = 2;
                    var21_25 = 0.0;
                    var23_26 = 0.0;
                    var25_27 = 0.0;
                    var27_28 = null;
                    var28_29 = null;
                    var29_30 = null;
                    var30_31 = new double[400][3];
                    var31_32 = -1;
                    var32_33 = -1;
                    var7_7 = this.parseGroup(var2_2);
                    var33_34 = new PiVector(10);
                    var34_35 = new PiVector(10);
                    var35_36 = var34_35.m_data;
                    var36_37 = new PiVector(10);
                    var36_37.setConstant(0);
                    var37_38 = var36_37.m_data;
                    var38_39 = new PiVector(10);
                    var38_39.setConstant(0);
                    var39_40 = var38_39.m_data;
                    while (true) {
                        if (var2_2.ttype == -1) continue block16;
                        if (var7_7 == 0) {
                            if (var31_32 != -1) {
                                if (var31_32 == 100) {
                                    if (var19_23 != 2) {
                                        throw new IOException("unexpected num vertices of LINE or MLINE = " + var19_23 + " at line=" + var2_2.lineno());
                                    }
                                    var40_41 = new PgJvxSrc(var20_24);
                                    var40_41.init();
                                    var40_41.setName("Line: Layer=" + var28_29 + ", Name=" + var29_30);
                                    var40_41.setType(31);
                                    if (var6_6) {
                                        var40_41.setGlobalPolygonColor(var5_5);
                                        var6_6 = false;
                                    }
                                    var40_41.showPolygons(true);
                                    var40_41.setNumVertices(var19_23);
                                    for (var41_42 = 0; var41_42 < var19_23; ++var41_42) {
                                        var42_53 = new PdVector(var30_31[var41_42]);
                                        if (var20_24 == 2) {
                                            var42_53.setSize(var20_24);
                                        }
                                        var40_41.setVertex(var41_42, var42_53);
                                    }
                                    var3_3.addElement(var40_41);
                                } else if (var31_32 == 125) {
                                    if (var19_23 != 2) {
                                        throw new IOException("unexpected num vertices of RAY or MLINE = " + var19_23 + " at line=" + var2_2.lineno());
                                    }
                                    var40_41 = new PgJvxSrc(var20_24);
                                    var40_41.init();
                                    var40_41.setName("Ray: Layer=" + var28_29 + ", Name=" + var29_30);
                                    var40_41.setType(31);
                                    if (var6_6) {
                                        var40_41.setGlobalPolygonColor(var5_5);
                                        var6_6 = false;
                                    }
                                    var40_41.showPolygons(true);
                                    var40_41.setNumVertices(var19_23);
                                    for (var41_43 = 0; var41_43 < var19_23; ++var41_43) {
                                        var42_54 = new PdVector(var30_31[var41_43]);
                                        if (var20_24 == 2) {
                                            var42_54.setSize(var20_24);
                                        }
                                        var40_41.setVertex(var41_43, var42_54);
                                    }
                                    var40_41.getVertex(1).add(var40_41.getVertex(0));
                                    var3_3.addElement(var40_41);
                                } else if (var31_32 == 101) {
                                    if (var19_23 != 1) {
                                        throw new IOException("unexpected num vertices of POINT = " + var19_23 + " at line=" + var2_2.lineno());
                                    }
                                    var40_41 = new PgJvxSrc(var20_24);
                                    var40_41.init();
                                    var40_41.setName("Point: Layer=" + var28_29 + ", Name=" + var29_30);
                                    var40_41.setType(30);
                                    if (var6_6) {
                                        var40_41.setGlobalVertexColor(var5_5);
                                        var6_6 = false;
                                    }
                                    var40_41.showVertices(true);
                                    var40_41.showVertexOutline(false);
                                    var40_41.setGlobalVertexSize(1.0);
                                    var40_41.setNumVertices(1);
                                    var41_44 = new PdVector(var30_31[0]);
                                    if (var20_24 == 2) {
                                        var41_44.setSize(var20_24);
                                    }
                                    var40_41.setVertex(0, var41_44);
                                    var3_3.addElement(var40_41);
                                } else if (var31_32 == 102) {
                                    if (var19_23 != 1) {
                                        throw new IOException("unexpected num vertices of CIRCLE = " + var19_23 + " at line=" + var2_2.lineno());
                                    }
                                    var40_41 = new PgJvxSrc(var20_24);
                                    var40_41.init();
                                    var40_41.setName("Circle: Layer=" + var28_29 + ", Name=" + var29_30);
                                    var40_41.setType(31);
                                    if (var6_6) {
                                        var40_41.setGlobalPolygonColor(var5_5);
                                        var6_6 = false;
                                    }
                                    var40_41.showPolygons(true);
                                    var41_45 = 100;
                                    var40_41.setNumVertices(var41_45);
                                    var42_55 = var21_25;
                                    var44_60 = 6.283185307179586 / (double)(var41_45 - 1);
                                    for (var46_61 = 0; var46_61 < var41_45; ++var46_61) {
                                        var47_63 = new PdVector(var20_24);
                                        var47_63.setEntry(0, var30_31[0][0] + var42_55 * Math.cos(var44_60 * (double)var46_61));
                                        var47_63.setEntry(1, var30_31[0][1] + var42_55 * Math.sin(var44_60 * (double)var46_61));
                                        if (var20_24 == 3) {
                                            var47_63.setEntry(2, var30_31[0][2]);
                                        }
                                        var40_41.setVertex(var46_61, var47_63);
                                    }
                                    var3_3.addElement(var40_41);
                                } else if (var31_32 == 103) {
                                    if (var19_23 != 1) {
                                        throw new IOException("unexpected num vertices of ARC = " + var19_23 + " at line=" + var2_2.lineno());
                                    }
                                    var40_41 = new PgJvxSrc(var20_24);
                                    var40_41.init();
                                    var40_41.setName("Arc: Layer=" + var28_29 + ", Name=" + var29_30);
                                    var40_41.setType(31);
                                    if (var6_6) {
                                        var40_41.setGlobalPolygonColor(var5_5);
                                        var6_6 = false;
                                    }
                                    var40_41.showPolygons(true);
                                    var41_46 = 50;
                                    var40_41.setNumVertices(var41_46);
                                    var42_56 = var21_25;
                                    var44_60 = var23_26 * 3.141592653589793 / 180.0;
                                    var46_62 = var25_27 * 3.141592653589793 / 180.0;
                                    if (var46_62 < var44_60) {
                                        var46_62 += 6.283185307179586;
                                    }
                                    var48_64 = (var46_62 - var44_60) / (double)(var41_46 - 1);
                                    for (var50_65 = 0; var50_65 < var41_46; ++var50_65) {
                                        var51_66 = new PdVector(var20_24);
                                        var51_66.setEntry(0, var30_31[0][0] + var42_56 * Math.cos(var44_60 + var48_64 * (double)var50_65));
                                        var51_66.setEntry(1, var30_31[0][1] + var42_56 * Math.sin(var44_60 + var48_64 * (double)var50_65));
                                        if (var20_24 == 3) {
                                            var51_66.setEntry(2, var30_31[0][2]);
                                        }
                                        var40_41.setVertex(var50_65, var51_66);
                                    }
                                    var3_3.addElement(var40_41);
                                } else if (var31_32 != 104) {
                                    if (var31_32 == 105) {
                                        if (var19_23 < 2) {
                                            throw new IOException("unexpected num vertices of LINE = " + var19_23 + " at line=" + var2_2.lineno());
                                        }
                                        var40_41 = new PgJvxSrc(var20_24);
                                        var40_41.init();
                                        var40_41.setName("Solid: Layer=" + var28_29 + ", Name=" + var29_30);
                                        var40_41.setType(33);
                                        if (var6_6) {
                                            var40_41.setGlobalPolygonColor(var5_5);
                                            var6_6 = false;
                                        } else {
                                            var40_41.setGlobalElementColor(Color.black);
                                        }
                                        var40_41.showElements(true);
                                        var40_41.setNumVertices(var19_23);
                                        var40_41.setNumElements(1);
                                        var41_47 = new PiVector(var19_23);
                                        for (var42_57 = 0; var42_57 < var19_23; ++var42_57) {
                                            var43_59 = new PdVector(var30_31[var42_57]);
                                            if (var20_24 == 2) {
                                                var43_59.setSize(var20_24);
                                            }
                                            var40_41.setVertex(var42_57, var43_59);
                                            var41_47.setEntry(var42_57, var42_57);
                                        }
                                        var40_41.setElement(0, var41_47);
                                        var3_3.addElement(var40_41);
                                    } else if (var31_32 == 106) {
                                        if ((var39_40[2] != 0 || var39_40[3] != 0) && var19_23 != 2 || var39_40[2] == 0 && var39_40[3] == 0 && var19_23 != 1) {
                                            throw new IOException("unexpected num vertices of TEXT = " + var19_23 + " at line=" + var2_2.lineno());
                                        }
                                        var40_41 = new PgJvxSrc(var20_24);
                                        var40_41.init();
                                        var40_41.setName("Text: Layer=" + var28_29 + ", Name=" + var29_30);
                                        if (var6_6) {
                                            var40_41.setLabelColor(5, var5_5);
                                            var6_6 = false;
                                        }
                                        if (var27_28 != null) {
                                            var40_41.showName(true);
                                            var40_41.setName(var27_28);
                                        }
                                        var40_41.setType(30);
                                        var40_41.setGlobalVertexSize(1.0);
                                        var40_41.showVertices(false);
                                        var40_41.setNumVertices(1);
                                        var41_48 = new PdVector(var30_31[0]);
                                        if (var20_24 == 2) {
                                            var41_48.setSize(var20_24);
                                        }
                                        var40_41.setVertex(0, var41_48);
                                        var3_3.addElement(var40_41);
                                    } else if (var31_32 != 107 && var31_32 != 108 && var31_32 != 109 && var31_32 != 110 && var31_32 != 111 && var31_32 != 112) {
                                        if (var31_32 == 113) {
                                            var33_34.set(var37_38);
                                            var34_35.set(var39_40);
                                            if ((var35_36[0] & 16) != 0) {
                                                var10_12 = var35_36[1];
                                                var11_14 = var35_36[2];
                                                var16_20 = var10_12 * var11_14;
                                                if ((var35_36[0] & 1) != 0) {
                                                    var12_16 = true;
                                                }
                                                if ((var35_36[0] & 32) != 0) {
                                                    var13_17 = true;
                                                }
                                            } else if ((var35_36[0] & 64) != 0) {
                                                var16_20 = var35_36[1];
                                                var17_21 = var35_36[2];
                                            }
                                            var36_37.setConstant(0);
                                            var38_39.setConstant(0);
                                        } else if (this.m_sval.equals("LWPOLYLINE")) {
                                            if (var19_23 > 0) {
                                                var40_41 = new PgJvxSrc(var20_24);
                                                var40_41.init();
                                                var40_41.setName("LWPolyline: Layer=" + var28_29 + ", Name=" + var29_30);
                                                var40_41.setType(31);
                                                if (var6_6) {
                                                    var40_41.setGlobalPolygonColor((Color)var5_5);
                                                    var6_6 = false;
                                                }
                                                var40_41.setName("LWPOLYLINE");
                                                var40_41.showName(true);
                                                var40_41.showPolygons(true);
                                                var40_41.setNumVertices(var19_23);
                                                for (var41_49 = 0; var41_49 < var19_23; ++var41_49) {
                                                    var42_58 = new PdVector(var30_31[var41_49]);
                                                    if (var20_24 == 2) {
                                                        var42_58.setSize(var20_24);
                                                    }
                                                    var40_41.setVertex(var41_49, var42_58);
                                                }
                                                var3_3.addElement(var40_41);
                                            }
                                        } else if (var31_32 == 114) {
                                            if (var32_33 == 113) {
                                                if ((var39_40[0] & 64) != 0) {
                                                    var40_41 = new PdVector(var30_31[0]);
                                                    this.m_vVertex.addElement(var40_41);
                                                    ++this.m_numVertices;
                                                    ++var14_18;
                                                } else if ((var39_40[0] & 128) != 0) {
                                                    if ((var39_40[0] & 64) != 0) {
                                                        var40_41 = new PdVector(var30_31[0]);
                                                        this.m_vVertex.addElement(var40_41);
                                                        ++this.m_numVertices;
                                                        ++var14_18;
                                                    } else {
                                                        var40_41 = new PiVector();
                                                        if (var39_40[4] == 0) {
                                                            var40_41.setSize(3);
                                                            var40_41.set(Math.abs(var39_40[1]) - 1, Math.abs(var39_40[2]) - 1, Math.abs(var39_40[3]) - 1);
                                                        } else {
                                                            var40_41.setSize(4);
                                                            var40_41.set(Math.abs(var39_40[1]) - 1, Math.abs(var39_40[2]) - 1, Math.abs(var39_40[3]) - 1, Math.abs(var39_40[4]) - 1);
                                                        }
                                                        this.m_vElement.addElement(var40_41);
                                                        ++this.m_numElements;
                                                        ++var15_19;
                                                    }
                                                } else {
                                                    var40_41 = new PdVector(var30_31[0]);
                                                    this.m_vVertex.addElement(var40_41);
                                                    ++this.m_numVertices;
                                                }
                                            } else {
                                                if (var19_23 != 1) {
                                                    throw new IOException("missing vertex, nov = " + var19_23);
                                                }
                                                var40_41 = new PdVector(var30_31[0]);
                                                this.m_vVertex.addElement(var40_41);
                                                ++this.m_numVertices;
                                            }
                                        } else if (var31_32 == 115) {
                                            if (var32_33 == 113) {
                                                if (((var35_36[0] & 64) != 0 || (var35_36[0] & 16) != 0) && var14_18 != var16_20) {
                                                    PsDebug.warning((String)("unexpected number of vertices in polymesh: (expected/found)=(" + var16_20 + "/" + var14_18));
                                                }
                                                if ((var35_36[0] & 64) != 0 && var15_19 != var17_21) {
                                                    PsDebug.warning((String)("unexpected number of elements in polymesh: (expected/found)=(" + var17_21 + "/" + var15_19));
                                                }
                                                var40_41 = new PgJvxSrc();
                                                var40_41.init();
                                                var40_41.setName("Polyline: Layer=" + var28_29 + ", Name=" + var29_30);
                                                if (this.m_numVertices > 0) {
                                                    var40_41.setNumVertices(this.m_numVertices);
                                                    var8_8 = 0;
                                                    var41_50 = this.m_vVertex.elements();
                                                    while (var41_50.hasMoreElements()) {
                                                        var40_41.setVertex(var8_8++, (PdVector)var41_50.nextElement());
                                                    }
                                                }
                                                if ((var35_36[0] & 16) != 0) {
                                                    var40_41.setType(33);
                                                    if (var6_6) {
                                                        var40_41.setGlobalElementColor((Color)var5_5);
                                                    }
                                                    var40_41.makeQuadrConn(var10_12, var11_14, var12_16, var13_17);
                                                } else if (this.m_numElements > 0) {
                                                    var40_41.setType(33);
                                                    if (var6_6) {
                                                        var40_41.setGlobalElementColor((Color)var5_5);
                                                    }
                                                    var40_41.setDimOfElements(this.m_dimOfElements);
                                                    var40_41.setNumElements(this.m_numElements);
                                                    var8_8 = 0;
                                                    var41_51 = this.m_vElement.elements();
                                                    while (var41_51.hasMoreElements()) {
                                                        var40_41.setElement(var8_8++, (PiVector)var41_51.nextElement());
                                                    }
                                                } else {
                                                    var40_41.setType(31);
                                                    if (var6_6) {
                                                        var40_41.setGlobalPolygonColor((Color)var5_5);
                                                    }
                                                    var40_41.showPolygons(true);
                                                }
                                                var3_3.addElement(var40_41);
                                                this.m_numVertices = 0;
                                                this.m_numElements = 0;
                                                this.m_vVertex.removeAllElements();
                                                this.m_vElement.removeAllElements();
                                                var14_18 = 0;
                                                var15_19 = 0;
                                            }
                                            var32_33 = -1;
                                        } else {
                                            if (var31_32 == 116) {
                                                if (var19_23 != 4) {
                                                    throw new IOException("missing vertex, nov = " + var19_23);
                                                }
                                                for (var9_9 = 0; var9_9 < 4; ++var9_9) {
                                                    var40_41 = new PdVector(var30_31[var9_9]);
                                                    this.m_vVertex.addElement(var40_41);
                                                }
                                                var40_41 = new PiVector(var19_23);
                                                var40_41.set(this.m_numVertices, this.m_numVertices + 1, this.m_numVertices + 2, this.m_numVertices + 3);
                                                this.m_vElement.addElement(var40_41);
                                                if (var6_6) {
                                                    var4_4.addElement(var5_5);
                                                }
                                                this.m_numVertices += 4;
                                                ++this.m_numElements;
                                                ** if (var39_40[0] == 0) goto lbl459
                                            }
                                            if (var31_32 == 117 || var31_32 == 118 || var31_32 == 119 || var31_32 == 120 || var31_32 == 120 || var31_32 == 121 || var31_32 == 122 || var31_32 == 123) {
                                                // empty if block
                                            } else {
                                                ** GOTO lbl459
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                // empty if block
                                            }
                                        }
                                    }
                                }
lbl459:
                                // 24 sources

                                var31_32 = -1;
                                var36_37.setConstant(0);
                                var38_39.setConstant(0);
                            }
                            if (this.m_sval.equals("ENDSEC")) {
                                if (this.m_numVertices <= 0) continue block16;
                                var18_22.setType(33);
                                if (this.m_numVertices > 0) {
                                    var18_22.setNumVertices(this.m_numVertices);
                                    var8_8 = 0;
                                    var40_41 = this.m_vVertex.elements();
                                    while (var40_41.hasMoreElements()) {
                                        var18_22.setVertex(var8_8++, (PdVector)var40_41.nextElement());
                                    }
                                }
                                if (this.m_numElements > 0) {
                                    var18_22.setDimOfElements(this.m_dimOfElements);
                                    var18_22.setNumElements(this.m_numElements);
                                    var8_8 = 0;
                                    var40_41 = this.m_vElement.elements();
                                    while (var40_41.hasMoreElements()) {
                                        var18_22.setElement(var8_8++, (PiVector)var40_41.nextElement());
                                    }
                                    if (var4_4.size() == this.m_numElements) {
                                        var18_22.showElementColors(true);
                                        var8_8 = 0;
                                        var40_41 = new Color[this.m_numElements];
                                        var41_52 = var4_4.elements();
                                        while (var41_52.hasMoreElements()) {
                                            var40_41[var8_8++] = (Color)var41_52.nextElement();
                                        }
                                        var18_22.setElementColors((Color[])var40_41);
                                        var4_4.setSize(0);
                                    }
                                }
                                var3_3.addElement(var18_22);
                                this.m_numVertices = 0;
                                this.m_numElements = 0;
                                this.m_vVertex.removeAllElements();
                                this.m_vElement.removeAllElements();
                                var18_22 = null;
                                continue block16;
                            }
                            var6_6 = false;
                            var19_23 = 0;
                            var20_24 = 2;
                            var27_28 = null;
                            var28_29 = null;
                            var29_30 = null;
                            if (this.m_sval.equals("LINE") || this.m_sval.equals("MLINE")) {
                                var31_32 = 100;
                            } else if (this.m_sval.equals("RAY") || this.m_sval.equals("XLINE")) {
                                var31_32 = 125;
                            } else if (this.m_sval.equals("POINT")) {
                                var31_32 = 101;
                            } else if (this.m_sval.equals("CIRCLE")) {
                                var31_32 = 102;
                            } else if (this.m_sval.equals("ARC")) {
                                var31_32 = 103;
                            } else if (this.m_sval.equals("TRACE")) {
                                var31_32 = 104;
                            } else if (this.m_sval.equals("SOLID")) {
                                var31_32 = 105;
                            } else if (this.m_sval.equals("TEXT") || this.m_sval.equals("MTEXT")) {
                                var31_32 = 106;
                            } else if (this.m_sval.equals("SHAPE")) {
                                var31_32 = 107;
                            } else if (this.m_sval.equals("BLOCK")) {
                                var31_32 = 108;
                            } else if (this.m_sval.equals("ENDBLK")) {
                                var31_32 = 109;
                            } else if (this.m_sval.equals("INSERT")) {
                                var31_32 = 110;
                            } else if (this.m_sval.equals("ATTDEF")) {
                                var31_32 = 111;
                            } else if (this.m_sval.equals("ATTRIB")) {
                                var31_32 = 112;
                            } else if (this.m_sval.equals("POLYLINE")) {
                                var32_33 = 113;
                                var31_32 = 113;
                            } else if (this.m_sval.equals("LWPOLYLINE")) {
                                var32_33 = 124;
                                var31_32 = 124;
                            } else if (this.m_sval.equals("VERTEX")) {
                                var31_32 = 114;
                            } else if (this.m_sval.equals("SEQEND")) {
                                var31_32 = 115;
                            } else if (this.m_sval.equals("3DFACE")) {
                                var31_32 = 116;
                            } else if (this.m_sval.equals("VIEWPORT")) {
                                var31_32 = 117;
                            } else if (this.m_sval.equals("DIMENSION")) {
                                var31_32 = 118;
                            } else if (this.m_sval.equals("LINEAR")) {
                                var31_32 = 119;
                            } else if (this.m_sval.equals("ANGULAR")) {
                                var31_32 = 120;
                            } else if (this.m_sval.equals("ANGULAR")) {
                                var31_32 = 120;
                            } else if (this.m_sval.equals("DIAMETER")) {
                                var31_32 = 121;
                            } else if (this.m_sval.equals("RADIUS")) {
                                var31_32 = 122;
                            } else if (this.m_sval.equals("ORDINATE")) {
                                var31_32 = 123;
                            } else if (this.m_sval.equals("HATCH")) {
                                var31_32 = 126;
                            } else {
                                PsDebug.warning((String)("unexpected group=" + this.m_sval + " at line=" + var2_2.lineno() + ", skipped"));
                                while (!(this.m_sval != null && this.m_sval.equals("ENDSEC") || var2_2.ttype == -1)) {
                                    var7_7 = this.parseGroup(var2_2);
                                }
                            }
                        } else if (var7_7 == 1) {
                            var27_28 = this.m_sval;
                        } else if (var7_7 == 2) {
                            var29_30 = this.m_sval;
                        } else if (var7_7 != 5 && var7_7 != 6) {
                            if (var7_7 == 8) {
                                var28_29 = this.m_sval;
                            } else if (var7_7 == 10) {
                                var30_31[var19_23][0] = this.m_dval;
                                var7_7 = this.parseGroup(var2_2);
                                if (var7_7 != 20) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var30_31[var19_23][1] = this.m_dval;
                                var2_2.nextToken();
                                var2_2.pushBack();
                                if (var2_2.sval != null && var2_2.sval.equals("30")) {
                                    var7_7 = this.parseGroup(var2_2);
                                    if (var7_7 != 30) {
                                        throw new IOException("missing z component of vertex");
                                    }
                                    var30_31[var19_23][2] = this.m_dval;
                                    var20_24 = 3;
                                }
                                ++var19_23;
                            } else if (var7_7 == 11) {
                                var30_31[var19_23][0] = this.m_dval;
                                var7_7 = this.parseGroup(var2_2);
                                if (var7_7 != 21) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var30_31[var19_23][1] = this.m_dval;
                                var2_2.nextToken();
                                var2_2.pushBack();
                                if (var2_2.sval != null && var2_2.sval.equals("31")) {
                                    var7_7 = this.parseGroup(var2_2);
                                    if (var7_7 != 31) {
                                        throw new IOException("missing z component of vertex");
                                    }
                                    var30_31[var19_23][2] = this.m_dval;
                                    var20_24 = 3;
                                }
                                ++var19_23;
                            } else if (var7_7 == 12) {
                                var30_31[var19_23][0] = this.m_dval;
                                var7_7 = this.parseGroup(var2_2);
                                if (var7_7 != 22) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var30_31[var19_23][1] = this.m_dval;
                                var2_2.nextToken();
                                var2_2.pushBack();
                                if (var2_2.sval != null && var2_2.sval.equals("32")) {
                                    var7_7 = this.parseGroup(var2_2);
                                    if (var7_7 != 32) {
                                        throw new IOException("missing z component of vertex");
                                    }
                                    var30_31[var19_23][2] = this.m_dval;
                                    var20_24 = 3;
                                }
                                ++var19_23;
                            } else if (var7_7 == 13) {
                                var30_31[var19_23][0] = this.m_dval;
                                var7_7 = this.parseGroup(var2_2);
                                if (var7_7 != 23) {
                                    throw new IOException("missing y component of vertex");
                                }
                                var30_31[var19_23][1] = this.m_dval;
                                var2_2.nextToken();
                                var2_2.pushBack();
                                if (var2_2.sval != null && var2_2.sval.equals("33")) {
                                    var7_7 = this.parseGroup(var2_2);
                                    if (var7_7 != 33) {
                                        throw new IOException("missing z component of vertex");
                                    }
                                    var30_31[var19_23][2] = this.m_dval;
                                    var20_24 = 3;
                                }
                                ++var19_23;
                            } else if (var7_7 != 38 && var7_7 != 39) {
                                if (var7_7 == 40) {
                                    var21_25 = this.m_dval;
                                } else if (var7_7 == 50) {
                                    var23_26 = this.m_dval;
                                } else if (var7_7 == 51) {
                                    var25_27 = this.m_dval;
                                } else if (60 <= var7_7 && var7_7 <= 69) {
                                    var37_38[var7_7 % 10] = this.m_ival;
                                    var40_41 = null;
                                    switch (this.m_ival) {
                                        case 0: {
                                            var40_41 = Color.black;
                                            break;
                                        }
                                        case 1: {
                                            var40_41 = Color.red;
                                            break;
                                        }
                                        case 2: {
                                            var40_41 = Color.yellow;
                                            break;
                                        }
                                        case 3: {
                                            var40_41 = Color.green;
                                            break;
                                        }
                                        case 4: {
                                            var40_41 = Color.cyan;
                                            break;
                                        }
                                        case 5: {
                                            var40_41 = Color.blue;
                                            break;
                                        }
                                        case 6: {
                                            var40_41 = Color.magenta;
                                            break;
                                        }
                                        case 7: {
                                            var40_41 = Color.white;
                                            break;
                                        }
                                        case 8: {
                                            var40_41 = Color.black;
                                            break;
                                        }
                                        case 9: {
                                            var40_41 = Color.darkGray;
                                            break;
                                        }
                                        case 10: {
                                            var40_41 = Color.red;
                                            break;
                                        }
                                        default: {
                                            var40_41 = Color.lightGray;
                                        }
                                    }
                                    if (var31_32 != 116) {
                                        var4_4.setSize(0);
                                    }
                                    var6_6 = true;
                                    var5_5 = var40_41;
                                } else if (70 <= var7_7 && var7_7 <= 79) {
                                    var39_40[var7_7 % 10] = this.m_ival;
                                } else if (var7_7 == 210 || var7_7 == 220 || var7_7 == 230) {
                                    // empty if block
                                }
                            }
                        }
                        var7_7 = this.parseGroup(var2_2);
                    }
                }
                PsDebug.warning((String)("unexpected group=" + this.m_sval + " at line=" + var2_2.lineno() + ", skipped"));
                while (true) {
                    if (!(this.m_sval != null && this.m_sval.equals("ENDSEC") || var2_2.ttype == -1)) ** break;
                    continue block16;
                    var7_7 = this.parseGroup(var2_2);
                }
                break;
            }
        }
        catch (NumberFormatException var9_10) {
            PsDebug.warning((String)("NumberFormatException thrown in line=" + var2_2.lineno() + ", Exception = " + var9_10));
            return null;
        }
        catch (IOException var9_11) {
            PsDebug.warning((String)("IOException thrown in line=" + var2_2.lineno() + ", Exception = " + var9_11));
            return null;
        }
    }

    private String readLine(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        while (streamTokenizer.nextToken() == -3) {
            string = string + streamTokenizer.sval + " ";
        }
        while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
            streamTokenizer.nextToken();
        }
        return string.trim();
    }

    private int parseGroup(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        while ((this.m_code = this.parseCode(streamTokenizer)) == 999) {
            this.readLine(streamTokenizer);
        }
        this.m_sval = null;
        this.m_ival = 0;
        this.m_dval = 0.0;
        if (0 <= this.m_code && this.m_code <= 9) {
            this.m_sval = this.readLine(streamTokenizer);
        } else if (10 <= this.m_code && this.m_code <= 59) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (60 <= this.m_code && this.m_code <= 79) {
            this.m_ival = this.parseInt(streamTokenizer);
        } else if (102 == this.m_code || 1002 == this.m_code) {
            while (streamTokenizer.ttype != 125 && streamTokenizer.ttype != -1) {
                streamTokenizer.nextToken();
            }
            if (streamTokenizer.ttype == 125) {
                streamTokenizer.nextToken();
            }
        } else if (140 <= this.m_code && this.m_code <= 147) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (170 <= this.m_code && this.m_code <= 175) {
            this.m_ival = this.parseInt(streamTokenizer);
        } else if (210 <= this.m_code && this.m_code <= 239) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (999 == this.m_code) {
            this.m_sval = this.parseString(streamTokenizer);
        } else if (1010 <= this.m_code && this.m_code <= 1059) {
            this.m_dval = this.parseDouble(streamTokenizer);
        } else if (1060 <= this.m_code && this.m_code <= 1079) {
            this.m_ival = this.parseInt(streamTokenizer);
        } else {
            this.m_sval = 1000 <= this.m_code && this.m_code <= 1009 ? this.parseString(streamTokenizer) : this.parseString(streamTokenizer);
        }
        return this.m_code;
    }

    private int parseCode(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        return this.parseInt(streamTokenizer);
    }

    private int parseInt(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        if (streamTokenizer.nextToken() == -3) {
            try {
                int n = Integer.parseInt(streamTokenizer.sval);
                streamTokenizer.nextToken();
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("wrong format in integer string");
    }

    private double parseDouble(StreamTokenizer streamTokenizer) throws IOException, NumberFormatException {
        if (streamTokenizer.nextToken() == -3) {
            try {
                double d = PuDouble.parseDouble((String)streamTokenizer.sval);
                streamTokenizer.nextToken();
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("wrong format in double string");
    }

    private String parseString(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        while (streamTokenizer.nextToken() == -3) {
            string = string + streamTokenizer.sval + " ";
        }
        return string.trim();
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning((String)"missing geometry");
            return false;
        }
        writer.write("0\n");
        writer.write("SECTION\n");
        writer.write("2\n");
        writer.write("ENTITIES\n");
        for (int i = 0; i < pgJvxSrcArray.length; ++i) {
            if (pgJvxSrcArray[i].getType() == 33) {
                PgDxfLoader.writeElementSet(writer, pgJvxSrcArray[i]);
                continue;
            }
            if (pgJvxSrcArray[i].getType() == 30) {
                PgDxfLoader.writePointSet(writer, pgJvxSrcArray[i]);
                continue;
            }
            if (pgJvxSrcArray[i].getType() == 31) {
                PgDxfLoader.writePolygon(writer, pgJvxSrcArray[i]);
                continue;
            }
            if (pgJvxSrcArray[i].getType() != 32) continue;
            PgDxfLoader.writePolygonSet(writer, pgJvxSrcArray[i]);
        }
        writer.write("0\n");
        writer.write("ENDSEC\n");
        writer.write("0\n");
        writer.write("EOF\n");
        return true;
    }

    protected static boolean writeElementSet(Writer writer, PgJvxSrc pgJvxSrc) throws IOException {
        String string = pgJvxSrc.getName();
        int n = pgJvxSrc.getNumElements();
        int n2 = pgJvxSrc.getDimOfVertices();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgJvxSrc.getElement(i);
            int n3 = piVector.getSize();
            if (n3 > 4 || n3 < 3) {
                PsDebug.warning((String)("Element not triangular or quadrangular: " + i + " - element will be skipped."));
                continue;
            }
            writer.write("0\n");
            writer.write("3DFACE\n");
            writer.write("8\n");
            writer.write(string + "\n");
            for (int j = 0; j < 4; ++j) {
                PdVector pdVector = j < n3 ? pgJvxSrc.getVertex(piVector.m_data[j]) : pgJvxSrc.getVertex(piVector.m_data[2]);
                for (int k = 0; k < 3; ++k) {
                    writer.write(k + 1 + "" + j + "\n");
                    if (k < n2) {
                        writer.write(pdVector.m_data[k] + "\n");
                        continue;
                    }
                    writer.write("0.0\n");
                }
            }
        }
        return true;
    }

    protected static boolean writePolygonSet(Writer writer, PgJvxSrc pgJvxSrc) throws IOException {
        String string = pgJvxSrc.getName();
        int n = pgJvxSrc.getNumPolygons();
        int n2 = pgJvxSrc.getDimOfVertices();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgJvxSrc.getPolygon(i);
            int n3 = piVector.getSize();
            for (int j = 0; j < n3 - 1; ++j) {
                writer.write("0\n");
                writer.write("LINE\n");
                writer.write("8\n");
                writer.write(string + "\n");
                for (int k = 0; k < 2; ++k) {
                    PdVector pdVector = pgJvxSrc.getVertex(piVector.m_data[j + k]);
                    for (int i2 = 0; i2 < 3; ++i2) {
                        writer.write(i2 + 1 + "" + k + "\n");
                        if (i2 < n2) {
                            writer.write(pdVector.m_data[i2] + "\n");
                            continue;
                        }
                        writer.write("0.0\n");
                    }
                }
            }
        }
        return true;
    }

    protected static boolean writePolygon(Writer writer, PgJvxSrc pgJvxSrc) throws IOException {
        String string = pgJvxSrc.getName();
        int n = pgJvxSrc.getNumVertices();
        int n2 = pgJvxSrc.getDimOfVertices();
        for (int i = 0; i < n - 1; ++i) {
            writer.write("0\n");
            writer.write("LINE\n");
            writer.write("8\n");
            writer.write(string + "\n");
            for (int j = 0; j < 2; ++j) {
                PdVector pdVector = pgJvxSrc.getVertex(i + j);
                for (int k = 0; k < 3; ++k) {
                    writer.write(k + 1 + "" + j + "\n");
                    if (k < n2) {
                        writer.write(pdVector.m_data[k] + "\n");
                        continue;
                    }
                    writer.write("0.0\n");
                }
            }
        }
        return true;
    }

    protected static boolean writePointSet(Writer writer, PgJvxSrc pgJvxSrc) throws IOException {
        String string = pgJvxSrc.getName();
        int n = pgJvxSrc.getNumVertices();
        int n2 = pgJvxSrc.getDimOfVertices();
        for (int i = 0; i < n; ++i) {
            writer.write("0\n");
            writer.write("POINT\n");
            writer.write("8\n");
            writer.write(string + "\n");
            PdVector pdVector = pgJvxSrc.getVertex(i);
            for (int j = 0; j < 3; ++j) {
                writer.write(j + 1 + "0\n");
                if (j < n2) {
                    writer.write(pdVector.m_data[j] + "\n");
                    continue;
                }
                writer.write("0.0\n");
            }
        }
        return true;
    }
}

