/*
 * Decompiled with CFR 0.152.
 */
package jvx.gui;

import java.util.Date;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;

public class PuProgressBar
extends PsObject
implements Runnable {
    public static double PROGRESS_FINISHED = 1.0;
    public static double PROGRESS_NO_PROCESS = -1.0;
    public static double PROGRESS_ABORTED = -2.0;
    protected String m_text;
    protected double m_progress;
    protected boolean m_bShowProgressStatus;
    protected boolean m_bShowRemainingTime;
    protected long m_startTime;
    protected long m_pauseTime;
    protected boolean m_bRunning;
    protected int m_numLevels;
    protected PdVector m_levelStart;
    protected PdVector m_levelEnd;
    protected double m_localProgress;
    private double m_subIntervalStart;
    private double m_subIntervalEnd;
    static /* synthetic */ Class class$jvx$gui$PuProgressBar;

    public PuProgressBar() {
        this(false);
    }

    public PuProgressBar(boolean bl) {
        this.m_bShowRemainingTime = bl;
        this.m_text = "";
        if (this.getClass() == (class$jvx$gui$PuProgressBar == null ? (class$jvx$gui$PuProgressBar = PuProgressBar.class$("jvx.gui.PuProgressBar")) : class$jvx$gui$PuProgressBar)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bShowProgressStatus = true;
        this.m_bRunning = false;
        this.m_progress = -1.0;
        this.m_startTime = 0L;
        this.m_pauseTime = 0L;
        this.m_numLevels = 0;
        this.m_levelStart = new PdVector(0);
        this.m_levelEnd = new PdVector(0);
        this.m_localProgress = 0.0;
        this.m_subIntervalStart = 0.0;
        this.m_subIntervalEnd = 1.0;
    }

    public void start() {
        if (this.m_numLevels == 0) {
            this.startTimer();
        }
        ++this.m_numLevels;
        this.m_levelStart.addEntry(this.m_subIntervalStart);
        this.m_levelEnd.addEntry(this.m_subIntervalEnd);
        this.m_localProgress = 0.0;
        this.m_progress = this.m_subIntervalStart;
        this.m_subIntervalStart = 0.0;
        this.m_subIntervalEnd = 1.0;
    }

    public void stop() {
        this.m_progress = this.m_levelEnd.m_data[this.m_numLevels - 1];
        --this.m_numLevels;
        if (this.m_numLevels == 0) {
            this.reset();
            return;
        }
        this.m_levelStart.setSize(this.m_numLevels);
        this.m_levelEnd.setSize(this.m_numLevels);
        this.m_localProgress = (this.m_progress - this.m_levelStart.m_data[this.m_numLevels - 1]) / (this.m_levelEnd.m_data[this.m_numLevels - 1] - this.m_levelStart.m_data[this.m_numLevels - 1]);
        this.m_subIntervalStart = 0.0;
        this.m_subIntervalEnd = 1.0;
        if (this.m_numLevels == 0) {
            this.m_progress = PROGRESS_NO_PROCESS;
            this.stopTimer();
        }
    }

    public void setSubInterval(double d, double d2) {
        if (d > d2) {
            PsDebug.warning((String)"Start may not be >= end");
            return;
        }
        if (d < 0.0 || d2 > 1.0) {
            PsDebug.warning((String)"Value out of range");
            return;
        }
        double d3 = this.m_levelStart.m_data[this.m_numLevels - 1];
        double d4 = this.m_levelEnd.m_data[this.m_numLevels - 1];
        this.m_subIntervalStart = (1.0 - d) * d3 + d * d4;
        this.m_subIntervalEnd = (1.0 - d2) * d3 + d2 * d4;
    }

    public long getElapsedTime() {
        if (this.m_progress <= 0.0) {
            return 0L;
        }
        long l = 0L;
        l = this.m_pauseTime == 0L ? new Date().getTime() - this.m_startTime : this.m_pauseTime - this.m_startTime;
        return l;
    }

    public double getProgress() {
        return this.m_localProgress;
    }

    public void setProgress(double d) {
        if (this.m_numLevels == 0) {
            PsDebug.warning((String)"No process active, call start() first");
            return;
        }
        this.m_localProgress = d;
        this.m_progress = (1.0 - d) * this.m_levelStart.m_data[this.m_numLevels - 1] + d * this.m_levelEnd.m_data[this.m_numLevels - 1];
        this.updatePanels(this);
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String string) {
        this.m_text = string != null ? string.trim() : null;
    }

    public boolean isShowingRemainingTime() {
        return this.m_bShowRemainingTime;
    }

    public void enableProgressStatus(boolean bl) {
        this.m_bShowProgressStatus = bl;
    }

    public boolean isShowingProgressStatus() {
        return this.m_bShowProgressStatus;
    }

    public void reset() {
        if (this.m_bRunning) {
            this.stopTimer();
        }
        this.init();
        this.updatePanels(this);
    }

    private void startTimer() {
        this.m_bRunning = true;
        this.m_startTime = new Date().getTime();
        this.m_pauseTime = 0L;
        String string = this.m_text;
        if (PuString.isEmpty((String)string)) {
            string = "JavaView Progress Bar";
        }
        new Thread((Runnable)this, string).start();
    }

    public void suspendTimer() {
        this.m_bRunning = false;
        this.m_pauseTime = new Date().getTime();
    }

    public void resumeTimer() {
        if (this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        if (this.m_pauseTime != 0L) {
            this.m_startTime += new Date().getTime() - this.m_pauseTime;
        }
        this.m_pauseTime = 0L;
        String string = this.m_text;
        if (PuString.isEmpty((String)string)) {
            string = "JavaView Progress Bar";
        }
        new Thread((Runnable)this, string).start();
    }

    private void stopTimer() {
        this.m_bRunning = false;
    }

    public void abortTimer() {
        this.m_bRunning = false;
        this.m_startTime = 0L;
        this.m_pauseTime = 0L;
        this.m_progress = -2.0;
        this.updatePanels(this);
    }

    public void run() {
        while (this.m_bRunning) {
            this.updatePanels(this);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.updatePanels(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

