/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.util.Vector;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PuCleanMesh;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PwBoundary;
import jvx.geom.PwCleanMesh;
import jvx.geom.PwIntersectElementSet;
import jvx.numeric.PnRootFinder;

public class PwIntersectWithFunction
extends PwIntersectElementSet {
    protected PuFunction m_function = new PuFunction(3, 1);
    protected PuDouble m_level;
    protected String m_defaultFunction = "u*u+v*v+w*w";
    protected PdVector m_vertexData;
    public static final int FUNCTION = 0;
    public static final int DATA = 1;
    protected int m_mode = 0;
    protected PdVector m_normal;
    static /* synthetic */ Class class$jvx$geom$PwIntersectWithFunction;

    public PwIntersectWithFunction() {
        super(PsConfig.getMessage((int)48006));
        this.m_function.setVariables(new String[]{"u", "v", "w"});
        this.m_function.setExpression(this.m_defaultFunction);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_function.setName(PsConfig.getMessage((int)45005));
        this.m_level = new PuDouble(PsConfig.getMessage((int)54059), (PsUpdateIf)this);
        this.m_level.setDefBounds(0.0, 10.0, 0.1, 1.0);
        this.m_level.setDefValue(1.0);
        this.m_level.init();
        this.m_bFractionize = new boolean[1];
        this.m_bCutElements = new boolean[1];
        this.m_bFractionize[0] = false;
        this.m_bCutElements[0] = true;
        this.m_cancelUpdateList = new Vector();
        this.m_cancelRemoveList = new Vector();
        this.m_normal = new PdVector(0.0, 0.0, 1.0);
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwIntersectWithFunction == null ? (class$jvx$geom$PwIntersectWithFunction = PwIntersectWithFunction.class$("jvx.geom.PwIntersectWithFunction")) : class$jvx$geom$PwIntersectWithFunction)) {
            super.init();
        }
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        if (this.m_geomSave == null) {
            this.m_geomSave = (PgGeometry)this.m_geom.clone();
        }
        int n = this.m_geom.getDimOfVertices();
        this.m_function.setNumVariables(n);
        if (n == 4) {
            this.m_function.setVariables(new String[]{"u0", "u1", "u2", "u3"});
            this.m_function.setExpression("u0*u0+u1*u1+u2*u2+u3*u3");
        } else if (n == 3) {
            this.m_function.setVariables(new String[]{"u", "v", "w"});
            this.m_function.setExpression("u*u+v*v+w*w");
        } else if (n == 2) {
            this.m_function.setVariables(new String[]{"u", "v"});
            this.m_function.setExpression("u*u+v*v");
        } else if (n == 1) {
            this.m_function.setVariables(new String[]{"u"});
            this.m_function.setExpression("u");
        } else {
            PsDebug.warning((String)("void dimension of geometry, dim = " + String.valueOf(n)));
            return;
        }
        this.computeBounds();
    }

    public void setMode(int n) {
        this.m_mode = n;
        this.computeBounds();
    }

    public int getMode() {
        return this.m_mode;
    }

    public String getFunction() {
        if (this.m_function.getNumFunctions() == 0) {
            return null;
        }
        return this.m_function.getExpression();
    }

    public void setFunction(String string) {
        this.m_defaultFunction = new String(string);
        this.m_function.setExpression(this.m_defaultFunction);
        this.computeBounds();
    }

    public void setScalarData(PdVector pdVector) {
        this.m_vertexData = pdVector;
        this.computeBounds();
    }

    public double getLevel() {
        return this.m_level.getValue();
    }

    public void setLevel(double d) {
        this.m_level.setValue(d);
    }

    public boolean update(Object object) {
        if (object == this) {
            this.intersect();
            return super.update((Object)this);
        }
        if (object == this.m_level) {
            this.intersect();
            return super.update((Object)this);
        }
        if (object == this.m_function) {
            this.computeBounds();
            this.intersect();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    private void computeBounds() {
        double d = (this.m_level.getValue() - this.m_level.getMin()) / (this.m_level.getMax() - this.m_level.getMin());
        if (this.m_geom == null) {
            return;
        }
        int n = ((PgPointSet)this.m_geomSave).getNumVertices();
        if (n < 1) {
            return;
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.NEGATIVE_INFINITY;
        if (this.m_mode == 0) {
            PdVector[] pdVectorArray = ((PgPointSet)this.m_geomSave).getVertices();
            for (int i = 0; i < n; ++i) {
                double d4 = this.m_function.eval(0, pdVectorArray[i].m_data);
                if (d4 < d2) {
                    d2 = d4;
                }
                if (!(d4 > d3)) continue;
                d3 = d4;
            }
            if (d3 - d2 < 1.0E-10) {
                d3 += 1.0;
                d2 -= 1.0;
            }
        } else {
            d3 = 1.0;
            d2 = -1.0;
        }
        this.m_level.setBounds(d2, d3, (d3 - d2) / 100.0, (d3 - d2) / 10.0);
        this.m_level.setValue(d2 + d * (d3 - d2));
    }

    public void intersect() {
        if (this.m_mode == 0) {
            this.intersectWithFunction();
        } else {
            this.intersectWithPdVector();
        }
    }

    public void intersectWithFunction() {
        if (this.m_elSet == null) {
            this.m_elSet = new PgElementSet[1];
            this.m_elSet[0] = (PgElementSet)this.m_geom;
        }
        this.m_elSet[0].copy((PsObject)this.m_geomSave);
        this.reset();
        this.intersectWithFunction(this.m_level.getValue());
        this.m_geom.copy((PsObject)this.m_elSet[0]);
    }

    public void intersectWithPdVector() {
        if (this.m_elSet == null) {
            this.m_elSet = new PgElementSet[1];
            this.m_elSet[0] = (PgElementSet)this.m_geom;
        }
        this.m_elSet[0].copy((PsObject)this.m_geomSave);
        this.reset();
        this.intersectWithPdVector(this.m_level.getValue());
        this.m_geom.copy((PsObject)this.m_elSet[0]);
    }

    public void computeVertexDataFromNormal() {
        PdVector pdVector;
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (!pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        int n = pgElementSet.getNumVertices();
        if (this.m_vertexData == null || this.m_vertexData.getSize() != n) {
            this.m_vertexData = new PdVector(n);
        }
        if (!(pdVector = PdVector.copyNew((PdVector)this.m_normal)).normalize()) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.m_vertexData.m_data[i] = PdVector.dot((PdVector)pdVector, (PdVector)pgElementSet.getVertexNormal(i));
        }
    }

    public PgElementSet splitAtFunction() {
        this.intersectWithFunction();
        PgElementSet pgElementSet = this.splitFunctionIntersectedGeometry();
        pgElementSet.setName(this.m_geom.getName() + " +");
        this.m_geom.setName(this.m_geom.getName() + " -");
        return pgElementSet;
    }

    public PgElementSet splitAtPdVector() {
        this.intersectWithPdVector();
        PgElementSet pgElementSet = this.splitDataIntersectedGeometry();
        pgElementSet.setName(this.m_geom.getName() + " +");
        this.m_geom.setName(this.m_geom.getName() + " -");
        return pgElementSet;
    }

    public void clip(boolean bl) {
        if (this.m_mode == 0) {
            this.clipAtFunction(bl);
        } else {
            this.clipAtPdVector(bl);
        }
    }

    public void clipAtFunction(boolean bl) {
        this.intersectWithFunction();
        PgElementSet pgElementSet = this.splitFunctionIntersectedGeometry();
        if (bl) {
            if (pgElementSet != null) {
                this.m_geom.copy((PsObject)pgElementSet);
            } else {
                ((PgElementSet)this.m_geom).setNumElements(0);
                ((PgElementSet)this.m_geom).setNumVertices(0);
            }
        }
    }

    public void clipAtPdVector(boolean bl) {
        this.intersectWithPdVector();
        PgElementSet pgElementSet = this.splitDataIntersectedGeometry();
        if (bl) {
            if (pgElementSet != null) {
                this.m_geom.copy((PsObject)pgElementSet);
            } else {
                ((PgElementSet)this.m_geom).setNumElements(0);
                ((PgElementSet)this.m_geom).setNumVertices(0);
            }
        }
    }

    protected PgElementSet splitIntersectedGeometry() {
        if (this.m_mode == 0) {
            return this.splitFunctionIntersectedGeometry();
        }
        return this.splitDataIntersectedGeometry();
    }

    protected PgElementSet splitFunctionIntersectedGeometry() {
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (!this.m_bFractionize[0]) {
            PwCleanMesh.cutAlongPolygonSet(pgElementSet, this.m_polygonSet);
        }
        int n = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = pgElementSet.getVertices();
        boolean[] blArray = new boolean[n];
        double d = this.m_level.getValue();
        for (int i = 0; i < n; ++i) {
            blArray[i] = this.m_function.eval(0, pdVectorArray[i].m_data) - d < -1.0E-10;
        }
        return this.splitGeometry(pgElementSet, blArray);
    }

    protected PgElementSet splitDataIntersectedGeometry() {
        int n;
        PgElementSet pgElementSet = (PgElementSet)this.m_geom;
        if (!this.m_bFractionize[0]) {
            PwCleanMesh.cutAlongPolygonSet(pgElementSet, this.m_polygonSet);
        }
        int n2 = pgElementSet.getNumVertices();
        boolean[] blArray = new boolean[n2];
        double d = this.m_level.getValue();
        for (n = 0; n < this.m_vertexData.getSize(); ++n) {
            blArray[n] = this.m_vertexData.m_data[n] - d < -1.0E-10;
        }
        for (n = this.m_vertexData.getSize(); n < n2; ++n) {
            blArray[n] = false;
        }
        return this.splitGeometry(pgElementSet, blArray);
    }

    protected PgElementSet splitGeometry(PgElementSet pgElementSet, boolean[] blArray) {
        int n;
        int n2 = 0;
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n3 = pgElementSet.getNumElements();
        boolean[] blArray2 = new boolean[n3];
        block0: for (int i = 0; i < n3; ++i) {
            n = piVectorArray[i].getSize();
            blArray2[i] = false;
            for (int j = 0; j < n; ++j) {
                if (!blArray[piVectorArray[i].m_data[j]]) continue;
                blArray2[i] = true;
                ++n2;
                continue block0;
            }
        }
        PgElementSet pgElementSet2 = (PgElementSet)pgElementSet.clone();
        for (n = 0; n < n3; ++n) {
            if (blArray2[n]) {
                pgElementSet2.setTagElement(n, 2);
                continue;
            }
            this.m_geom.setTagElement(n, 2);
        }
        pgElementSet.removeMarkedElements();
        pgElementSet.removeUnusedVertices();
        PwBoundary.makeBoundary(pgElementSet);
        pgElementSet2.removeMarkedElements();
        pgElementSet2.removeUnusedVertices();
        PwBoundary.makeBoundary(pgElementSet2);
        return pgElementSet2;
    }

    public void intersect(double d) {
        if (this.m_mode == 0) {
            this.intersectWithFunction(d);
        } else {
            this.intersectWithPdVector(d);
        }
    }

    protected void intersectWithFunction(double d) {
        int n;
        PdVector pdVector = new PdVector(3);
        PdVector[] pdVectorArray = new PdVector[3];
        int n2 = this.m_subElements[0].size();
        this.m_currentIndex[0] = 0;
        while (this.m_currentIndex[0] < n2) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            PiVector piVector = (PiVector)this.m_subElements[0].elementAt(this.m_currentIndex[0]);
            for (n = 0; n < 3; ++n) {
                pdVectorArray[n] = (PdVector)this.m_vertices[0].elementAt(piVector.m_data[n]);
                pdVector.m_data[n] = this.m_function.eval(0, pdVectorArray[n].m_data) - d;
                if (pdVector.m_data[n] > 1.0E-10) {
                    ++n3;
                    continue;
                }
                if (pdVector.m_data[n] < -1.0E-10) {
                    ++n4;
                    continue;
                }
                ++n5;
                pdVector.m_data[n] = 0.0;
            }
            if (n5 != 3 && n4 != 3 && n3 != 3 && (n5 != 1 || n4 != 2 && n3 != 2)) {
                int n6;
                int n7;
                PdVector pdVector2;
                double[] dArray;
                int n8;
                if (n5 == 2) {
                    n8 = pdVector.m_data[0] != 0.0 ? 0 : (pdVector.m_data[1] != 0.0 ? 1 : 2);
                    if (this.m_bCutElements[0]) {
                        this.divideElement(0, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[(n8 + 1) % 3], piVector.m_data[(n8 + 2) % 3]));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVectorArray[(n8 + 1) % 3]), this.addPolygonSetVertex(pdVectorArray[(n8 + 2) % 3])));
                    }
                } else if (n5 == 1) {
                    n8 = pdVector.m_data[0] == 0.0 ? 0 : (pdVector.m_data[1] == 0.0 ? 1 : 2);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[(n8 + 2) % 3].m_data, pdVectorArray[(n8 + 1) % 3].m_data, d);
                    PdVector pdVector3 = new PdVector(dArray);
                    if (this.m_bCutElements[0]) {
                        int n9 = this.addVertex(0, piVector.m_data[(n8 + 1) % 3], piVector.m_data[(n8 + 2) % 3], pdVector3);
                        this.divideIntoTwo(0, n9, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[n8], n9));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVectorArray[n8]), this.addPolygonSetVertex(pdVector3)));
                    }
                } else if (n3 == 1) {
                    n8 = pdVector.m_data[0] > 0.0 ? 0 : (pdVector.m_data[1] > 0.0 ? 1 : 2);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 1) % 3].m_data, d);
                    PdVector pdVector4 = new PdVector(dArray);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 2) % 3].m_data, d);
                    pdVector2 = new PdVector(dArray);
                    if (this.m_bCutElements[0]) {
                        n7 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 1) % 3], pdVector4);
                        n6 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 2) % 3], pdVector2);
                        this.divideIntoThree(0, n7, n6, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n7, n6));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector4), this.addPolygonSetVertex(pdVector2)));
                    }
                } else {
                    n8 = pdVector.m_data[0] < 0.0 ? 0 : (pdVector.m_data[1] < 0.0 ? 1 : 2);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 1) % 3].m_data, d);
                    PdVector pdVector5 = new PdVector(dArray);
                    dArray = PnRootFinder.findValue(this.m_function, pdVectorArray[n8].m_data, pdVectorArray[(n8 + 2) % 3].m_data, d);
                    pdVector2 = new PdVector(dArray);
                    if (this.m_bCutElements[0]) {
                        n7 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 1) % 3], pdVector5);
                        n6 = this.addVertex(0, piVector.m_data[n8], piVector.m_data[(n8 + 2) % 3], pdVector2);
                        this.divideIntoThree(0, n7, n6, n8);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n7, n6));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector5), this.addPolygonSetVertex(pdVector2)));
                    }
                }
            }
            this.m_currentIndex[0] = this.m_currentIndex[0] + 1;
        }
        if (this.m_bCutElements[0]) {
            this.conformize(0);
            n = this.m_polygonSetXEdges[0].size();
            this.m_polygonSet.setNumPolygons(n);
            for (int i = 0; i < n; ++i) {
                this.m_polygonSet.setPolygon(i, (PiVector)this.m_polygonSetXEdges[0].elementAt(i));
            }
            this.m_polygonSet.setNumVertices(this.m_elSet[0].getNumVertices());
            this.m_polygonSet.setVertices((PdVector[])this.m_elSet[0].getVertices().clone());
        } else {
            int n10;
            n = this.m_polygonSetEdges.size();
            int n11 = this.m_polygonSetVertices.size();
            this.m_polygonSet.setNumVertices(n11);
            for (n10 = 0; n10 < n11; ++n10) {
                this.m_polygonSet.setVertex(n10, (PdVector)this.m_polygonSetVertices.elementAt(n10));
            }
            for (n10 = 0; n10 < n; ++n10) {
                this.m_polygonSet.setPolygon(n10, (PiVector)this.m_polygonSetEdges.elementAt(n10));
            }
            PuCleanMesh.identifyVertices((PgPointSet)this.m_polygonSet, (double)1.0E-10);
        }
        this.m_polygonSet.setGlobalPolygonColor(new Color(255, 0, 0));
        this.m_polygonSet.showVertices(false);
    }

    protected void intersectWithPdVector(double d) {
        int n;
        int n2;
        this.computeVertexDataFromNormal();
        Vector<PdVector> vector = new Vector<PdVector>();
        int n3 = this.m_elSet[0].getNumVertices();
        for (int i = 0; i < n3; ++i) {
            vector.addElement(new PdVector(this.m_vertexData.m_data[i]));
        }
        PdVector pdVector = new PdVector(3);
        int n4 = this.m_subElements[0].size();
        this.m_currentIndex[0] = 0;
        while (this.m_currentIndex[0] < n4) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            PiVector piVector = (PiVector)this.m_subElements[0].elementAt(this.m_currentIndex[0]);
            for (n2 = 0; n2 < 3; ++n2) {
                pdVector.m_data[n2] = ((PdVector)vector.elementAt((int)piVector.m_data[n2])).m_data[0] - d;
                if (pdVector.m_data[n2] > 1.0E-10) {
                    ++n5;
                    continue;
                }
                if (pdVector.m_data[n2] < -1.0E-10) {
                    ++n6;
                    continue;
                }
                ++n7;
                pdVector.m_data[n2] = 0.0;
            }
            if (n7 != 3 && n6 != 3 && n5 != 3 && (n7 != 1 || n6 != 2 && n5 != 2)) {
                int n8;
                int n9;
                PdVector pdVector2;
                double d2;
                int n10;
                if (n7 == 2) {
                    n10 = pdVector.m_data[0] != 0.0 ? 0 : (pdVector.m_data[1] != 0.0 ? 1 : 2);
                    if (this.m_bCutElements[0]) {
                        this.divideElement(0, n10);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[(n10 + 1) % 3], piVector.m_data[(n10 + 2) % 3]));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 1) % 3])), this.addPolygonSetVertex((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 2) % 3]))));
                    }
                } else if (n7 == 1) {
                    n10 = pdVector.m_data[0] == 0.0 ? 0 : (pdVector.m_data[1] == 0.0 ? 1 : 2);
                    d2 = pdVector.m_data[(n10 + 1) % 3] - pdVector.m_data[(n10 + 2) % 3];
                    PdVector pdVector3 = PdVector.blendNew((double)(pdVector.m_data[(n10 + 1) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 2) % 3])), (double)(-pdVector.m_data[(n10 + 2) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 1) % 3])));
                    if (this.m_bCutElements[0]) {
                        int n11 = this.addVertex(0, piVector.m_data[(n10 + 1) % 3], piVector.m_data[(n10 + 2) % 3], pdVector3);
                        if (n11 >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        this.divideIntoTwo(0, n11, n10);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(piVector.m_data[n10], n11));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n10])), this.addPolygonSetVertex(pdVector3)));
                    }
                } else if (n5 == 1) {
                    n10 = pdVector.m_data[0] > 0.0 ? 0 : (pdVector.m_data[1] > 0.0 ? 1 : 2);
                    d2 = pdVector.m_data[n10] - pdVector.m_data[(n10 + 1) % 3];
                    PdVector pdVector4 = PdVector.blendNew((double)(pdVector.m_data[n10] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 1) % 3])), (double)(-pdVector.m_data[(n10 + 1) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n10])));
                    d2 = pdVector.m_data[n10] - pdVector.m_data[(n10 + 2) % 3];
                    pdVector2 = PdVector.blendNew((double)(pdVector.m_data[n10] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 2) % 3])), (double)(-pdVector.m_data[(n10 + 2) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n10])));
                    if (this.m_bCutElements[0]) {
                        n9 = this.addVertex(0, piVector.m_data[n10], piVector.m_data[(n10 + 1) % 3], pdVector4);
                        if (n9 >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        if ((n8 = this.addVertex(0, piVector.m_data[n10], piVector.m_data[(n10 + 2) % 3], pdVector2)) >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        this.divideIntoThree(0, n9, n8, n10);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n9, n8));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector4), this.addPolygonSetVertex(pdVector2)));
                    }
                } else {
                    n10 = pdVector.m_data[0] < 0.0 ? 0 : (pdVector.m_data[1] < 0.0 ? 1 : 2);
                    d2 = pdVector.m_data[n10] - pdVector.m_data[(n10 + 1) % 3];
                    PdVector pdVector5 = PdVector.blendNew((double)(pdVector.m_data[n10] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 1) % 3])), (double)(-pdVector.m_data[(n10 + 1) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n10])));
                    d2 = pdVector.m_data[n10] - pdVector.m_data[(n10 + 2) % 3];
                    pdVector2 = PdVector.blendNew((double)(pdVector.m_data[n10] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[(n10 + 2) % 3])), (double)(-pdVector.m_data[(n10 + 2) % 3] / d2), (PdVector)((PdVector)this.m_vertices[0].elementAt(piVector.m_data[n10])));
                    if (this.m_bCutElements[0]) {
                        n9 = this.addVertex(0, piVector.m_data[n10], piVector.m_data[(n10 + 1) % 3], pdVector5);
                        if (n9 >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        if ((n8 = this.addVertex(0, piVector.m_data[n10], piVector.m_data[(n10 + 2) % 3], pdVector2)) >= vector.size()) {
                            vector.addElement(new PdVector(d));
                        }
                        this.divideIntoThree(0, n9, n8, n10);
                        this.m_polygonSetXEdges[0].addElement(new PiVector(n9, n8));
                    } else {
                        this.m_polygonSetEdges.addElement(new PiVector(this.addPolygonSetVertex(pdVector5), this.addPolygonSetVertex(pdVector2)));
                    }
                }
            }
            this.m_currentIndex[0] = this.m_currentIndex[0] + 1;
        }
        if (this.m_bCutElements[0]) {
            this.conformize(0);
            n2 = this.m_polygonSetXEdges[0].size();
            this.m_polygonSet.setNumPolygons(n2);
            for (n = 0; n < n2; ++n) {
                this.m_polygonSet.setPolygon(n, (PiVector)this.m_polygonSetXEdges[0].elementAt(n));
            }
            this.m_polygonSet.setNumVertices(this.m_elSet[0].getNumVertices());
            this.m_polygonSet.setVertices((PdVector[])this.m_elSet[0].getVertices().clone());
        } else {
            int n12;
            n2 = this.m_polygonSetEdges.size();
            n = this.m_polygonSetVertices.size();
            this.m_polygonSet.setNumVertices(n);
            for (n12 = 0; n12 < n; ++n12) {
                this.m_polygonSet.setVertex(n12, (PdVector)this.m_polygonSetVertices.elementAt(n12));
            }
            for (n12 = 0; n12 < n2; ++n12) {
                this.m_polygonSet.setPolygon(n12, (PiVector)this.m_polygonSetEdges.elementAt(n12));
            }
            PuCleanMesh.identifyVertices((PgPointSet)this.m_polygonSet, (double)1.0E-10);
        }
        this.m_polygonSet.setGlobalPolygonColor(new Color(255, 0, 0));
        this.m_polygonSet.showVertices(false);
        n2 = this.m_elSet[0].getNumVertices();
        this.m_vertexData.setSize(n2);
        for (n = n3; n < n2; ++n) {
            this.m_vertexData.m_data[n] = d;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

