/*
 * Decompiled with CFR 0.152.
 */
package us.bpsm.edn.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import us.bpsm.edn.EdnException;

public class IOUtil {
    static final String ENCODING = "UTF-8";
    private static final int BUFFER_SIZE = 8192;
    private static final int INITIAL_BUILDER_SIZE = 8192;

    public static String stringFromResource(String resourceName) {
        URL url = IOUtil.class.getClassLoader().getResource(resourceName);
        if (url == null) {
            throw new EdnException("resource '" + resourceName + "' not found.");
        }
        return IOUtil.stringFromURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromURL(URL url) {
        String string;
        InputStream urlStream = url.openStream();
        try {
            string = IOUtil.stringFromInputStream(urlStream);
        }
        catch (Throwable throwable) {
            try {
                urlStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new EdnException(e);
            }
        }
        urlStream.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromInputStream(InputStream urlStream) {
        String string;
        InputStreamReader reader = new InputStreamReader(urlStream, ENCODING);
        try {
            int n;
            char[] buffer = new char[8192];
            StringBuilder b = new StringBuilder(8192);
            while ((n = reader.read(buffer)) >= 0) {
                b.append(buffer, 0, n);
            }
            string = b.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new EdnException(e);
            }
        }
        ((Reader)reader).close();
        return string;
    }
}

