/*
 * Decompiled with CFR 0.152.
 */
package hephysics.vec;

import hephysics.vec.Hep3Vector;
import hephysics.vec.VecOp;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class HepLorentzVector
implements Serializable {
    static final long serialVersionUID = 1L;
    protected double t;
    protected double energy;
    protected Hep3Vector v;

    public HepLorentzVector() {
        this.t = 0.0;
        this.energy = 0.0;
        this.v = new Hep3Vector();
    }

    public HepLorentzVector(double x, double y, double z, double t) {
        this.t = t;
        this.energy = t;
        this.v = new Hep3Vector(x, y, z);
    }

    public HepLorentzVector(double[] x, double t) {
        this.t = t;
        this.energy = t;
        this.v = new Hep3Vector(x);
    }

    public HepLorentzVector(float[] x, double t) {
        this.t = t;
        this.energy = t;
        this.v = new Hep3Vector(x);
    }

    public HepLorentzVector(Hep3Vector v, double t) {
        this.t = t;
        this.v = v;
        this.energy = t;
    }

    public void setV3(Hep3Vector v) {
        this.v = v;
    }

    public void setV3(double x, double y, double z) {
        this.v.setV(x, y, z);
    }

    public double px() {
        return this.v.x();
    }

    public double py() {
        return this.v.y();
    }

    public double pz() {
        return this.v.z();
    }

    public double x() {
        return this.v.x();
    }

    public double y() {
        return this.v.y();
    }

    public double z() {
        return this.v.z();
    }

    public double e() {
        return this.energy;
    }

    public double getE() {
        return this.energy;
    }

    public void setPx(double px) {
        this.v.setX(px);
    }

    public void setPy(double py) {
        this.v.setY(py);
    }

    public void setPz(double pz) {
        this.v.setZ(pz);
    }

    public void setX(double x) {
        this.v.setX(x);
    }

    public void setY(double y) {
        this.v.setY(y);
    }

    public void setZ(double z) {
        this.v.setZ(z);
    }

    public void add(HepLorentzVector parent) {
        this.v.setX(this.v.x() + parent.v3().x());
        this.v.setY(this.v.y() + parent.v3().y());
        this.v.setZ(this.v.z() + parent.v3().z());
        this.t += parent.getT();
        this.energy += parent.getE();
    }

    public double mt2() {
        return this.t() * this.t() - this.pz() * this.pz();
    }

    public double mag2() {
        return this.t() * this.t() - this.v.mag2();
    }

    public void boost(double bx, double by, double bz) {
        double b2 = bx * bx + by * by + bz * bz;
        double gamma = 1.0 / Math.sqrt(1.0 - b2);
        double bp = bx * this.v.x() + by * this.v.y() + bz * this.v.z();
        double gamma2 = b2 > 0.0 ? (gamma - 1.0) / b2 : 0.0;
        this.v.setX(this.v.x() + gamma2 * bp * bx + gamma * bx * this.t());
        this.v.setY(this.v.y() + gamma2 * bp * by + gamma * by * this.t());
        this.v.setZ(this.v.z() + gamma2 * bp * bz + gamma * bz * this.t());
        this.setT(gamma * (this.t() + bp));
    }

    public void setE(double e) {
        this.energy = e;
    }

    public void setT(double t) {
        this.t = t;
    }

    public double t() {
        return this.t;
    }

    public double getT() {
        return this.t;
    }

    public Hep3Vector v3() {
        return this.v;
    }

    public double et2() {
        double pt2 = this.perp2();
        return pt2 == 0.0 ? 0.0 : this.e() * this.e() * pt2 / (pt2 + this.v.z() * this.v.z());
    }

    public double et() {
        double etet = this.et2();
        return this.e() < 0.0 ? -Math.sqrt(etet) : Math.sqrt(etet);
    }

    public double restMass2() {
        return this.m2();
    }

    public double mt() {
        double mm = this.mt2();
        return mm < 0.0 ? -Math.sqrt(-mm) : Math.sqrt(mm);
    }

    public double invariantMass2() {
        return this.m2();
    }

    public double m2() {
        return this.energy * this.energy - this.mag2();
    }

    public double invariantMass() {
        return this.m();
    }

    public double m() {
        if (this.m2() >= 0.0) {
            return Math.sqrt(this.m2());
        }
        return -Math.sqrt(-this.m2());
    }

    public boolean isSpacelike() {
        return this.restMass2() < 0.0;
    }

    public boolean isLightlike(double epsilon) {
        return Math.abs(this.restMass2()) < 2.0 * epsilon * this.energy * this.energy;
    }

    public double dot(HepLorentzVector v, HepLorentzVector w) {
        return v.t() * w.t() - this.dot(v.v3(), w.v3());
    }

    private double dot(Hep3Vector v, Hep3Vector w) {
        return v.x() * w.x() + v.y() * w.y() + v.z() * w.z();
    }

    public HepLorentzVector add(HepLorentzVector v, HepLorentzVector w) {
        return new HepLorentzVector(this.add(v.v3(), w.v3()), v.t() + w.t());
    }

    public HepLorentzVector sub(HepLorentzVector v, HepLorentzVector w) {
        return new HepLorentzVector(this.sub(v.v3(), w.v3()), v.t() - w.t());
    }

    public HepLorentzVector mult(double scalar, HepLorentzVector v) {
        return new HepLorentzVector(this.mult(scalar, v.v3()), scalar * v.t());
    }

    public HepLorentzVector neg(HepLorentzVector v) {
        return new HepLorentzVector(this.neg(v.v3()), -v.t());
    }

    public Hep3Vector neg(Hep3Vector v) {
        return new Hep3Vector(-v.x(), -v.y(), -v.z());
    }

    private Hep3Vector add(Hep3Vector v, Hep3Vector w) {
        return new Hep3Vector(v.x() + w.x(), v.y() + w.y(), v.z() + w.z());
    }

    private Hep3Vector sub(Hep3Vector v, Hep3Vector w) {
        return new Hep3Vector(v.x() - w.x(), v.y() - w.y(), v.z() - w.z());
    }

    private Hep3Vector mult(double scalar, Hep3Vector v) {
        return new Hep3Vector(scalar * v.x(), scalar * v.y(), scalar * v.z());
    }

    public Hep3Vector centerOfMass(List<HepLorentzVector> vecSet) {
        boolean empty = true;
        boolean fourVecSet = false;
        Hep3Vector cmVec = new Hep3Vector();
        Iterator<HepLorentzVector> i = vecSet.iterator();
        while (i.hasNext()) {
            if (empty) {
                empty = false;
                HepLorentzVector e = i.next();
                if (e instanceof HepLorentzVector) {
                    fourVecSet = true;
                    HepLorentzVector v = e;
                    cmVec = v.v3();
                    continue;
                }
                throw new RuntimeException("Element is not a 3- or 4-vector");
            }
            if (!fourVecSet) continue;
            try {
                HepLorentzVector v = i.next();
                cmVec = this.add(cmVec, v.v3());
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Element of 4Vec enumeration is not a 4Vec.");
            }
        }
        if (!empty) {
            return cmVec;
        }
        throw new RuntimeException("CM:vector set is empty.");
    }

    public HepLorentzVector boost(HepLorentzVector fourVector, Hep3Vector boostVector) {
        double beta = boostVector.mag();
        if (beta >= 1.0) {
            throw new RuntimeException("Boost beta >= 1.0 !");
        }
        double gamma = 1.0 / Math.sqrt(1.0 - beta * beta);
        double t = fourVector.t();
        Hep3Vector v = fourVector.v3();
        double tp = gamma * (t - this.dot(boostVector, v));
        Hep3Vector vp = this.add(v, this.add(this.mult((gamma - 1.0) / (beta * beta) * this.dot(boostVector, v), boostVector), this.mult(-gamma * t, boostVector)));
        return new HepLorentzVector(vp, tp);
    }

    public HepLorentzVector boost(HepLorentzVector fourVector, HepLorentzVector refFourVector) {
        Hep3Vector refVector = refFourVector.v3();
        Hep3Vector boostVector = new Hep3Vector(refVector.x(), refVector.y(), refVector.z());
        boostVector = this.mult(1.0 / refFourVector.t(), boostVector);
        return this.boost(fourVector, boostVector);
    }

    public double cosTheta() {
        return this.v.cosTheta();
    }

    public double phi() {
        return this.v.phi();
    }

    public double perp() {
        return this.v.perp();
    }

    public double perp2() {
        return this.v.perp2();
    }

    public double angle(HepLorentzVector momentum) {
        return this.v.angle(momentum.v3());
    }

    public double theta() {
        return this.v.theta();
    }

    public double pseudoRapidity() {
        return this.v.pseudoRapidity();
    }

    public double rapidity() {
        double m = this.mag();
        if (m > this.pz()) {
            return 0.5 * Math.log((m + this.pz()) / (m - this.pz()));
        }
        return -1.0E11;
    }

    public double getEta() {
        return this.pseudoRapidity();
    }

    public Hep3Vector getV3() {
        return this.v;
    }

    public double mag() {
        return Math.sqrt(VecOp.dot(this.v, this.v));
    }

    public double skp(HepLorentzVector momentum) {
        return this.v.x() * momentum.v3().x() + this.v.y() * momentum.v3().y() + this.v.z() * momentum.v3().z();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HepLorentzVector) {
            HepLorentzVector that = (HepLorentzVector)obj;
            return this.v.equals(that.v3()) && that.t() == this.t;
        }
        return false;
    }

    public HepLorentzVector copy() {
        HepLorentzVector tmp = new HepLorentzVector(this.px(), this.py(), this.pz(), this.t());
        tmp.setE(this.e());
        return tmp;
    }

    public int hashCode() {
        return this.v.hashCode() + (int)Double.doubleToRawLongBits(this.t);
    }

    public String toString() {
        return VecOp.toString(this);
    }
}

