/*
 * Decompiled with CFR 0.152.
 */
package hephysics.particle;

import hephysics.particle.LParticle;
import hephysics.vec.HepLorentzVector;
import java.io.Serializable;
import java.util.Formatter;
import jhplot.gui.HelpBrowser;

public class HEParticle
extends LParticle
implements Serializable {
    static final long serialVersionUID = 1L;
    protected int status;
    protected int m_pType;
    protected float isospin;
    protected float spin;
    protected float spaceparity;
    protected float chargeparity;
    protected int pdgcode;
    protected HEParticle parent;
    protected HepLorentzVector position;

    public HEParticle(String name, double mass) {
        super(name, mass);
        this.status = 0;
        this.m_pType = 0;
        this.chargeparity = 0.0f;
        this.isospin = 0.0f;
        this.spaceparity = 0.0f;
        this.pdgcode = 0;
        this.spin = 0.0f;
    }

    public HEParticle(double px, double py, double pz) {
        super(px, py, pz);
        this.status = 0;
        this.m_pType = 0;
        this.chargeparity = 0.0f;
        this.isospin = 0.0f;
        this.spaceparity = 0.0f;
        this.pdgcode = 0;
    }

    public HEParticle(double px, double py, double pz, double energy, double mass) {
        super(px, py, pz, energy, mass);
        this.status = 0;
        this.m_pType = 0;
        this.chargeparity = 0.0f;
        this.isospin = 0.0f;
        this.spaceparity = 0.0f;
        this.pdgcode = 0;
        this.spin = 0.0f;
    }

    public HEParticle(HepLorentzVector momentum, HepLorentzVector position, double mass) {
        super(momentum.px(), momentum.py(), momentum.pz(), momentum.e(), mass);
        this.position = position;
        this.status = 0;
        this.m_pType = 0;
        this.chargeparity = 0.0f;
        this.isospin = 0.0f;
        this.spaceparity = 0.0f;
        this.pdgcode = 0;
        this.spin = 0.0f;
    }

    public void setPosition(HepLorentzVector position) {
        this.position = position;
    }

    public HepLorentzVector getPosition() {
        return this.position;
    }

    public HEParticle(double px, double py, double pz, double energy) {
        super(px, py, pz, energy);
        this.status = 0;
        this.m_pType = 0;
        this.chargeparity = 0.0f;
        this.isospin = 0.0f;
        this.spaceparity = 0.0f;
        this.pdgcode = 0;
        this.spin = 0.0f;
    }

    @Override
    public double rapidity() {
        double rapidity = -1.0E11;
        if (this.e() > this.pz()) {
            rapidity = 0.5 * Math.log((this.e() + this.pz()) / (this.e() - this.pz()));
        }
        return rapidity;
    }

    public HEParticle(String name, double px, double py, double pz, double energy, double mass) {
        super(px, py, pz, energy, mass);
        this.status = 0;
        this.m_pType = 0;
        this.chargeparity = 0.0f;
        this.isospin = 0.0f;
        this.spaceparity = 0.0f;
        this.pdgcode = 0;
        this.spin = 0.0f;
    }

    public void add(HEParticle another) {
        this.add(another);
        this.chargeparity += another.getChargeParity();
        this.spaceparity += another.getSpaceparity();
        this.isospin += another.getIsospin();
        this.spin += another.getSpin();
    }

    public void setIsospin(float isospin) {
        this.isospin = isospin;
    }

    public float getIsospin() {
        return this.isospin;
    }

    public void setChargeParity(float chargeparity) {
        this.chargeparity = chargeparity;
    }

    public float getChargeParity() {
        return this.chargeparity;
    }

    public void setSpin(float spin) {
        this.spin = spin;
    }

    public float getSpin() {
        return this.spin;
    }

    public void setPdgcode(int pdgcode) {
        this.pdgcode = pdgcode;
    }

    public int getPdgcode() {
        return this.pdgcode;
    }

    public void setSpaceParity(float spaceparity) {
        this.spaceparity = spaceparity;
    }

    public float getSpaceparity() {
        return this.spaceparity;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getBarcode() {
        return this.m_pType;
    }

    public void setBarcode(int barcode) {
        this.m_pType = barcode;
    }

    @Override
    public String toString() {
        Formatter formatter = new Formatter();
        formatter.format("M=%9.4g,E=%9.4g,T=%9.4g,S=%9.4g,Type=%9.4,Isospin=%6.3,ChargeParity=%6.3,SpaceParity=%6.3,Spin=%6.3", this.mass, this.energy, this.t, this.status, this.m_pType, Float.valueOf(this.isospin), Float.valueOf(this.chargeparity), Float.valueOf(this.spaceparity), Float.valueOf(this.spin));
        String sname = String.format("%10s", this.name);
        return new String(sname + " " + this.v.toString() + ", " + formatter.out().toString());
    }

    @Override
    public HEParticle copy() {
        HEParticle tmp = new HEParticle(this.getName(), this.pz(), this.pz(), this.pz(), this.e(), this.getMass());
        tmp.setParent(this.getParent());
        this.setT(this.t());
        this.setCharge(this.getCharge());
        this.setBarcode(this.getBarcode());
        this.setStatus(this.getStatus());
        this.setIsospin(this.getIsospin());
        this.setSpaceParity(this.getSpaceparity());
        this.setChargeParity(this.getChargeParity());
        this.setSpin(this.getSpin());
        this.setPdgcode(this.getPdgcode());
        return tmp;
    }

    public LParticle getLParticle() {
        return this;
    }

    public void twoBodyDecay(HEParticle prod1, HEParticle prod2, boolean randomRotate) {
        this.twoBodyDecay(prod1.getLParticle(), prod2.getLParticle(), randomRotate);
    }

    public void boost(HEParticle parent) {
        this.boost(parent.getLParticle());
    }

    @Override
    public void print() {
        System.out.println(this.toString());
    }

    @Override
    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

