/*
 * Decompiled with CFR 0.152.
 */
package hephysics.jet;

import hephysics.jet.ParticleD;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class SCJet {
    private int recom = 1;
    private double R;
    private double R2;
    private int[] is_consider;
    private double[] ktdistance1;
    private double[][] ktdistance12;
    private ArrayList<ParticleD> jets;
    private final double PI2 = Math.PI * 2;
    private boolean debug = false;
    private double minpt = 0.0;
    private int mode = 1;
    private DecimalFormat formatter = new DecimalFormat("%.12f");
    boolean m_fast;

    public SCJet(double R, int recom, int mode, double minpt, boolean isfast) {
        this.R = R;
        this.R2 = R * R;
        this.recom = recom;
        this.debug = false;
        this.minpt = minpt;
        this.mode = mode;
        this.m_fast = isfast;
        DecimalFormat formatter1 = new DecimalFormat("#0.00");
        String rs = formatter1.format(this.R);
        System.out.println("SCjet: Initialization of Java jet algorithm. S.Chekanov (ANL)");
        System.out.println("SCjet: Inclusive mode using the E-scheme recombination and R=" + rs);
        if (mode == 1) {
            System.out.println("SCjet: Longitudinally invariant kt algorithm");
        } else if (mode == 0) {
            System.out.println("SCjet: Cambridge/Aachen algorithm");
        } else if (mode == -1) {
            System.out.println("SCjet: Longitudinally invariant anti-kt algorithm");
        } else {
            System.out.println("SCjet: Not correct mode:  Fallback to the inclusive kT algorithm using E-scheme and R=" + rs);
        }
        if (recom != 1) {
            System.out.println("SCjet: Only E-scheme recombination supported! Exit.");
            System.exit(0);
        }
        if (this.m_fast && mode == -1) {
            System.out.println("SCjet: Seeded anti-kT jets are enabled.");
        }
        if (!this.m_fast && mode == -1) {
            System.out.println("SCjet: The standard anti-KT jet algorithm.");
        }
        if (this.m_fast && mode >= 0) {
            System.out.println("SCjet: Currently, the  seeded mode is enabled for anti-kT jets. Exit.");
            System.exit(0);
        }
    }

    public SCJet(double R, int recom, int mode, double minpt) {
        this(R, recom, mode, minpt, false);
    }

    public SCJet(double R, double minpt) {
        this(R, 1, 1, minpt, false);
    }

    public List<ParticleD> buildJets(List<ParticleD> list) {
        ParticleD p2;
        double min12;
        int j;
        int i;
        this.jets = new ArrayList();
        int size = list.size();
        long startTime = 0L;
        if (this.debug) {
            startTime = System.currentTimeMillis();
        }
        this.ktdistance1 = new double[size];
        this.is_consider = new int[size];
        for (int m = 0; m < size; ++m) {
            this.is_consider[m] = 1;
            ParticleD p1 = list.get(m);
            this.ktdistance1[m] = this.getKtDistance1(p1);
        }
        this.ktdistance12 = new double[size][size];
        for (i = 0; i < size - 1; ++i) {
            ParticleD p1 = list.get(i);
            for (j = i + 1; j < size; ++j) {
                ParticleD p22 = list.get(j);
                this.ktdistance12[i][j] = this.getKtDistance12(p1, p22);
            }
        }
        if (this.debug) {
            long stopTime = System.currentTimeMillis();
            long runTime = stopTime - startTime;
            System.out.println("--->  Run time after making a cache of distances (ms): " + runTime);
        }
        int Nstep = size;
        int iter = 0;
        boolean merged = false;
        int km = -1;
        int j1 = -1;
        int j2 = -1;
        while (Nstep > 0) {
            ParticleD p1;
            min12 = Double.MAX_VALUE;
            double min1 = Double.MAX_VALUE;
            if (this.m_fast) {
                if (!merged) {
                    for (i = 0; i < size - 1; ++i) {
                        if (this.is_consider[i] <= 0) continue;
                        for (j = i + 1; j < size; ++j) {
                            if (this.is_consider[j] <= 0 || !(this.ktdistance12[i][j] < min12)) continue;
                            min12 = this.ktdistance12[i][j];
                            j1 = i;
                            j2 = j;
                        }
                    }
                } else {
                    for (j = 0; j < size; ++j) {
                        if (this.is_consider[j] <= 0 || j == j1 || !(this.ktdistance12[j1][j] < min12)) continue;
                        min12 = this.ktdistance12[j1][j];
                        j2 = j;
                    }
                }
                if (j1 > -1) {
                    min1 = this.ktdistance1[j1];
                }
                if (j2 > -1 && this.ktdistance1[j2] < min1) {
                    min1 = this.ktdistance1[j2];
                }
                if (!merged && Nstep == 1) break;
                merged = false;
                if (min12 < min1) {
                    merged = true;
                }
            } else {
                km = -1;
                for (j = 0; j < size; ++j) {
                    if (this.is_consider[j] <= 0 || !(this.ktdistance1[j] < min1)) continue;
                    min1 = this.ktdistance1[j];
                    km = j;
                }
                j1 = -1;
                j2 = -1;
                for (i = 0; i < size - 1; ++i) {
                    if (this.is_consider[i] <= 0) continue;
                    for (j = i + 1; j < size; ++j) {
                        if (this.is_consider[j] <= 0 || !(this.ktdistance12[i][j] < min1)) continue;
                        min1 = this.ktdistance12[i][j];
                        j1 = i;
                        j2 = j;
                    }
                }
                merged = false;
                if (j1 > -1 && j2 > -1) {
                    merged = true;
                }
            }
            if (merged && j1 != j2) {
                p1 = list.get(j1);
                p2 = list.get(j2);
                p1.add(p2, j2);
                --Nstep;
                list.set(j1, p1);
                this.is_consider[j2] = 0;
                this.is_consider[j1] = this.is_consider[j1] + 1;
                this.ktdistance1[j1] = this.getKtDistance1(p1);
                for (i = 0; i < size; ++i) {
                    if (this.is_consider[i] <= 0 || i == j1) continue;
                    ParticleD pp1 = list.get(i);
                    this.ktdistance12[j1][i] = this.getKtDistance12(p1, pp1);
                    if (this.mode >= 0) continue;
                    this.ktdistance12[i][j1] = this.getKtDistance12(p1, pp1);
                }
            }
            if (!merged) {
                if (!this.m_fast) {
                    j1 = km;
                }
                this.is_consider[j1] = -1;
                ParticleD pj = list.get(j1);
                --Nstep;
                if (pj.getPt() > this.minpt) {
                    this.jets.add(pj);
                }
            }
            if (!this.debug) continue;
            System.out.println("## Iteration:" + Integer.toString(++iter));
            for (i = 0; i < size; ++i) {
                p1 = list.get(i);
                String mess = "original";
                if (this.is_consider[i] == -1) {
                    mess = "!final-jet!";
                }
                if (this.is_consider[i] > 1) {
                    mess = "(proto-jet)";
                }
                if (this.is_consider[i] == 0) {
                    mess = "(removed)";
                }
                System.out.println(Integer.toString(i) + "  E=" + Double.toString(p1.e()) + " " + mess);
            }
        }
        if (this.debug) {
            System.out.println("Final Nr of iterations=" + Integer.toString(iter));
            int ins = -1;
            for (i = 0; i < size; ++i) {
                if (this.is_consider[i] != 1) continue;
                ins = i;
            }
            if (ins > -1) {
                ParticleD lp;
                p2 = list.get(ins);
                if (this.debug) {
                    System.out.println("Unmerged particle id=" + Integer.toString(ins));
                }
                min12 = Double.MAX_VALUE;
                for (j = 0; j < this.jets.size(); ++j) {
                    lp = this.jets.get(j);
                    double d = this.getDistance(p2, lp);
                    if (!(d < min12)) continue;
                    j1 = j;
                    min12 = d;
                }
                if (this.debug) {
                    System.out.println("Distance R to closest jet=" + Double.toString(min12));
                }
                if (min12 < this.R) {
                    if (this.debug) {
                        System.out.println(" --> Particle merged");
                    }
                    lp = this.jets.get(j1);
                    lp.add(p2, j1);
                    this.is_consider[ins] = 0;
                }
            }
            int nn = 0;
            ins = -1;
            for (i = 0; i < size; ++i) {
                if (this.is_consider[i] != 1) continue;
                ++nn;
                ins = i;
            }
            if (nn != 0) {
                System.out.println("--> WARNING: particle with ID=" + Integer.toString(ins) + " unmerged");
            }
            long stopTime2 = System.currentTimeMillis();
            long runTime = stopTime2 - startTime;
            System.out.println("  --> Final time for calculation (ms): " + runTime);
            System.out.println("  --> Nr of jets : " + this.jets.size());
        }
        this.is_consider = null;
        this.ktdistance12 = null;
        this.ktdistance1 = null;
        return this.jets;
    }

    public ArrayList<ParticleD> getJetsSorted() {
        Collections.sort(this.jets);
        return this.jets;
    }

    public void printJets() {
        ArrayList<ParticleD> sjets = this.getJetsSorted();
        System.out.println("# Nr of jets=" + Integer.toString(sjets.size()));
        System.out.format("%5s %14s %14s %14s %7s\n", "jet #", "rapidity", "phi", "pt", " const");
        for (int i = 0; i < sjets.size(); ++i) {
            ParticleD lp = sjets.get(i);
            double phi = lp.phi();
            List<Integer> con = lp.getConstituentsList();
            if (phi < 0.0) {
                phi = Math.PI * 2 + phi;
            }
            String s1 = String.format("%15.8f", lp.getRapidity());
            String s2 = String.format("%15.8f", phi);
            String s3 = String.format("%15.8f", lp.getPt());
            String nc = Integer.toString(con.size());
            System.out.format("%5s%15s%15s%15s%7s\n", Integer.toString(i), s1, s2, s3, nc);
        }
    }

    public String toString() {
        ArrayList<ParticleD> sjets = this.getJetsSorted();
        String tmp = "# Nr of jets=" + Integer.toString(sjets.size()) + "\n";
        for (int i = 0; i < sjets.size(); ++i) {
            ParticleD lp = sjets.get(i);
            List<Integer> con = lp.getConstituentsList();
            String spx = this.formatter.format(lp.getRapidity());
            String spy = this.formatter.format(lp.getPhi());
            String spz = this.formatter.format(lp.getPt());
            tmp = tmp + "n=" + Integer.toString(i) + " y=" + spx + " phi=" + spy + " pt=" + spz + " const=" + Integer.toString(con.size()) + "\n";
        }
        return tmp;
    }

    private double phiAngle(double phi) {
        if (phi > Math.PI * 2) {
            phi -= Math.PI * 2;
        }
        if (phi < Math.PI * -2) {
            phi += Math.PI * 2;
        }
        return phi;
    }

    public double getKtDistance12(ParticleD a, ParticleD b) {
        double deltaEta = a.getRapidity() - b.getRapidity();
        double phi1 = a.getPhi();
        double phi2 = b.getPhi();
        double deltaPhi = phi2 - phi1;
        if (deltaPhi > Math.PI) {
            deltaPhi = Math.PI * 2 - deltaPhi;
        }
        if (deltaPhi < -Math.PI) {
            deltaPhi = Math.PI * 2 + deltaPhi;
        }
        double rsq = deltaEta * deltaEta + deltaPhi * deltaPhi;
        double esq = 0.0;
        esq = this.mode == 1 ? Math.min(a.getPt2(), b.getPt2()) : (this.mode == 0 ? 1.0 : (this.mode == -1 ? Math.min(1.0 / a.getPt2(), 1.0 / b.getPt2()) : Math.min(a.getPt2(), b.getPt2())));
        return esq * rsq / this.R2;
    }

    public double getDistance(ParticleD a, ParticleD b) {
        double deltaEta = a.getRapidity() - b.getRapidity();
        double phi1 = a.getPhi();
        double phi2 = b.getPhi();
        double deltaPhi = phi2 - phi1;
        if (deltaPhi > Math.PI) {
            deltaPhi = Math.PI * 2 - deltaPhi;
        }
        if (deltaPhi < -Math.PI) {
            deltaPhi = Math.PI * 2 + deltaPhi;
        }
        double rsq = deltaEta * deltaEta + deltaPhi * deltaPhi;
        return Math.sqrt(rsq);
    }

    public double getKtDistance1(ParticleD a) {
        if (this.mode == 1) {
            return a.getPt2();
        }
        if (this.mode == 0) {
            return 1.0;
        }
        if (this.mode == -1) {
            return 1.0 / a.getPt2();
        }
        return a.getPt2();
    }

    public void setDebug(boolean debug) {
        if (debug) {
            System.out.println("Debug mode is ON");
        }
        this.debug = debug;
    }

    public static void main(String[] args) {
        String data = "jets/single-event.dat";
        if (args.length > 0) {
            data = args[0];
        } else {
            System.out.println("No input file with particles! Exit!");
            System.exit(1);
        }
        for (int i = 0; i < 10; ++i) {
            ArrayList<ParticleD> list = new ArrayList<ParticleD>();
            try {
                String line;
                File file = new File(data);
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line);
                    int j = 0;
                    double[] mom = new double[4];
                    while (st.hasMoreElements()) {
                        Double d = Double.parseDouble(st.nextElement().toString());
                        mom[j] = d;
                        ++j;
                    }
                    ParticleD pp = new ParticleD(mom[0], mom[1], mom[2], mom[3]);
                    list.add(pp);
                }
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Number of particles=" + Integer.toString(list.size()));
            System.out.println("Run Nr=" + Integer.toString(i));
            long startTime = System.currentTimeMillis();
            SCJet kt = new SCJet(0.6, 1, -1, 5.0, true);
            kt.setDebug(false);
            kt.buildJets(list);
            kt.printJets();
            System.out.println("--->  Run time for jet creation: " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
        }
    }
}

