/*
 * Decompiled with CFR 0.152.
 */
package hephysics.jet;

import hephysics.particle.LParticle;
import java.io.Serializable;
import java.text.DecimalFormat;
import jhplot.gui.HelpBrowser;

public class ParticleF
implements Comparable<ParticleF>,
Serializable {
    private static final long serialVersionUID = 1L;
    private float et2;
    private float eta;
    private float phi;
    private float et;
    private DecimalFormat formatter = new DecimalFormat("0.###E0");
    private final double PI2 = Math.PI * 2;

    public ParticleF(LParticle p) {
        this.et2 = (float)p.et2();
        this.eta = (float)p.pseudoRapidity();
        this.phi = (float)p.phi();
        this.et = (float)p.et();
    }

    public ParticleF() {
        this.et2 = 0.0f;
        this.eta = 0.0f;
        this.phi = 0.0f;
        this.et = 0.0f;
    }

    public ParticleF(float px, float py, float pz, float energy) {
        LParticle p = new LParticle(px, py, pz, energy);
        this.et2 = (float)p.et2();
        this.eta = (float)p.pseudoRapidity();
        this.phi = (float)p.phi();
        this.et = (float)p.et();
    }

    public void setPxPyPzE(float px, float py, float pz, float energy) {
        LParticle p = new LParticle(px, py, pz, energy);
        this.et2 = (float)p.et2();
        this.eta = (float)p.pseudoRapidity();
        this.phi = (float)p.phi();
        this.et = (float)p.et();
    }

    public float getEta() {
        return this.eta;
    }

    public float getPhi() {
        return this.phi;
    }

    public float getEt2() {
        return this.et2;
    }

    public float getEt() {
        return this.et;
    }

    public float perp() {
        return this.et;
    }

    public float eta() {
        return this.eta;
    }

    public void setEta(float eta) {
        this.eta = eta;
    }

    public void setEt2(float et2) {
        this.et2 = et2;
    }

    public void setPhi(float phi) {
        this.phi = phi;
    }

    public LParticle getLParticle() {
        double apt = Math.abs(this.et);
        double px = apt * Math.cos(this.phi);
        double py = apt * Math.sin(this.phi);
        double pz = apt * Math.sinh(this.eta);
        double theta = Math.atan2(Math.sqrt(this.et2), pz);
        double energy = (double)this.et / Math.sin(theta);
        LParticle pp = new LParticle(px, py, pz, energy);
        return pp;
    }

    @Override
    public int compareTo(ParticleF o) {
        if (this.et < o.getEt()) {
            return 1;
        }
        if (this.et > o.getEt()) {
            return -1;
        }
        return 0;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public String toString() {
        String se = this.formatter.format(this.et);
        String srap = this.formatter.format(this.eta);
        String sphi = this.formatter.format(this.phi);
        return "et=" + se + " eta=" + srap + " phi=" + sphi;
    }

    public void add(ParticleF a) {
        double et2_2 = a.getEt2();
        double et_2 = a.getEt();
        double eta_2 = a.getEta();
        double phi_2 = a.getPhi();
        double et2_1 = this.et2;
        double et_1 = this.et;
        double eta_1 = this.eta;
        double phi_1 = this.phi;
        this.et = (float)(et_1 + et_2);
        this.et2 = (float)(et2_1 + et2_2);
        this.eta = (float)((et_1 * eta_1 + et_2 * eta_2) / (double)this.et);
        this.phi = (float)((et_1 * phi_1 + et_2 * phi_2) / (double)this.et);
    }

    public int hashCode() {
        return this.hashCode() + (int)Double.doubleToRawLongBits(this.et2);
    }
}

