/*
 * Decompiled with CFR 0.152.
 */
package hephysics.jet;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class ParticleD
implements Comparable<ParticleD>,
Serializable {
    private static final long serialVersionUID = 1L;
    private double px;
    private double py;
    private double pz;
    private double energy;
    private final double PI2 = Math.PI * 2;
    private double phi;
    private double pt2;
    private double rapidity;
    private DecimalFormat formatter = new DecimalFormat("0.###E0");
    private ArrayList<Integer> consts;

    public ParticleD() {
        this.consts = new ArrayList();
    }

    public ParticleD(double px, double py, double pz, double energy) {
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.energy = energy;
        this.cachePhiRapidity();
        this.consts = new ArrayList();
        this.consts.add(new Integer(-1));
    }

    public void setPxPyPzE(double px, double py, double pz, double energy) {
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.energy = energy;
        this.cachePhiRapidity();
    }

    public void setPtEtaPhiM(double pt, double eta, double phi, double m) {
        this.pt2 = pt * pt;
        double apt = Math.abs(pt);
        this.px = apt * Math.cos(phi);
        this.py = apt * Math.sin(phi);
        this.pz = apt * Math.sinh(eta);
        double ee = this.px * this.px + this.py * this.py + this.pz * this.pz - m * m;
        ee = ee < 0.0 ? 0.0 : Math.sqrt(ee);
        this.setPxPyPzE(this.px, this.py, this.pz, ee);
    }

    public double eta() {
        if (this.px == 0.0 && this.py == 0.0) {
            return -999.0;
        }
        if (this.pz == 0.0) {
            return -999.0;
        }
        double pt2 = this.px * this.px + this.py * this.py;
        double theta = Math.atan2(Math.sqrt(pt2), this.pz);
        if (theta < 0.0) {
            theta += Math.PI;
        }
        return -1.0 * Math.log(Math.tan(theta / 2.0));
    }

    public double et2() {
        double pt2x = this.perp2();
        double et2 = pt2x == 0.0 ? 0.0 : this.e() * this.e() * this.pt2 / (pt2x + this.pz() * this.pz());
        return et2;
    }

    public double et() {
        double etet = this.et2();
        return this.e() < 0.0 ? -Math.sqrt(etet) : Math.sqrt(etet);
    }

    public double mass() {
        double m = this.energy * this.energy - this.px * this.px - this.py * this.py - this.pz * this.pz;
        if (m >= 0.0) {
            return Math.sqrt(m);
        }
        return -1.0;
    }

    public double m() {
        return this.mass();
    }

    public double rapidity() {
        this.rapidity = -1.0E11;
        if (this.energy > this.pz()) {
            this.rapidity = 0.5 * Math.log((this.energy + this.pz) / (this.energy - this.pz));
        }
        return this.rapidity;
    }

    public double mag() {
        return Math.sqrt(this.px * this.px + this.py * this.py + this.pz * this.pz);
    }

    public double perp2() {
        return this.px * this.px + this.py * this.py;
    }

    public double perp() {
        return Math.sqrt(this.perp2());
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    @Override
    public int compareTo(ParticleD o) {
        if (this.perp2() < o.perp2()) {
            return 1;
        }
        if (this.perp2() > o.perp2()) {
            return -1;
        }
        return 0;
    }

    public ParticleD copy(ParticleD o) {
        ParticleD tmp = new ParticleD(this.px, this.py, this.pz, this.energy);
        tmp.setRapidity(this.rapidity);
        tmp.setPhi(this.phi);
        tmp.setPt2(this.pt2);
        return tmp;
    }

    public String toString() {
        String spx = this.formatter.format(this.px);
        String spy = this.formatter.format(this.py);
        String spz = this.formatter.format(this.pz);
        String se = this.formatter.format(this.energy);
        String srap = this.formatter.format(this.rapidity);
        String sphi = this.formatter.format(this.phi);
        String set = this.formatter.format(Math.sqrt(this.pt2));
        return "px=" + spx + " py=" + spy + " pz=" + spz + " e=" + se + " y=" + srap + " phi=" + sphi + " pt=" + set;
    }

    public double px() {
        return this.px;
    }

    public double py() {
        return this.py;
    }

    public double pz() {
        return this.pz;
    }

    public double getRapidity() {
        return this.rapidity;
    }

    public double getPt2() {
        return this.pt2;
    }

    public double getPt() {
        return Math.sqrt(this.pt2);
    }

    public double getPhi() {
        return this.phi;
    }

    public List<Integer> getConstituentsList() {
        return this.consts;
    }

    public void setConstituents(ArrayList<Integer> consts) {
        this.consts = consts;
    }

    public void addConstituent(int i) {
        this.consts.add(i);
    }

    public int[] getConstituents() {
        int s = this.consts.size();
        int[] intArray = new int[s];
        for (int i = 0; i < s; ++i) {
            intArray[i] = this.consts.get(i);
        }
        return intArray;
    }

    public double phi() {
        if (this.px == 0.0) {
            return 0.0;
        }
        this.phi = Math.atan2(this.py, this.px);
        return this.phi;
    }

    public double e() {
        return this.energy;
    }

    public void setPx(double px) {
        this.px = px;
    }

    public void setPy(double py) {
        this.py = py;
    }

    public void setPz(double pz) {
        this.pz = pz;
    }

    public void setRapidity(double rapidity) {
        this.rapidity = rapidity;
    }

    public void setPhi(double phi) {
        this.phi = phi;
    }

    public void setPt2(double pt2) {
        this.pt2 = pt2;
    }

    public void cachePhiRapidity() {
        this.rapidity = this.rapidity();
        this.phi = this.phi();
        this.pt2 = this.perp2();
    }

    public void add(ParticleD a) {
        this.px = a.px() + this.px;
        this.py = a.py() + this.py;
        this.pz = a.pz() + this.pz;
        this.energy = a.e() + this.energy;
        this.cachePhiRapidity();
    }

    public void add(ParticleD a, int index) {
        this.px = a.px() + this.px;
        this.py = a.py() + this.py;
        this.pz = a.pz() + this.pz;
        this.energy = a.e() + this.energy;
        this.cachePhiRapidity();
        this.consts.add(new Integer(index));
    }

    public int hashCode() {
        return this.hashCode() + (int)Double.doubleToRawLongBits(this.energy);
    }
}

