/*
 * Decompiled with CFR 0.152.
 */
package hephysics.jet;

import hephysics.jet.ClusterSequence;
import hephysics.jet.ParticleD;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class JetN2 {
    private int recom = 1;
    private double R;
    private final double PI2 = Math.PI * 2;
    private boolean debug = false;
    private double minpt = 0.0;
    private String type = "antikt";
    private ArrayList<ParticleD> jets;
    private DecimalFormat formatter = new DecimalFormat("%.12f");
    private ClusterSequence seq;

    public JetN2(double R, int recom, String type, double minpt) {
        this.R = R;
        this.recom = recom;
        this.debug = false;
        this.minpt = minpt;
        this.type = type.trim();
        DecimalFormat formatter1 = new DecimalFormat("#0.00");
        String rs = formatter1.format(this.R);
        System.out.println("JetN2: Initialization of Java jet algorithm.");
        System.out.println("JetN2: Authors: S.Chekanov (ANL), I.Pogrebnyak (MSU)");
        System.out.println("JetN2: Inclusive mode using the E-scheme recombination and R=" + rs);
        if (type.equalsIgnoreCase("kt")) {
            System.out.println("JetN2: Longitudinally invariant kt algorithm");
        } else if (type.equalsIgnoreCase("ca")) {
            System.out.println("JetN2: Cambridge/Aachen algorithm");
        } else if (type.equalsIgnoreCase("antikt")) {
            System.out.println("JetN2: Longitudinally invariant anti-kt algorithm");
        } else {
            this.type = "antikt";
            System.out.println("JetN2: Not correct mode:  Fallback to the inclusive kT algorithm using E-scheme and R=" + rs);
        }
        if (recom != 1) {
            System.out.println("JetN2: Only E-scheme recombination supported! Exit.");
            System.exit(0);
        }
        this.seq = new ClusterSequence(this.type, R);
    }

    public JetN2(double R, String type, double minpt) {
        this(R, 1, type, minpt);
    }

    public JetN2(double R, double minpt) {
        this(R, 1, "antikt", minpt);
    }

    public JetN2(double R) {
        this(R, 1, "kt", 5.0);
    }

    public List<ParticleD> buildJets(List<ParticleD> list) {
        this.jets = this.seq.cluster(list, this.minpt);
        if (this.debug) {
            this.printJets();
        }
        return this.jets;
    }

    public ArrayList<ParticleD> getJetsSorted() {
        Collections.sort(this.jets);
        return this.jets;
    }

    public void printJets() {
        ArrayList<ParticleD> sjets = this.getJetsSorted();
        System.out.println("# Nr of jets=" + Integer.toString(sjets.size()));
        System.out.format("%5s %14s %14s %14s %7s\n", "jet #", "rapidity", "phi", "pt", " const");
        for (int i = 0; i < sjets.size(); ++i) {
            ParticleD lp = sjets.get(i);
            double phi = lp.phi();
            List<Integer> con = lp.getConstituentsList();
            if (phi < 0.0) {
                phi = Math.PI * 2 + phi;
            }
            String s1 = String.format("%15.8f", lp.getRapidity());
            String s2 = String.format("%15.8f", phi);
            String s3 = String.format("%15.8f", lp.getPt());
            String nc = Integer.toString(con.size());
            System.out.format("%5s%15s%15s%15s%7s\n", Integer.toString(i), s1, s2, s3, nc);
        }
    }

    public String toString() {
        ArrayList<ParticleD> sjets = this.getJetsSorted();
        String tmp = "# Nr of jets=" + Integer.toString(sjets.size()) + "\n";
        for (int i = 0; i < sjets.size(); ++i) {
            ParticleD lp = sjets.get(i);
            List<Integer> con = lp.getConstituentsList();
            String s1 = String.format("%15.8f", lp.getRapidity());
            String s2 = String.format("%15.8f", lp.phi());
            String s3 = String.format("%15.8f", lp.getPt());
            String nc = Integer.toString(con.size());
            tmp = tmp + "n=" + Integer.toString(i) + " y=" + s1 + " phi=" + s2 + " pt=" + s3 + " const=" + nc + "\n";
        }
        return tmp;
    }

    public void setDebug(boolean debug) {
        if (debug) {
            System.out.println("Debug mode is ON");
        }
        this.debug = debug;
    }

    public String info() {
        DecimalFormat formatter1 = new DecimalFormat("#0.00");
        String rs = formatter1.format(this.R);
        String tmp = "";
        tmp = tmp + "JetN2: Initialization of Java jet algorithm:\n";
        tmp = tmp + "JetN2: authors: S.Chekanov (ANL), I.Pogrebnyak (MSU)\n";
        tmp = tmp + "JetN2: Inclusive mode using the E-scheme recombination and R=" + rs + "\n";
        if (this.type.equalsIgnoreCase("kt")) {
            tmp = tmp + "JetN2: Longitudinally invariant kt algorithm\n";
        } else if (this.type.equalsIgnoreCase("ca")) {
            tmp = tmp + "JetN2: Cambridge/Aachen algorithm";
        } else if (this.type.equalsIgnoreCase("antikt")) {
            tmp = tmp + "JetN2: Longitudinally invariant anti-kt algorithm\n";
        } else {
            this.type = "antikt";
            tmp = tmp + "JetN2: Not correct mode:  Fallback to the inclusive antikT algorithm using E-scheme and R=" + rs + "\n";
        }
        if (this.recom != 1) {
            tmp = tmp + "JetN2: Only E-scheme recombination supported! Exit.";
            System.exit(0);
        }
        return tmp;
    }

    public static void main(String[] args) {
        String data = "";
        if (args.length > 0) {
            data = args[0];
        } else {
            System.out.println("No input file with particles! Exit!");
            System.exit(1);
        }
        for (int i = 0; i < 10; ++i) {
            ArrayList<ParticleD> list = new ArrayList<ParticleD>();
            try {
                String line;
                File file = new File(data);
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line);
                    int j = 0;
                    double[] mom = new double[4];
                    while (st.hasMoreElements()) {
                        Double d = Double.parseDouble(st.nextElement().toString());
                        mom[j] = d;
                        ++j;
                    }
                    ParticleD pp = new ParticleD(mom[0], mom[1], mom[2], mom[3]);
                    list.add(pp);
                }
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Number of particles=" + Integer.toString(list.size()));
            System.out.println("Run Nr=" + Integer.toString(i));
            long startTime = System.currentTimeMillis();
            JetN2 kt = new JetN2(0.6, 1, "antikt", 5.0);
            kt.setDebug(false);
            kt.buildJets(list);
            kt.printJets();
            System.out.println("--->  Run time for jet creation: " + Long.toString(System.currentTimeMillis() - startTime) + " ms");
        }
    }
}

