/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.serializers;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.report.util.SerializeMethod;

public class GeneralPathSerializer
implements SerializeMethod {
    static /* synthetic */ Class class$java$awt$geom$GeneralPath;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Class getObjectClass() {
        return class$java$awt$geom$GeneralPath != null ? class$java$awt$geom$GeneralPath : (class$java$awt$geom$GeneralPath = GeneralPathSerializer.class$("java.awt.geom.GeneralPath"));
    }

    public Object readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int winding = in.readInt();
        GeneralPath gp = new GeneralPath(winding);
        int type = in.readInt();
        while (type >= 0) {
            switch (type) {
                case 0: {
                    float x = in.readFloat();
                    float y = in.readFloat();
                    gp.moveTo(x, y);
                    break;
                }
                case 1: {
                    float x = in.readFloat();
                    float y = in.readFloat();
                    gp.lineTo(x, y);
                    break;
                }
                case 2: {
                    float x1 = in.readFloat();
                    float y1 = in.readFloat();
                    float x2 = in.readFloat();
                    float y2 = in.readFloat();
                    gp.quadTo(x1, y1, x2, y2);
                    break;
                }
                case 3: {
                    float x1 = in.readFloat();
                    float y1 = in.readFloat();
                    float x2 = in.readFloat();
                    float y2 = in.readFloat();
                    float x3 = in.readFloat();
                    float y3 = in.readFloat();
                    gp.curveTo(x1, y1, x2, y2, x3, y3);
                    break;
                }
                default: {
                    throw new IOException("Unexpected type encountered: " + type);
                }
                case 4: 
            }
            type = in.readInt();
        }
        return gp;
    }

    public void writeObject(Object o, ObjectOutputStream out) throws IOException {
        GeneralPath gp = (GeneralPath)o;
        PathIterator it = gp.getPathIterator(new AffineTransform());
        out.writeInt(it.getWindingRule());
        while (!it.isDone()) {
            float[] corrds = new float[6];
            int type = it.currentSegment(corrds);
            out.writeInt(type);
            switch (type) {
                case 0: {
                    out.writeFloat(corrds[0]);
                    out.writeFloat(corrds[1]);
                    break;
                }
                case 1: {
                    out.writeFloat(corrds[0]);
                    out.writeFloat(corrds[1]);
                    break;
                }
                case 2: {
                    out.writeFloat(corrds[0]);
                    out.writeFloat(corrds[1]);
                    out.writeFloat(corrds[2]);
                    out.writeFloat(corrds[3]);
                    break;
                }
                case 3: {
                    out.writeFloat(corrds[0]);
                    out.writeFloat(corrds[1]);
                    out.writeFloat(corrds[2]);
                    out.writeFloat(corrds[3]);
                    out.writeFloat(corrds[4]);
                    out.writeFloat(corrds[5]);
                    break;
                }
                default: {
                    throw new IOException("Unexpected type encountered: " + type);
                }
                case 4: 
            }
            it.next();
        }
        out.writeInt(-1);
    }
}

