/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import org.jfree.report.util.Worker;
import org.jfree.report.util.WorkerHandle;

public class WorkerPool {
    private Worker[] workers;
    private boolean workersAvailable;
    private String namePrefix;

    public WorkerPool() {
        this(10);
    }

    public WorkerPool(int size) {
        this(size, "WorkerPool-worker");
    }

    public WorkerPool(int size, String namePrefix) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        this.workers = new Worker[size];
        this.workersAvailable = true;
        this.namePrefix = namePrefix;
    }

    public void finishAll() {
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] != null) {
                this.workers[i].finish();
            }
            ++i;
        }
    }

    public synchronized WorkerHandle getWorkerForWorkload(Runnable r) {
        this.waitForWorkerAvailable();
        int emptySlot = -1;
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] == null) {
                if (emptySlot == -1) {
                    emptySlot = i;
                }
            } else if (this.workers[i].isAvailable()) {
                this.workers[i].setWorkload(r);
                this.updateWorkersAvailable();
                return new WorkerHandle(this.workers[i]);
            }
            ++i;
        }
        if (emptySlot != -1) {
            this.workers[emptySlot] = new Worker();
            this.workers[emptySlot].setName(String.valueOf(this.namePrefix) + "-" + emptySlot);
            this.workers[emptySlot].setWorkerPool(this);
            this.workers[emptySlot].setWorkload(r);
            this.updateWorkersAvailable();
            return new WorkerHandle(this.workers[emptySlot]);
        }
        throw new IllegalStateException("At this point, a worker should already have been assigned.");
    }

    public synchronized boolean isWorkerAvailable() {
        return this.workersAvailable;
    }

    private void updateWorkersAvailable() {
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] == null) {
                this.workersAvailable = true;
                return;
            }
            if (this.workers[i].isAvailable()) {
                this.workersAvailable = true;
                return;
            }
            ++i;
        }
        this.workersAvailable = false;
    }

    private synchronized void waitForWorkerAvailable() {
        while (!this.isWorkerAvailable()) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void workerAvailable(Worker worker) {
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] == worker) {
                WorkerPool workerPool = this;
                synchronized (workerPool) {
                    this.workersAvailable = true;
                    this.notifyAll();
                }
                return;
            }
            ++i;
        }
    }

    public void workerFinished(Worker worker) {
        if (!worker.isFinish()) {
            throw new IllegalArgumentException("This worker is not in the finish state.");
        }
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] == worker) {
                WorkerPool workerPool = this;
                synchronized (workerPool) {
                    this.workers[i] = null;
                    this.workersAvailable = true;
                    this.notifyAll();
                }
                return;
            }
            ++i;
        }
    }
}

