/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.jfree.util.LogTarget;

public class SystemOutLogTarget
implements LogTarget,
Serializable {
    private transient PrintStream printStream;

    public SystemOutLogTarget() {
        this(System.out);
    }

    public SystemOutLogTarget(PrintStream printStream) {
        if (printStream == null) {
            throw new NullPointerException();
        }
        this.printStream = printStream;
    }

    public void log(int level, Object message) {
        if (level > 3) {
            level = 3;
        }
        this.printStream.print(LogTarget.LEVELS[level]);
        this.printStream.println(message);
        if (level < 3) {
            this.printStream.flush();
        }
    }

    public void log(int level, Object message, Exception e) {
        if (level > 3) {
            level = 3;
        }
        this.printStream.print(LogTarget.LEVELS[level]);
        this.printStream.println(message);
        e.printStackTrace(this.printStream);
        if (level < 3) {
            this.printStream.flush();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.printStream = System.out;
    }
}

