/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Arrays;

public class StrokeUtility {
    public static final int STROKE_SOLID = 0;
    public static final int STROKE_DASHED = 1;
    public static final int STROKE_DOTTED = 2;
    public static final int STROKE_DOT_DASH = 3;
    public static final int STROKE_DOT_DOT_DASH = 4;

    private StrokeUtility() {
    }

    public static Stroke createStroke(int type, float width) {
        switch (type) {
            case 1: {
                return new BasicStroke(width, 2, 0, 10.0f, new float[]{6.0f, 6.0f}, 0.0f);
            }
            case 2: {
                return new BasicStroke(width, 2, 0, 5.0f, new float[]{0.1f, 2.0f}, 0.0f);
            }
            case 3: {
                return new BasicStroke(width, 2, 0, 10.0f, new float[]{2.0f, 2.0f, 6.0f, 2.0f}, 0.0f);
            }
            case 4: {
                return new BasicStroke(width, 2, 0, 10.0f, new float[]{2.0f, 2.0f, 2.0f, 2.0f, 6.0f, 2.0f}, 0.0f);
            }
        }
        return new BasicStroke(width);
    }

    public static int getStrokeType(Stroke s) {
        float factor2;
        float factor1;
        float[] copyDashes;
        if (!(s instanceof BasicStroke)) {
            return 0;
        }
        BasicStroke bs = (BasicStroke)s;
        float[] dashes = bs.getDashArray();
        if (dashes == null) {
            return 0;
        }
        if (dashes.length < 2) {
            return 0;
        }
        if (dashes.length == 3 || dashes.length == 5) {
            return 0;
        }
        if (dashes.length == 2) {
            if (dashes[0] < 2.0f && dashes[1] < 2.0f) {
                return 2;
            }
            float factor = dashes[0] / dashes[1];
            if ((double)factor > 0.9 && (double)factor < 1.1) {
                return 1;
            }
            return 0;
        }
        if (dashes.length == 4) {
            copyDashes = (float[])dashes.clone();
            Arrays.sort(copyDashes);
            factor1 = copyDashes[0] / copyDashes[1];
            factor2 = copyDashes[0] / copyDashes[2];
            float factorBig = copyDashes[0] / copyDashes[3];
            if ((double)factor1 < 0.9 || (double)factor1 > 1.1 || (double)factor2 < 0.9 || (double)factor2 > 1.1) {
                return 0;
            }
            if ((double)factorBig < 0.9 || (double)factorBig > 1.1) {
                if (copyDashes[0] < 2.0f) {
                    return 2;
                }
                return 1;
            }
            if ((double)factorBig > 2.5) {
                return 3;
            }
        }
        if (dashes.length == 6) {
            copyDashes = (float[])dashes.clone();
            Arrays.sort(copyDashes);
            factor1 = copyDashes[0] / copyDashes[1];
            factor2 = copyDashes[0] / copyDashes[2];
            float factor3 = copyDashes[0] / copyDashes[3];
            float factor4 = copyDashes[0] / copyDashes[4];
            float factorBig = copyDashes[0] / copyDashes[5];
            if ((double)factor1 < 0.9 || (double)factor1 > 1.1 || (double)factor2 < 0.9 || (double)factor2 > 1.1 || (double)factor3 < 0.9 || (double)factor3 > 1.1 || (double)factor4 < 0.9 || (double)factor4 > 1.1) {
                return 0;
            }
            if ((double)factorBig < 0.9 || (double)factorBig > 1.1) {
                if (copyDashes[0] < 2.0f) {
                    return 2;
                }
                return 1;
            }
            if ((double)factorBig > 2.5) {
                return 3;
            }
        }
        return 0;
    }

    public static float getStrokeWidth(Stroke s) {
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            return bs.getLineWidth();
        }
        return 1.0f;
    }
}

