/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.style;

import java.io.Serializable;
import java.util.HashMap;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleSheetCarrier;
import org.jfree.report.util.InstanceID;

public class StyleSheetCollection
implements Cloneable,
Serializable {
    private HashMap styleSheets = new HashMap();
    private HashMap styleSheetsByID = new HashMap();

    public Object clone() throws CloneNotSupportedException {
        StyleSheetCollection sc = (StyleSheetCollection)super.clone();
        sc.styleSheets = (HashMap)this.styleSheets.clone();
        sc.styleSheetsByID = (HashMap)this.styleSheetsByID.clone();
        ManagedStyleSheet[] styles = this.styleSheets.values().toArray(new ManagedStyleSheet[this.styleSheets.size()]);
        ManagedStyleSheet[] styleClones = (ManagedStyleSheet[])styles.clone();
        int i = 0;
        while (i < styles.length) {
            ManagedStyleSheet clone = styles[i].createManagedCopy(sc);
            sc.styleSheets.put(clone.getName(), clone);
            sc.styleSheetsByID.put(clone.getId(), clone);
            styleClones[i] = clone;
            ++i;
        }
        return sc;
    }

    public ElementStyleSheet createStyleSheet(String name) {
        if (this.styleSheets.containsKey(name)) {
            return (ElementStyleSheet)this.styleSheets.get(name);
        }
        ManagedStyleSheet value = new ManagedStyleSheet(name, this);
        this.styleSheets.put(name, value);
        this.styleSheetsByID.put(value.getId(), value);
        return value;
    }

    public ElementStyleSheet getStyleSheet(String name) {
        return (ElementStyleSheet)this.styleSheets.get(name);
    }

    public ElementStyleSheet getStyleSheetByID(InstanceID name) {
        return (ElementStyleSheet)this.styleSheetsByID.get(name);
    }

    protected static class ManagedStyleSheetCarrier
    implements StyleSheetCarrier {
        private InstanceID styleSheetID;
        private ManagedStyleSheet styleSheet;
        private ManagedStyleSheet self;

        public ManagedStyleSheetCarrier(ManagedStyleSheet parent, ManagedStyleSheet self) {
            this.styleSheetID = parent.getId();
            this.styleSheet = parent;
            this.self = self;
            self.addListener(this.styleSheet);
        }

        public Object clone() throws CloneNotSupportedException {
            ManagedStyleSheetCarrier o = (ManagedStyleSheetCarrier)super.clone();
            o.styleSheet = null;
            return o;
        }

        public ElementStyleSheet getStyleSheet() {
            if (this.styleSheet != null) {
                return this.styleSheet;
            }
            StyleSheetCollection col = this.self.getStyleSheetCollection();
            this.styleSheet = (ManagedStyleSheet)col.getStyleSheetByID(this.styleSheetID);
            if (this.styleSheet == null) {
                throw new IllegalStateException("Stylesheet was not valid after restore operation.");
            }
            return this.styleSheet;
        }

        public void invalidate() {
            this.self.removeListener(this.getStyleSheet());
        }

        public boolean isSame(ElementStyleSheet style) {
            return style.getId().equals(this.styleSheetID);
        }

        protected void updateParentReference(ManagedStyleSheet self) {
            this.self = self;
        }
    }

    protected static class ManagedStyleSheet
    extends ElementStyleSheet {
        private StyleSheetCollection styleSheetCollection;

        public ManagedStyleSheet(String name, StyleSheetCollection collection) {
            super(name);
            if (collection == null) {
                throw new NullPointerException();
            }
            this.styleSheetCollection = collection;
        }

        public void addParent(int position, ManagedStyleSheet parent) {
            super.addParent(position, parent);
        }

        public void addParent(ManagedStyleSheet parent) {
            super.addParent(0, parent);
        }

        public Object clone() throws CloneNotSupportedException {
            ManagedStyleSheet ms = (ManagedStyleSheet)super.clone();
            ms.styleSheetCollection = null;
            StyleSheetCarrier[] sheets = ms.getParentReferences();
            int i = 0;
            while (i < sheets.length) {
                ManagedStyleSheetCarrier msc = (ManagedStyleSheetCarrier)sheets[i];
                msc.updateParentReference(ms);
                ++i;
            }
            return ms;
        }

        protected StyleSheetCarrier createCarrier(ElementStyleSheet styleSheet) {
            if (!(styleSheet instanceof ManagedStyleSheet)) {
                throw new IllegalArgumentException("Only stylesheets that are managed by this stylesheet collection can be added");
            }
            ManagedStyleSheet ms = (ManagedStyleSheet)styleSheet;
            if (ms.getStyleSheetCollection() != this.getStyleSheetCollection()) {
                throw new IllegalArgumentException("Only stylesheets that are managed by this stylesheet collection can be added");
            }
            return new ManagedStyleSheetCarrier(ms, this);
        }

        public ManagedStyleSheet createManagedCopy(StyleSheetCollection collection) throws CloneNotSupportedException {
            ManagedStyleSheet es = (ManagedStyleSheet)this.getCopy();
            es.setStyleSheetCollection(collection);
            return es;
        }

        public StyleSheetCollection getStyleSheetCollection() {
            return this.styleSheetCollection;
        }

        protected void setStyleSheetCollection(StyleSheetCollection styleSheetCollection) {
            this.styleSheetCollection = styleSheetCollection;
        }
    }
}

