/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.states;

import java.awt.print.PageFormat;
import java.util.Date;
import java.util.Iterator;
import org.jfree.report.JFreeReport;
import org.jfree.report.PageDefinition;
import org.jfree.report.states.FinishState;
import org.jfree.report.states.PostReportInitializedState;
import org.jfree.report.states.ReportState;

public final class StartState
extends ReportState {
    public StartState(JFreeReport report, String exportDescription) throws CloneNotSupportedException {
        super(report, exportDescription);
        Iterator it = this.getLevels();
        if (it.hasNext()) {
            Integer i = (Integer)this.getLevels().next();
            this.getFunctions().setLevel(i);
        } else {
            this.getFunctions().setLevel(0);
        }
    }

    public StartState(FinishState fstate, int level) {
        super(fstate, true);
        this.getFunctions().setLevel(level);
    }

    public ReportState advance() {
        this.setCurrentPage(0);
        this.setProperty("report.date", new Date());
        this.setProperty("report.datasource", this.getDataRowBackend().getTablemodel());
        PageDefinition p = this.getReport().getPageDefinition();
        PageFormat pf = p.getPageFormat(0);
        this.setProperty("report.pageformat", pf);
        this.fireReportInitializedEvent();
        this.nextPage();
        return new PostReportInitializedState(this);
    }

    public int getEventCode() {
        return 4;
    }

    public boolean isPrefetchState() {
        return true;
    }

    public boolean isStart() {
        return true;
    }

    public void resetState() {
        super.resetState();
    }
}

