/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.resourceloader;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import org.jfree.report.resourceloader.ImageFactoryModule;
import org.jfree.report.util.StringUtil;

public class PNGImageFactoryModule
implements ImageFactoryModule {
    private static final int[] PNGID = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private static final String[] MIMETYPES = new String[]{"image/png", "application/png", "application/x-png"};

    public boolean canHandleResourceByContent(byte[] content) {
        int i = 0;
        while (i < PNGID.length) {
            if (PNGID[i] != content[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canHandleResourceByMimeType(String name) {
        int i = 0;
        while (i < MIMETYPES.length) {
            if (name.equals(MIMETYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canHandleResourceByName(String name) {
        return StringUtil.endsWithIgnoreCase(name, ".png");
    }

    public Image createImage(byte[] imageData, String fileName, String mimeType) throws IOException {
        return Toolkit.getDefaultToolkit().createImage(imageData);
    }

    public int getHeaderFingerprintSize() {
        return PNGID.length;
    }
}

