/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.resourceloader;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import org.jfree.report.resourceloader.ImageFactoryModule;
import org.jfree.report.util.StringUtil;

public class JPEGImageFactoryModule
implements ImageFactoryModule {
    private static final byte[] JFIF_ID;
    private static final String[] MIMETYPES;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 74;
        byArray[1] = 70;
        byArray[2] = 73;
        byArray[3] = 70;
        JFIF_ID = byArray;
        MIMETYPES = new String[]{"image/jpeg", "image/jpg", "image/jp_", "application/jpg", "application/x-jpg", "image/pjpeg", "image/pipeg", "image/vnd.swiftview-jpeg", "image/x-xbitmap"};
    }

    public boolean canHandleResourceByContent(byte[] content) {
        if (content[0] != 255 && content[1] != 216) {
            return false;
        }
        int i = 0;
        while (i < JFIF_ID.length) {
            if (JFIF_ID[i] != content[6 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canHandleResourceByMimeType(String name) {
        int i = 0;
        while (i < MIMETYPES.length) {
            if (name.equals(MIMETYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canHandleResourceByName(String name) {
        return StringUtil.endsWithIgnoreCase(name, ".jpg") || StringUtil.endsWithIgnoreCase(name, ".jpeg");
    }

    public Image createImage(byte[] imageData, String fileName, String mimeType) throws IOException {
        return Toolkit.getDefaultToolkit().createImage(imageData);
    }

    public int getHeaderFingerprintSize() {
        return 11;
    }
}

