/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateCollection;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateDescription;
import org.jfree.report.modules.parser.ext.readhandlers.CompoundObjectReadHandler;
import org.jfree.xml.ParseException;
import org.jfree.xml.parser.RootXmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class TemplateReadHandler
extends CompoundObjectReadHandler {
    private TemplateCollection templateCollection;
    private boolean nameRequired;

    public TemplateReadHandler(boolean nameRequired, CommentHintPath commentHintPath) {
        super(null, commentHintPath);
        this.nameRequired = nameRequired;
    }

    public void init(RootXmlReadHandler rootHandler, String tagName) {
        super.init(rootHandler, tagName);
        this.templateCollection = (TemplateCollection)rootHandler.getHelperObject("::template-factory");
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        String templateName = attrs.getValue("name");
        if (this.nameRequired && templateName == null) {
            throw new ParseException("The 'name' attribute is required for template definitions", this.getRootHandler().getLocator());
        }
        String references = attrs.getValue("references");
        if (references == null) {
            throw new ParseException("The 'references' attribute is required for template definitions", this.getRootHandler().getLocator());
        }
        TemplateDescription template = this.templateCollection.getTemplate(references);
        if (template == null) {
            throw new ParseException("The template '" + references + "' is not defined", this.getRootHandler().getLocator());
        }
        template = (TemplateDescription)template.getInstance();
        if (templateName != null) {
            template.setName(templateName);
            this.templateCollection.addTemplate(template);
            if (this.nameRequired) {
                this.getCommentHintPath().addName(templateName);
            }
        }
        this.setObjectDescription(template);
    }
}

