/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.ext.factory.stylekey.StyleKeyFactory;
import org.jfree.report.modules.parser.ext.readhandlers.CompoundObjectReadHandler;
import org.jfree.report.modules.parser.ext.readhandlers.StyleExtendsReadHandler;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleKey;
import org.jfree.report.style.StyleSheetCollection;
import org.jfree.util.Configuration;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;
import org.jfree.xml.parser.RootXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class StyleReadHandler
extends CompoundObjectReadHandler {
    private StyleSheetCollection styleSheetCollection;
    private ElementStyleSheet styleSheet;
    private boolean createStyle;
    static /* synthetic */ Class class$org$jfree$report$style$ElementStyleSheet;

    public StyleReadHandler() {
        this(null);
    }

    public StyleReadHandler(ElementStyleSheet styleSheet) {
        super(new ElementStyleSheetObjectDescription(), new CommentHintPath());
        this.styleSheet = styleSheet;
        this.createStyle = styleSheet == null;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("extends")) {
            return new StyleExtendsReadHandler(this.styleSheetCollection, this.styleSheet);
        }
        if (tagName.equals("basic-key")) {
            return this.handleBasicObject(atts);
        }
        if (tagName.equals("compound-key")) {
            return this.handleCompoundObject(atts);
        }
        return null;
    }

    public Object getObject() throws XmlReaderException {
        return this.styleSheet;
    }

    public void init(RootXmlReadHandler rootHandler, String tagName) {
        super.init(rootHandler, tagName);
        JFreeReport report = (JFreeReport)rootHandler.getHelperObject("::report");
        this.styleSheetCollection = report.getStyleSheetCollection();
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        if (this.createStyle) {
            String name = attrs.getValue("name");
            if (name == null) {
                throw new ElementDefinitionException("Required attribute 'name' is missing.", this.getRootHandler().getLocator());
            }
            this.styleSheet = this.styleSheetCollection.createStyleSheet(name);
        }
        this.getCommentHintPath().addName(this.styleSheet);
        ElementStyleSheetObjectDescription objectDescription = (ElementStyleSheetObjectDescription)this.getObjectDescription();
        objectDescription.init(this.getRootHandler(), this.styleSheet);
    }

    private static class ElementStyleSheetObjectDescription
    implements ObjectDescription {
        private StyleKeyFactory keyfactory;
        private ElementStyleSheet styleSheet;

        public void configure(Configuration config) {
        }

        public Object createObject() {
            return this.styleSheet;
        }

        public ObjectDescription getInstance() {
            throw new UnsupportedOperationException("This is a private factory, go away.");
        }

        public Class getObjectClass() {
            return class$org$jfree$report$style$ElementStyleSheet != null ? class$org$jfree$report$style$ElementStyleSheet : (class$org$jfree$report$style$ElementStyleSheet = StyleReadHandler.class$("org.jfree.report.style.ElementStyleSheet"));
        }

        public Object getParameter(String name) {
            StyleKey key = this.keyfactory.getStyleKey(name);
            if (key == null) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            return this.styleSheet.getStyleProperty(key);
        }

        public Class getParameterDefinition(String name) {
            StyleKey key = this.keyfactory.getStyleKey(name);
            if (key == null) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            return key.getValueType();
        }

        public Iterator getParameterNames() {
            return ((AbstractList)new ArrayList()).iterator();
        }

        public ObjectDescription getUnconfiguredInstance() {
            throw new UnsupportedOperationException("This is a private factory, go away.");
        }

        public void init(RootXmlReadHandler rootHandler, ElementStyleSheet styleSheet) {
            this.keyfactory = (StyleKeyFactory)rootHandler.getHelperObject("::stylekey-factory");
            this.styleSheet = styleSheet;
        }

        public void setParameter(String name, Object value) {
            StyleKey key = this.keyfactory.getStyleKey(name);
            if (key == null) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            this.styleSheet.setStyleProperty(key, value);
        }

        public void setParameterFromObject(Object o) throws ObjectFactoryException {
            throw new UnsupportedOperationException("This is a private factory, go away.");
        }
    }
}

