/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.readhandlers;

import java.util.ArrayList;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.ext.factory.elements.ElementFactoryCollector;
import org.jfree.report.modules.parser.ext.readhandlers.ElementReadHandler;
import org.jfree.report.modules.parser.ext.readhandlers.StyleReadHandler;
import org.jfree.util.Log;
import org.jfree.xml.ParseException;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class BandReadHandler
extends ElementReadHandler {
    private ArrayList elementHandlers = new ArrayList();

    public BandReadHandler(Band element) {
        super(element);
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        super.doneParsing();
        Band band = (Band)this.getElement();
        int i = 0;
        while (i < this.elementHandlers.size()) {
            ElementReadHandler readHandler = (ElementReadHandler)((Object)this.elementHandlers.get(i));
            band.addElement(readHandler.getElement());
            ++i;
        }
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("style")) {
            return new StyleReadHandler(this.getElement().getStyle());
        }
        if (tagName.equals("default-style")) {
            Log.warn((Object)"Tag <default-style> is deprecated. All definitions have been mapped into the bands primary style sheet.");
            return new StyleReadHandler(this.getElement().getStyle());
        }
        if (tagName.equals("element")) {
            String type = atts.getValue("type");
            if (type == null) {
                throw new ParseException("The element's 'type' attribute is missing", this.getRootHandler().getLocator());
            }
            ElementFactoryCollector fc = (ElementFactoryCollector)this.getRootHandler().getHelperObject("::element-factory");
            Element element = fc.getElementForType(type);
            if (element == null) {
                throw new ParseException("There is no factory for elements of type '" + type + "'");
            }
            ElementReadHandler readHandler = new ElementReadHandler(element);
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        if (tagName.equals("band")) {
            BandReadHandler readHandler = new BandReadHandler(new Band());
            this.elementHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void storeComments() throws SAXException {
    }
}

