/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.factory.templates;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.report.filter.templates.Template;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateCollection;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateDescription;
import org.jfree.util.Configuration;

public class TemplateCollector
extends TemplateCollection {
    private final ArrayList factories = new ArrayList();

    public void addTemplateCollection(TemplateCollection tc) {
        this.factories.add(tc);
        if (this.getConfig() != null) {
            tc.configure(this.getConfig());
        }
    }

    public void configure(Configuration config) {
        if (this.getConfig() != null) {
            return;
        }
        super.configure(config);
        Iterator it = ((AbstractList)this.factories).iterator();
        while (it.hasNext()) {
            TemplateCollection od = (TemplateCollection)it.next();
            od.configure(config);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateCollector)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateCollector templateCollector = (TemplateCollector)o;
        return ((AbstractList)this.factories).equals(templateCollector.factories);
    }

    public TemplateDescription getDescription(Template template) {
        int i = 0;
        while (i < this.factories.size()) {
            TemplateCollection fact = (TemplateCollection)this.factories.get(i);
            TemplateDescription o = fact.getDescription(template);
            if (o != null) {
                return o;
            }
            ++i;
        }
        return super.getDescription(template);
    }

    public Iterator getFactories() {
        return ((AbstractList)this.factories).iterator();
    }

    public TemplateDescription getTemplate(String name) {
        int i = 0;
        while (i < this.factories.size()) {
            TemplateCollection fact = (TemplateCollection)this.factories.get(i);
            TemplateDescription o = fact.getTemplate(name);
            if (o != null) {
                return o;
            }
            ++i;
        }
        return super.getTemplate(name);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + ((AbstractList)this.factories).hashCode();
        return result;
    }
}

