/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.ext.factory.templates;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.report.filter.templates.Template;
import org.jfree.report.modules.parser.ext.factory.templates.TemplateDescription;
import org.jfree.util.Configuration;

public class TemplateCollection
implements Serializable {
    private final HashMap templates = new HashMap();
    private Configuration config;

    public void addTemplate(TemplateDescription template) {
        this.templates.put(template.getName(), template);
        if (this.getConfig() != null) {
            template.configure(this.getConfig());
        }
    }

    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        if (this.config != null) {
            return;
        }
        this.config = config;
        Iterator it = this.templates.values().iterator();
        while (it.hasNext()) {
            TemplateDescription od = (TemplateDescription)it.next();
            od.configure(config);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateCollection)) {
            return false;
        }
        TemplateCollection templateCollection = (TemplateCollection)o;
        return this.templates.equals(templateCollection.templates);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public TemplateDescription getDescription(Template template) {
        if (template == null) {
            throw new NullPointerException("Template given must not be null.");
        }
        Iterator values = this.templates.values().iterator();
        while (values.hasNext()) {
            TemplateDescription td = (TemplateDescription)values.next();
            if (!td.getObjectClass().equals(template.getClass())) continue;
            return (TemplateDescription)td.getInstance();
        }
        return null;
    }

    public String[] getNames() {
        return this.templates.keySet().toArray(new String[this.templates.size()]);
    }

    public TemplateDescription getTemplate(String name) {
        TemplateDescription td = (TemplateDescription)this.templates.get(name);
        if (td != null) {
            return (TemplateDescription)td.getInstance();
        }
        return null;
    }

    public int hashCode() {
        return this.templates.hashCode();
    }
}

