/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.xml;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportEventException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.xml.XMLWriter;
import org.jfree.report.states.FinishState;
import org.jfree.report.states.ReportState;
import org.jfree.report.states.ReportStateProgress;
import org.jfree.report.states.StartState;
import org.jfree.report.util.NullOutputStream;
import org.jfree.report.util.ReportConfigurationUtil;
import org.jfree.util.Configuration;

public class XMLProcessor {
    private static final String XML_WRITER = "org.jfree.report.targets.xml-writer";
    private Writer writer;
    private JFreeReport report;

    public XMLProcessor(JFreeReport report) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        try {
            this.report = (JFreeReport)report.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("Initial Clone of Report failed");
        }
        XMLWriter lm = new XMLWriter();
        lm.setName(XML_WRITER);
        this.report.addExpression(lm);
    }

    protected JFreeReport getReport() {
        return this.report;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void processReport() throws ReportProcessingException {
        if (this.writer == null) {
            throw new IllegalStateException("No writer defined");
        }
        try {
            ReportState state = this.repaginate();
            XMLWriter w = (XMLWriter)state.getDataRow().get(XML_WRITER);
            w.setWriter(this.getWriter());
            boolean failOnError = ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
            ReportStateProgress progress = null;
            while (!state.isFinish()) {
                progress = state.createStateProgress(progress);
                state = state.advance();
                if (failOnError && state.isErrorOccured()) {
                    throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                }
                if (state.isFinish() || state.isProceeding(progress)) continue;
                throw new ReportProcessingException("State did not proceed, bailing out!");
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ReportProcessingException("StateCopy was not supported");
        }
    }

    private ReportState repaginate() throws ReportProcessingException, CloneNotSupportedException {
        boolean hasNext;
        StartState startState = new StartState(this.getReport(), "document/xml");
        ReportState state = startState;
        ReportState retval = null;
        state.setProperty("report.preparerun", Boolean.TRUE);
        XMLWriter w = (XMLWriter)state.getDataRow().get(XML_WRITER);
        w.setWriter(new OutputStreamWriter(new NullOutputStream()));
        Iterator it = startState.getLevels();
        if (!it.hasNext()) {
            throw new IllegalStateException("No functions defined, invalid implementation.");
        }
        ReportStateProgress progress = null;
        int level = (Integer)it.next();
        do {
            if (level == -1) {
                retval = (ReportState)state.clone();
            }
            boolean failOnError = ReportConfigurationUtil.isStrictErrorHandling((Configuration)this.getReport().getReportConfiguration());
            while (!state.isFinish()) {
                progress = state.createStateProgress(progress);
                state = state.advance();
                if (failOnError && state.isErrorOccured()) {
                    throw new ReportEventException("Failed to dispatch an event.", state.getErrors());
                }
                if (state.isFinish() || state.isProceeding(progress)) continue;
                throw new ReportProcessingException("State did not proceed, bailing out!");
            }
            hasNext = it.hasNext();
            if (!hasNext) continue;
            level = (Integer)it.next();
            if (state instanceof FinishState) {
                state = new StartState((FinishState)state, level);
                continue;
            }
            throw new IllegalStateException("Repaginate did not produce an finish state");
        } while (hasNext);
        state.setProperty("report.preparerun", Boolean.FALSE);
        StartState sretval = (StartState)retval;
        if (sretval == null) {
            throw new IllegalStateException("There was no valid pagination done.");
        }
        sretval.resetState();
        return sretval;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

