/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls.util;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.poi.hssf.util.HSSFColor;
import org.jfree.util.Log;

public final class ExcelColorSupport {
    private static Hashtable triplets;

    private ExcelColorSupport() {
    }

    public static short getNearestColor(Color awtColor) {
        if (triplets == null) {
            triplets = HSSFColor.getTripletHash();
        }
        if (triplets == null || triplets.isEmpty()) {
            Log.warn((Object)"Unable to get triplet hashtable");
            return 8;
        }
        short color = 8;
        double minDiff = Double.MAX_VALUE;
        float[] hsb = Color.RGBtoHSB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue(), null);
        float[] excelHsb = null;
        Enumeration elements = triplets.elements();
        while (elements.hasMoreElements()) {
            HSSFColor crtColor = (HSSFColor)elements.nextElement();
            short[] rgb = crtColor.getTriplet();
            excelHsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], excelHsb);
            double weight = 3.0 * (double)Math.abs(excelHsb[0] - hsb[0]) + (double)Math.abs(excelHsb[1] - hsb[1]) + (double)Math.abs(excelHsb[2] - hsb[2]);
            if (!(weight < minDiff)) continue;
            minDiff = weight;
            if (minDiff == 0.0) {
                return crtColor.getIndex();
            }
            color = crtColor.getIndex();
        }
        return color;
    }
}

