/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls.metaelements;

import com.keypoint.PngEncoder;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jfree.io.IOUtils;
import org.jfree.report.ImageContainer;
import org.jfree.report.LocalImageContainer;
import org.jfree.report.URLImageContainer;
import org.jfree.report.content.ImageContent;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.modules.output.table.xls.ExcelExportContext;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelMetaElement;
import org.jfree.report.resourceloader.ImageFactory;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.util.Log;
import org.jfree.util.WaitingImageObserver;

public class ExcelImageElement
extends ExcelMetaElement {
    public ExcelImageElement(ImageContent elementContent, ElementStyleSheet style) {
        super(elementContent, style);
    }

    public void applyValue(ExcelExportContext context, HSSFCell cell) {
        StrictBounds cb;
        ImageContent rawContent = (ImageContent)this.getContent();
        SheetLayout currentLayout = context.getCurrentLayout();
        TableRectangle rectangle = currentLayout.getTableBounds(cb = rawContent.getBounds(), null);
        if (rectangle == null) {
            Log.debug((Object)"Invalid reference: I was not able to compute the rectangle for the content.");
            return;
        }
        int cell1x = rectangle.getX1();
        int cell1y = rectangle.getY1();
        int cell2x = Math.max(cell1x, rectangle.getX2() - 1);
        int cell2y = Math.max(cell1y, rectangle.getY2() - 1);
        long cell1width = currentLayout.getCellWidth(cell1x);
        long cell1height = currentLayout.getRowHeight(cell1y);
        long cell2width = currentLayout.getCellWidth(cell2x);
        long cell2height = currentLayout.getRowHeight(cell2y);
        long cell1xPos = currentLayout.getXPosition(cell1x);
        long cell1yPos = currentLayout.getYPosition(cell1y);
        long cell2xPos = currentLayout.getXPosition(cell2x);
        long cell2yPos = currentLayout.getYPosition(cell2y);
        int dx1 = (int)(1023.0 * ((double)(cb.getX() - cell1xPos) / (double)cell1width));
        int dy1 = (int)(255.0 * ((double)(cb.getY() - cell1yPos) / (double)cell1height));
        int dx2 = (int)(1023.0 * ((double)(cb.getX() + cb.getWidth() - cell2xPos) / (double)cell2width));
        int dy2 = (int)(255.0 * ((double)(cb.getY() + cb.getHeight() - cell2yPos) / (double)cell2height));
        HSSFClientAnchor anchor = new HSSFClientAnchor(dx1, dy1, dx2, dy2, (short)cell1x, cell1y, (short)cell2x, cell2y);
        anchor.setAnchorType(1);
        try {
            int pictureId = this.loadImage(context.getWorkbook());
            if (pictureId > 0) {
                context.getPatriarch().createPicture(anchor, pictureId);
            }
        }
        catch (IOException iOException) {
            Log.warn((Object)"Failed to add image. Ignoring.");
        }
    }

    private byte[] encodeImage(Image image) {
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        PngEncoder encoder = new PngEncoder(image, true, 0, 5);
        return encoder.pngEncode();
    }

    private int getImageFormat(URL sourceURL) {
        if (sourceURL.getFile().equalsIgnoreCase(".png")) {
            return 6;
        }
        if (sourceURL.getFile().equalsIgnoreCase(".jpg") || sourceURL.getFile().equalsIgnoreCase(".jpeg")) {
            return 5;
        }
        if (sourceURL.getFile().equalsIgnoreCase(".bmp") || sourceURL.getFile().equalsIgnoreCase(".ico")) {
            return 7;
        }
        return -1;
    }

    public int loadImage(HSSFWorkbook workbook) throws IOException {
        int format;
        URLImageContainer urlImage;
        ImageContent rawContent = (ImageContent)this.getContent();
        ImageContainer reference = rawContent.getContent();
        URL url = null;
        if (reference instanceof URLImageContainer && (url = (urlImage = (URLImageContainer)reference).getSourceURL()) != null && (format = this.getImageFormat(urlImage.getSourceURL())) != -1 && urlImage.isLoadable()) {
            BufferedInputStream urlIn = new BufferedInputStream(urlImage.getSourceURL().openStream());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.getInstance().copyStreams((InputStream)urlIn, (OutputStream)bout);
            ((InputStream)urlIn).close();
            bout.close();
            byte[] data = bout.toByteArray();
            return workbook.addPicture(data, format);
        }
        if (reference instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)reference;
            Image image = li.getImage();
            if (image == null && url != null) {
                image = ImageFactory.getInstance().createImage(url);
            }
            if (image != null) {
                byte[] data = this.encodeImage(image);
                return workbook.addPicture(data, 6);
            }
        }
        return -1;
    }
}

