/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.SheetLayoutCollection;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableContentCreator;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.modules.output.table.xls.ExcelExportContext;
import org.jfree.report.modules.output.table.xls.HSSFCellStyleProducer;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelMetaElement;
import org.jfree.report.modules.output.table.xls.util.ExcelPrintSetupFactory;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.Log;

public class ExcelContentCreator
extends TableContentCreator
implements ExcelExportContext {
    private HSSFCellStyleProducer cellStyleProducer;
    private OutputStream outputStream;
    private boolean open;
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private boolean newTable;
    private double scaleFactor;
    private HSSFPatriarch patriarch;
    private HashMap sheetNamesCount;

    public ExcelContentCreator(SheetLayoutCollection sheetLayoutCollection, OutputStream outputStream) {
        super(sheetLayoutCollection);
        this.outputStream = outputStream;
        this.sheetNamesCount = new HashMap();
    }

    private void exportCell(MetaElement element, TableRectangle rectangle, short x, int y) {
        HSSFCell cell = this.getCellAt(x, y);
        if (rectangle.getColumnSpan() > 1 || rectangle.getRowSpan() > 1) {
            this.sheet.addMergedRegion(new Region(y, x, y + rectangle.getRowSpan() - 1, (short)(x + rectangle.getColumnSpan() - 1)));
            int rectX = rectangle.getX1();
            int rectY = rectangle.getY1();
            int row = 0;
            while (row < rectangle.getRowSpan()) {
                int col = 0;
                while (col < rectangle.getColumnSpan()) {
                    TableCellBackground bg = this.getCurrentLayout().getElementAt(rectY + row, rectX + col);
                    HSSFCell regionCell = this.getCellAt((short)(x + col), y + row);
                    HSSFCellStyle style = this.cellStyleProducer.createCellStyle(element, bg);
                    if (style != null) {
                        regionCell.setCellStyle(style);
                    }
                    ++col;
                }
                ++row;
            }
        } else {
            TableCellBackground bg = this.getCurrentLayout().getRegionBackground(rectangle);
            HSSFCellStyle style = this.cellStyleProducer.createCellStyle(element, bg);
            if (style != null) {
                cell.setCellStyle(style);
            }
        }
        if (element instanceof ExcelMetaElement) {
            ExcelMetaElement me = (ExcelMetaElement)element;
            cell.setEncoding((short)1);
            me.applyValue(this, cell);
        }
    }

    private HSSFCell getCellAt(short x, int y) {
        HSSFRow row = this.getRowAt(y);
        HSSFCell cell = row.getCell(x);
        if (cell != null) {
            return cell;
        }
        return row.createCell(x);
    }

    public SheetLayout getCurrentLayout() {
        return super.getCurrentLayout();
    }

    public HSSFSheet getCurrentSheet() {
        return this.sheet;
    }

    public int getLayoutOffset() {
        return super.getLayoutOffset();
    }

    public HSSFPatriarch getPatriarch() {
        if (this.patriarch == null) {
            this.patriarch = this.getCurrentSheet().createDrawingPatriarch();
        }
        return this.patriarch;
    }

    private HSSFRow getRowAt(int y) {
        HSSFRow row = this.sheet.getRow(y);
        if (row != null) {
            return row;
        }
        return this.sheet.createRow(y);
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    protected void handleBeginTable(ReportDefinition reportDefinition) throws ReportProcessingException {
        ModifiableConfiguration config = reportDefinition.getReportConfiguration();
        try {
            String scaleFactorText = config.getConfigProperty("org.jfree.report.modules.output.table.xls.CellWidthScaleFactor");
            this.scaleFactor = scaleFactorText == null ? 50.0 : Double.parseDouble(scaleFactorText);
        }
        catch (Exception exception) {
            this.scaleFactor = 50.0;
        }
        this.newTable = true;
        String sheetName = null;
        if (this.getSheetNameFunction() != null) {
            sheetName = String.valueOf(reportDefinition.getDataRow().get(this.getSheetNameFunction()));
        }
        if (sheetName == null) {
            this.sheet = this.workbook.createSheet();
        } else {
            String uniqueSheetname = this.makeUnique(sheetName);
            if (uniqueSheetname.length() == 0 || uniqueSheetname.length() > 31) {
                Log.warn((Object)"A sheet name must not be empty and greater than 31 characters");
                this.sheet = this.workbook.createSheet();
            } else if (!this.isValidSheetName(uniqueSheetname)) {
                Log.warn((Object)"A sheet name must not contain any of '/\\*?[]'");
                this.sheet = this.workbook.createSheet();
            } else {
                Log.debug((Object)("Creating a workbook: " + uniqueSheetname));
                this.sheet = this.workbook.createSheet(uniqueSheetname);
            }
        }
        this.patriarch = null;
        String paper = config.getConfigProperty("org.jfree.report.modules.output.table.xls.Paper");
        String paperOrientation = config.getConfigProperty("org.jfree.report.modules.output.table.xls.PaperOrientation");
        HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
        ExcelPrintSetupFactory.performPageSetup(printSetup, reportDefinition.getPageDefinition(), paper, paperOrientation);
        boolean displayGridLines = "true".equals(config.getConfigProperty("org.jfree.report.modules.output.table.xls.GridLinesDisplayed"));
        boolean printGridLines = "true".equals(config.getConfigProperty("org.jfree.report.modules.output.table.xls.GridLinesPrinted"));
        this.sheet.setDisplayGridlines(displayGridLines);
        this.sheet.setPrintGridlines(printGridLines);
    }

    protected void handleClose() throws ReportProcessingException {
        this.open = false;
        try {
            this.workbook.write(this.outputStream);
            this.patriarch = null;
            this.sheet = null;
        }
        catch (IOException e) {
            Log.warn((Object)"could not write xls data. Message:", (Exception)e);
        }
    }

    protected void handleEndTable() throws ReportProcessingException {
        this.patriarch = null;
        this.sheet = null;
    }

    public boolean handleFlush() throws ReportProcessingException {
        int layoutOffset;
        GenericObjectTable go = this.getBackend();
        SheetLayout layout = this.getCurrentLayout();
        int width = Math.max(go.getColumnCount(), layout.getColumnCount());
        if (this.newTable) {
            int i = 0;
            while (i < width) {
                double cellWidth = StrictGeomUtility.toExternalValue(layout.getCellWidth(i, i + 1));
                double poiCellWidth = cellWidth * this.scaleFactor;
                this.sheet.setColumnWidth((short)i, (short)poiCellWidth);
                i = (short)(i + 1);
            }
            this.newTable = false;
        }
        int height = go.getRowCount();
        int y = layoutOffset = this.getLayoutOffset();
        while (y < height + layoutOffset) {
            HSSFRow row = this.getRowAt((short)y);
            double lastRowHeight = StrictGeomUtility.toExternalValue(layout.getRowHeight(y));
            row.setHeightInPoints((float)((short)lastRowHeight));
            ++y;
        }
        int y2 = layoutOffset;
        while (y2 < height + layoutOffset) {
            int x = 0;
            while (x < width) {
                MetaElement element = (MetaElement)go.getObject(y2 - layoutOffset, x);
                if (element == null) {
                    TableCellBackground background = layout.getElementAt(y2, x);
                    if (background != null) {
                        HSSFCell cell = this.getCellAt((short)x, y2);
                        HSSFCellStyle style = this.cellStyleProducer.createCellStyle(null, background);
                        if (style != null) {
                            cell.setCellStyle(style);
                        }
                    }
                } else {
                    TableRectangle rectangle = layout.getTableBounds(element, this.getLookupRectangle());
                    if (rectangle.isOrigin(x, y2)) {
                        this.exportCell(element, rectangle, (short)x, y2);
                    }
                }
                ++x;
            }
            ++y2;
        }
        return true;
    }

    protected void handleOpen(ReportDefinition reportDefinition) throws ReportProcessingException {
        this.open = true;
        this.workbook = new HSSFWorkbook();
        boolean hardLimit = "true".equals(reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.table.xls.HardStyleCountLimit"));
        this.cellStyleProducer = new HSSFCellStyleProducer(this.workbook, hardLimit);
    }

    public boolean isOpen() {
        return this.open;
    }

    private boolean isValidSheetName(String sheetname) {
        return sheetname.indexOf(47) <= -1 && sheetname.indexOf(92) <= -1 && sheetname.indexOf(63) <= -1 && sheetname.indexOf(42) <= -1 && sheetname.indexOf(93) <= -1 && sheetname.indexOf(91) <= -1;
    }

    private String makeUnique(String name) {
        Integer count = (Integer)this.sheetNamesCount.get(name);
        if (count == null) {
            this.sheetNamesCount.put(name, new Integer(1));
            return name;
        }
        int value = count + 1;
        this.sheetNamesCount.put(name, new Integer(value));
        return this.makeUnique(String.valueOf(name) + " " + value);
    }
}

