/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.rtf;

import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.table.base.LayoutCreator;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.modules.output.table.base.TableProcessor;
import org.jfree.report.modules.output.table.rtf.RTFContentCreator;
import org.jfree.report.modules.output.table.rtf.RTFMetaBandProducer;
import org.jfree.report.util.EncodingSupport;

public class RTFProcessor
extends TableProcessor {
    public static final String CONFIGURATION_PREFIX = "org.jfree.report.targets.table.rtf";
    private OutputStream outputStream;

    public RTFProcessor(JFreeReport report) throws ReportProcessingException {
        super(report);
        this.init();
    }

    protected TableCreator createContentCreator() {
        LayoutCreator layoutCreator = this.getLayoutCreator();
        return new RTFContentCreator(layoutCreator.getSheetLayoutCollection(), this.getOutputStream());
    }

    protected MetaBandProducer createMetaBandProducer() {
        String encoding = this.getReport().getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + ".Encoding", EncodingSupport.getPlatformDefaultEncoding());
        return new RTFMetaBandProducer(encoding, this.isMaxLineHeightUsed());
    }

    protected String getExportDescription() {
        return "table/rtf";
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected String getReportConfigurationPrefix() {
        return CONFIGURATION_PREFIX;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

