/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Color;
import java.awt.Stroke;
import org.jfree.report.ElementAlignment;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.modules.output.table.html.HtmlContentStyle;
import org.jfree.report.modules.output.table.html.HtmlStyleCollection;
import org.jfree.report.modules.output.table.html.HtmlTableCellStyle;
import org.jfree.report.modules.output.table.html.HtmlTableRowStyle;
import org.jfree.report.modules.output.table.html.metaelements.HtmlTextMetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.ObjectUtilities;

public class HtmlSheetLayout
extends SheetLayout {
    private HtmlStyleCollection styleCollection;
    private TableRectangle rectangle;
    private GenericObjectTable backgroundStyleTable;
    private GenericObjectTable contentStyleTable;
    private GenericObjectTable verticalAlignmentTable;
    private boolean tableRowBorderDefinition;

    public HtmlSheetLayout(boolean strict, HtmlStyleCollection collection, boolean tableRowBorderDefinition) {
        super(strict);
        if (collection == null) {
            throw new NullPointerException();
        }
        this.styleCollection = collection;
        this.rectangle = new TableRectangle();
        this.contentStyleTable = new GenericObjectTable(20, 5);
        this.backgroundStyleTable = new GenericObjectTable(20, 5);
        this.verticalAlignmentTable = new GenericObjectTable(20, 5);
        this.tableRowBorderDefinition = tableRowBorderDefinition;
    }

    public void add(MetaElement element) {
        super.add(element);
        if (element instanceof TableCellBackground) {
            return;
        }
        if (element instanceof HtmlTextMetaElement) {
            this.addStringContentStyle(element);
        }
    }

    private void addStringContentStyle(MetaElement element) {
        FontDefinition font = element.getFontDefinitionProperty();
        Color color = (Color)element.getProperty(ElementStyleSheet.PAINT);
        ElementAlignment halign = (ElementAlignment)element.getProperty(ElementStyleSheet.ALIGNMENT);
        ElementAlignment valign = (ElementAlignment)element.getProperty(ElementStyleSheet.VALIGNMENT);
        HtmlContentStyle style = new HtmlContentStyle(font, color, halign);
        String styleName = this.styleCollection.addContentStyle(style);
        TableRectangle rect = this.getTableBounds(element, this.rectangle);
        int y = rect.getY1();
        while (y < rect.getY2()) {
            int row = this.mapRow(y);
            int x = rect.getX1();
            while (x < rect.getX2()) {
                int column = this.mapColumn(x);
                if (this.contentStyleTable.getObject(row, column) == null) {
                    this.contentStyleTable.setObject(row, column, styleName);
                    this.verticalAlignmentTable.setObject(row, column, valign);
                }
                ++x;
            }
            ++y;
        }
    }

    protected void columnInserted(long coordinate, int oldColumn, int newColumn) {
        super.columnInserted(coordinate, oldColumn, newColumn);
        this.contentStyleTable.copyColumn(oldColumn, newColumn);
        this.backgroundStyleTable.copyColumn(oldColumn, newColumn);
        this.verticalAlignmentTable.copyColumn(oldColumn, newColumn);
    }

    public String getBackgroundStyleAt(int row, int column) {
        return (String)this.backgroundStyleTable.getObject(row, column);
    }

    public String getContentStyleAt(int row, int column) {
        return (String)this.contentStyleTable.getObject(this.mapRow(row), this.mapColumn(column));
    }

    public HtmlStyleCollection getStyleCollection() {
        return this.styleCollection;
    }

    protected ElementAlignment getVerticalAlignmentAt(int row, int column) {
        int mcolumn;
        int mrow = this.mapRow(row);
        ElementAlignment ea = (ElementAlignment)this.verticalAlignmentTable.getObject(mrow, mcolumn = this.mapColumn(column));
        if (ea == null) {
            return ElementAlignment.LEFT;
        }
        return ea;
    }

    public boolean isTableRowBorderDefinition() {
        return this.tableRowBorderDefinition;
    }

    public void pageCompleted() {
        this.removeAuxilaryBounds();
        Long[] yCuts = this.getYCuts();
        if (yCuts.length == 0) {
            this.clearObjectIdTable();
            return;
        }
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        TableRectangle rect = null;
        int layoutRow = 0;
        while (layoutRow < rowCount) {
            Color rowColor = null;
            Color borderTop = null;
            Color borderBottom = null;
            Stroke borderTopSize = null;
            Stroke borderBottomSize = null;
            int layoutCol = 0;
            while (layoutCol < columnCount) {
                SheetLayout.CellReference reference = this.getContentAt(layoutRow, layoutCol);
                TableCellBackground bg = reference != null ? ((rect = this.getTableBounds(reference.getBounds(), rect)).getColumnSpan() == 1 && rect.getRowSpan() == 1 ? this.getElementAt(layoutRow, layoutCol) : this.getRegionBackground(rect)) : this.getElementAt(layoutRow, layoutCol);
                ElementAlignment verticalAlignment = this.getVerticalAlignmentAt(layoutRow, layoutCol);
                if (bg == null) {
                    rowColor = null;
                    borderTop = null;
                    borderTopSize = null;
                    borderBottom = null;
                    borderBottomSize = null;
                } else {
                    Color bgColor = bg.getColor();
                    if (layoutCol == 0) {
                        rowColor = bgColor;
                        borderTopSize = bg.getBorderStrokeTop();
                        borderTop = bg.getColorTop();
                        borderBottom = bg.getColorBottom();
                        borderBottomSize = bg.getBorderStrokeBottom();
                    } else {
                        if (!ObjectUtilities.equal((Object)bgColor, (Object)rowColor)) {
                            rowColor = null;
                        }
                        if (!ObjectUtilities.equal((Object)borderTop, (Object)bg.getColorTop())) {
                            borderTop = null;
                            borderTopSize = null;
                        }
                        if (!ObjectUtilities.equal((Object)borderBottom, (Object)bg.getColorBottom())) {
                            borderBottom = null;
                            borderBottomSize = null;
                        }
                    }
                }
                HtmlTableCellStyle style = new HtmlTableCellStyle(bg, verticalAlignment);
                String styleName = this.styleCollection.addCellStyle(style);
                this.backgroundStyleTable.setObject(layoutRow, layoutCol, styleName);
                ++layoutCol;
            }
            int height = (int)Math.ceil(StrictGeomUtility.toExternalValue(this.getRowHeight(layoutRow)));
            HtmlTableRowStyle style = new HtmlTableRowStyle(height, rowColor, this.tableRowBorderDefinition);
            style.setBorderTop(borderTop, borderTopSize);
            style.setBorderBottom(borderBottom, borderBottomSize);
            this.styleCollection.addRowStyle(style);
            ++layoutRow;
        }
        this.clearObjectIdTable();
        this.verticalAlignmentTable.clear();
    }

    protected void rowInserted(long coordinate, int oldRow, int newRow) {
        super.rowInserted(coordinate, oldRow, newRow);
        this.contentStyleTable.copyRow(oldRow, newRow);
        this.backgroundStyleTable.copyRow(oldRow, newRow);
        this.verticalAlignmentTable.copyRow(oldRow, newRow);
    }
}

