/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.table.html.DirectoryHtmlFilesystem;
import org.jfree.report.modules.output.table.html.HtmlProcessor;
import org.jfree.report.modules.output.table.html.StreamHtmlFilesystem;
import org.jfree.report.modules.output.table.html.ZIPHtmlFilesystem;

public final class HtmlReportUtil {
    private HtmlReportUtil() {
    }

    public static void createDirectoryHTML(JFreeReport report, String filename) throws IOException, ReportProcessingException {
        HtmlProcessor pr = new HtmlProcessor(report);
        pr.setFilesystem(new DirectoryHtmlFilesystem(new File(filename)));
        pr.processReport();
    }

    public static void createStreamHTML(JFreeReport report, String filename) throws IOException, ReportProcessingException {
        File file = new File(filename).getAbsoluteFile();
        HtmlProcessor pr = new HtmlProcessor(report);
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(file));
        pr.setFilesystem(new StreamHtmlFilesystem(fout, true, file.getParentFile().toURL()));
        pr.processReport();
        ((OutputStream)fout).close();
    }

    public static void createZIPHTML(JFreeReport report, String filename) throws IOException, ReportProcessingException {
        HtmlProcessor pr = new HtmlProcessor(report);
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(filename));
        pr.setFilesystem(new ZIPHtmlFilesystem(fout, "data"));
        pr.processReport();
        ((OutputStream)fout).close();
    }
}

