/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.pageable.base.OutputTargetException;
import org.jfree.report.modules.output.pageable.base.PageableReportProcessor;
import org.jfree.report.modules.output.pageable.plaintext.PlainTextOutputTarget;
import org.jfree.report.modules.output.pageable.plaintext.TextFilePrinterDriver;

public final class PlainTextReportUtil {
    private PlainTextReportUtil() {
    }

    public static void createPlainText(JFreeReport report, String filename) throws IOException, ReportProcessingException, OutputTargetException {
        PlainTextReportUtil.createPlainText(report, filename, 10.0f, 6.0f);
    }

    public static void createPlainText(JFreeReport report, String filename, float charsPerInch, float linesPerInch) throws IOException, ReportProcessingException, OutputTargetException {
        PageableReportProcessor pr = new PageableReportProcessor(report);
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(filename));
        TextFilePrinterDriver pc = new TextFilePrinterDriver(fout, charsPerInch, linesPerInch);
        PlainTextOutputTarget target = new PlainTextOutputTarget(pc);
        pr.setOutputTarget(target);
        target.open();
        pr.processReport();
        target.close();
        ((OutputStream)fout).close();
    }

    public static void createTextFile(JFreeReport report, String filename) throws IOException, ReportProcessingException, OutputTargetException {
        PlainTextReportUtil.createTextFile(report, filename, 10.0f, 6.0f);
    }

    public static void createTextFile(JFreeReport report, String filename, float charsPerInch, float linesPerInch) throws IOException, ReportProcessingException, OutputTargetException {
        PageableReportProcessor pr = new PageableReportProcessor(report);
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(filename));
        TextFilePrinterDriver pc = new TextFilePrinterDriver(fout, charsPerInch, linesPerInch);
        String lineSeparator = report.getReportConfiguration().getConfigProperty("line.separator", "\n");
        pc.setEndOfLine(lineSeparator.toCharArray());
        pc.setEndOfPage(lineSeparator.toCharArray());
        PlainTextOutputTarget target = new PlainTextOutputTarget(pc);
        pr.setOutputTarget(target);
        target.open();
        pr.processReport();
        target.close();
        ((OutputStream)fout).close();
    }

    public static byte[] getInitSequence(JFreeReport report) throws IOException {
        String encoding = report.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.RawEncoding", "Raw");
        String sequence = report.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.pageable.plaintext.RawInitSequence");
        if (sequence == null) {
            return null;
        }
        if (encoding.equalsIgnoreCase("Raw")) {
            char[] rawChars = sequence.toCharArray();
            byte[] rawBytes = new byte[rawChars.length];
            int i = 0;
            while (i < rawBytes.length) {
                rawBytes[i] = (byte)rawChars[i];
                ++i;
            }
            return rawBytes;
        }
        return sequence.getBytes(encoding);
    }
}

