/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.util.HashMap;
import java.util.TreeSet;
import org.jfree.report.modules.output.pageable.plaintext.PrinterEncoding;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecification;

public class DefaultPrinterSpecification
implements PrinterSpecification,
Cloneable {
    private String name;
    private String displayName;
    private HashMap encodings = new HashMap();
    private TreeSet operations = new TreeSet();
    private PrinterEncoding[] encodingsCached;

    public DefaultPrinterSpecification(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public synchronized void addEncoding(PrinterEncoding encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (!this.encodings.containsKey(encoding.getEncoding())) {
            this.encodings.put(encoding.getEncoding().toLowerCase(), encoding);
            this.encodingsCached = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPrinterSpecification spec = (DefaultPrinterSpecification)super.clone();
        spec.encodings = (HashMap)this.encodings.clone();
        return spec;
    }

    public synchronized boolean contains(PrinterEncoding encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        return this.encodings.containsValue(encoding);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public synchronized PrinterEncoding getEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        PrinterEncoding enc = (PrinterEncoding)this.encodings.get(encoding.toLowerCase());
        if (enc == null) {
            throw new IllegalArgumentException("Encoding is not supported.");
        }
        return enc;
    }

    public String getName() {
        return this.name;
    }

    public synchronized PrinterEncoding[] getSupportedEncodings() {
        if (this.encodingsCached == null) {
            PrinterEncoding[] encodingArray = new PrinterEncoding[this.encodings.size()];
            this.encodingsCached = this.encodings.values().toArray(encodingArray);
        }
        return this.encodingsCached;
    }

    public synchronized boolean isEncodingSupported(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        return this.encodings.containsKey(encoding.toLowerCase());
    }

    public boolean isFeatureAvailable(String operationName) {
        return this.operations.contains(operationName);
    }

    public synchronized void removeEncoding(PrinterEncoding encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (this.encodings.remove(encoding.getEncoding().toLowerCase()) != null) {
            this.encodingsCached = null;
        }
    }
}

