/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.pdf;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.ObjectUtilities;

public class VolatilePdfState {
    private PdfGState[] fillGState;
    private PdfGState[] strokeGState;
    private int currentFillGState;
    private int currentStrokeGState;
    private PdfContentByte contentByte;
    private BasicStroke stroke;
    private Paint fillPaint;
    private Paint strokePaint;
    private float height;
    private StrictBounds currentBounds;

    public VolatilePdfState(PdfContentByte contentByte, float height) {
        if (contentByte == null) {
            throw new NullPointerException("ContentByte must not be null");
        }
        this.stroke = new BasicStroke(1.0f);
        this.contentByte = contentByte;
        this.fillGState = new PdfGState[256];
        this.strokeGState = new PdfGState[256];
        this.currentFillGState = 255;
        this.currentStrokeGState = 255;
        this.height = height;
        this.currentBounds = new StrictBounds();
    }

    private void createTextureFromPaint(Paint paint, boolean fill) {
        try {
            int type = paint.getTransparency() == 1 ? 5 : 6;
            float x = (float)StrictGeomUtility.toExternalValue(this.currentBounds.getX());
            float y = (float)StrictGeomUtility.toExternalValue(this.currentBounds.getY());
            float width = (float)StrictGeomUtility.toExternalValue(this.currentBounds.getWidth());
            BufferedImage img = new BufferedImage((int)width, (int)this.height, type);
            Graphics2D g = (Graphics2D)img.getGraphics();
            AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
            g.transform(transform);
            AffineTransform inv = transform.createInverse();
            Shape fillRect = new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight());
            fillRect = inv.createTransformedShape(fillRect);
            g.setPaint(paint);
            g.fill(fillRect);
            g.dispose();
            com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((Image)img, null);
            PdfPatternPainter pattern = this.contentByte.createPattern(width, this.height);
            image.setAbsolutePosition(0.0f, 0.0f);
            pattern.addImage(image);
            if (fill) {
                this.contentByte.setPatternFill(pattern);
            } else {
                this.contentByte.setPatternStroke(pattern);
            }
        }
        catch (Exception exception) {
            this.setColor(Color.gray, fill);
        }
    }

    public StrictBounds getCurrentBounds() {
        return (StrictBounds)this.currentBounds.clone();
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    private AffineTransform getInverseTransform() {
        double[] dArray = new double[6];
        dArray[0] = 1.0;
        dArray[3] = -1.0;
        dArray[4] = 1.0;
        dArray[5] = this.height;
        double[] mx = dArray;
        return new AffineTransform(mx);
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public Paint getStrokePaint() {
        return this.fillPaint;
    }

    private boolean isMakeDash(BasicStroke nStroke, BasicStroke oStroke) {
        if (nStroke.getDashArray() != null) {
            if (nStroke.getDashPhase() != oStroke.getDashPhase()) {
                return true;
            }
            return Arrays.equals(nStroke.getDashArray(), oStroke.getDashArray()) ^ true;
        }
        return oStroke.getDashArray() != null;
    }

    private float normalizeY(float y) {
        return this.height - y;
    }

    private void setColor(Color color, boolean fill) {
        int alpha = color.getAlpha();
        if (fill) {
            if (alpha != this.currentFillGState) {
                this.currentFillGState = alpha;
                PdfGState gs = this.fillGState[alpha];
                if (gs == null) {
                    gs = new PdfGState();
                    gs.setFillOpacity((float)alpha / 255.0f);
                    this.fillGState[alpha] = gs;
                }
                this.contentByte.setGState(gs);
            }
            this.contentByte.setColorFill(color);
        } else {
            if (alpha != this.currentStrokeGState) {
                this.currentStrokeGState = alpha;
                PdfGState gs = this.strokeGState[alpha];
                if (gs == null) {
                    gs = new PdfGState();
                    gs.setStrokeOpacity((float)alpha / 255.0f);
                    this.strokeGState[alpha] = gs;
                }
                this.contentByte.setGState(gs);
            }
            this.contentByte.setColorStroke(color);
        }
    }

    public void setCurrentBounds(StrictBounds currentBounds) {
        this.currentBounds.setRect(currentBounds.getX(), currentBounds.getY(), currentBounds.getWidth(), currentBounds.getHeight());
    }

    private void setGradientPaint(GradientPaint gp, boolean fill) {
        float x = (float)StrictGeomUtility.toExternalValue(this.currentBounds.getX());
        float y = (float)StrictGeomUtility.toExternalValue(this.currentBounds.getY());
        Point2D p1 = gp.getPoint1();
        p1.setLocation(p1.getX() + (double)x, p1.getY() + (double)y);
        Point2D p2 = gp.getPoint2();
        p2.setLocation(p2.getX() + (double)x, p2.getY() + (double)y);
        Color c1 = gp.getColor1();
        Color c2 = gp.getColor2();
        PdfShading shading = PdfShading.simpleAxial((PdfWriter)this.contentByte.getPdfWriter(), (float)((float)p1.getX()), (float)this.normalizeY((float)p1.getY()), (float)((float)p2.getX()), (float)this.normalizeY((float)p2.getY()), (Color)c1, (Color)c2);
        PdfShadingPattern pat = new PdfShadingPattern(shading);
        if (fill) {
            this.contentByte.setShadingFill(pat);
        } else {
            this.contentByte.setShadingStroke(pat);
        }
    }

    public void setPaint(Paint paint, boolean fill) {
        if (fill ? ObjectUtilities.equal((Object)this.fillPaint, (Object)paint) : ObjectUtilities.equal((Object)this.strokePaint, (Object)paint)) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint, fill);
        } else if (paint instanceof GradientPaint) {
            this.setGradientPaint((GradientPaint)paint, fill);
        } else if (paint instanceof TexturePaint) {
            this.setTexturePaint((TexturePaint)paint, fill);
        } else {
            this.createTextureFromPaint(paint, fill);
        }
        if (fill) {
            this.fillPaint = paint;
        } else {
            this.strokePaint = paint;
        }
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new NullPointerException();
        }
        if (!(stroke instanceof BasicStroke)) {
            return;
        }
        this.setStrokeDiff(this.stroke, (BasicStroke)stroke);
        this.stroke = (BasicStroke)stroke;
    }

    private void setStrokeDiff(BasicStroke nStroke, BasicStroke oStroke) {
        if (nStroke == oStroke) {
            return;
        }
        if (nStroke.getLineWidth() != oStroke.getLineWidth()) {
            this.contentByte.setLineWidth(nStroke.getLineWidth());
        }
        if (nStroke.getEndCap() != oStroke.getEndCap()) {
            switch (nStroke.getEndCap()) {
                case 0: {
                    this.contentByte.setLineCap(0);
                    break;
                }
                case 2: {
                    this.contentByte.setLineCap(2);
                    break;
                }
                default: {
                    this.contentByte.setLineCap(1);
                }
            }
        }
        if (nStroke.getLineJoin() != oStroke.getLineJoin()) {
            switch (nStroke.getLineJoin()) {
                case 0: {
                    this.contentByte.setLineJoin(0);
                    break;
                }
                case 2: {
                    this.contentByte.setLineJoin(2);
                    break;
                }
                default: {
                    this.contentByte.setLineJoin(1);
                }
            }
        }
        if (nStroke.getMiterLimit() != oStroke.getMiterLimit()) {
            this.contentByte.setMiterLimit(nStroke.getMiterLimit());
        }
        if (this.isMakeDash(nStroke, oStroke)) {
            float[] dash = nStroke.getDashArray();
            this.contentByte.setLineDash(dash, nStroke.getDashPhase());
        }
    }

    private void setTexturePaint(TexturePaint tp, boolean fill) {
        try {
            BufferedImage img = tp.getImage();
            Rectangle2D rect = tp.getAnchorRect();
            com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((Image)img, null);
            PdfPatternPainter pattern = this.contentByte.createPattern(image.width(), image.height());
            AffineTransform inverse = this.getInverseTransform();
            inverse.translate(rect.getX(), rect.getY());
            inverse.scale(rect.getWidth() / (double)image.width(), -rect.getHeight() / (double)image.height());
            double[] mx = new double[6];
            inverse.getMatrix(mx);
            pattern.setPatternMatrix((float)mx[0], (float)mx[1], (float)mx[2], (float)mx[3], (float)mx[4], (float)mx[5]);
            image.setAbsolutePosition(0.0f, 0.0f);
            pattern.addImage(image);
            if (fill) {
                this.contentByte.setPatternFill(pattern);
            } else {
                this.contentByte.setPatternStroke(pattern);
            }
        }
        catch (Exception exception) {
            this.setColor(Color.gray, fill);
        }
    }
}

