/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.meta;

import org.jfree.report.content.Content;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.style.StyleKey;
import org.jfree.report.util.geom.StrictBounds;

public class MetaElement
implements Cloneable {
    private ElementStyleSheet styleProperties;
    private Content elementContent;
    private String name;
    private StrictBounds bounds;

    public MetaElement(Content elementContent, ElementStyleSheet style) {
        if (elementContent == null) {
            throw new NullPointerException("ElementContent must not be null.");
        }
        if (style == null) {
            throw new NullPointerException("Style is null.");
        }
        this.styleProperties = style;
        this.elementContent = elementContent;
    }

    public Object clone() throws CloneNotSupportedException {
        MetaElement e = (MetaElement)super.clone();
        if (this.bounds != null) {
            e.bounds = (StrictBounds)this.bounds.clone();
        }
        return e;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaElement)) {
            return false;
        }
        MetaElement element = (MetaElement)o;
        if (!this.elementContent.equals(element.elementContent)) {
            return false;
        }
        return this.styleProperties.equals(element.styleProperties);
    }

    public final boolean getBooleanProperty(StyleKey key) {
        return this.styleProperties.getBooleanStyleProperty(key);
    }

    public final StrictBounds getBounds() {
        if (this.bounds == null) {
            return (StrictBounds)this.styleProperties.getStyleProperty(ElementStyleSheet.BOUNDS);
        }
        return this.bounds;
    }

    public Content getContent() {
        return this.elementContent;
    }

    public final FontDefinition getFontDefinitionProperty() {
        return this.styleProperties.getFontDefinitionProperty();
    }

    public String getName() {
        return this.name;
    }

    public Object getProperty(StyleKey key) {
        return this.styleProperties.getStyleProperty(key);
    }

    public Object getProperty(StyleKey key, Object value) {
        return this.styleProperties.getStyleProperty(key, value);
    }

    public int hashCode() {
        int result = this.styleProperties.hashCode();
        result = 29 * result + this.elementContent.hashCode();
        return result;
    }

    public void setBounds(StrictBounds bounds) {
        this.bounds = bounds;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("MetaElement={bounds=");
        s.append(this.getBounds());
        s.append(", content=");
        s.append(this.getContent());
        s.append("}");
        return s.toString();
    }
}

