/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.referencedoc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceCollector;
import org.jfree.report.modules.parser.ext.factory.datasource.DataSourceFactory;
import org.jfree.xml.factory.objects.ObjectDescription;

public class DataSourceReferenceTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"datasource-factory", "datasource-name", "datasource-class"};
    private final ArrayList rows = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    public DataSourceReferenceTableModel(DataSourceCollector cf) {
        this.addFactoryCollector(cf);
    }

    private void addDataSourceFactory(DataSourceFactory cf) {
        Iterator it = cf.getRegisteredNames();
        ArrayList<String> factories = new ArrayList<String>();
        while (it.hasNext()) {
            String c = (String)it.next();
            factories.add(c);
        }
        Collections.sort(factories);
        it = ((AbstractList)factories).iterator();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            ObjectDescription od = cf.getDataSourceDescription(keyName);
            this.rows.add(new DataSourceDescriptionRow(cf, keyName, od.getObjectClass()));
        }
    }

    private void addFactoryCollector(DataSourceCollector cf) {
        Iterator it = cf.getFactories();
        while (it.hasNext()) {
            DataSourceFactory cfact = (DataSourceFactory)it.next();
            if (cfact instanceof DataSourceCollector) {
                this.addFactoryCollector((DataSourceCollector)cfact);
                continue;
            }
            this.addDataSourceFactory(cfact);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DataSourceReferenceTableModel.class$("java.lang.String"));
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        DataSourceDescriptionRow or = (DataSourceDescriptionRow)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(or.getFactory().getClass().getName());
            }
            case 1: {
                return String.valueOf(or.getName());
            }
            case 2: {
                return String.valueOf(or.getImplementingClass().getName());
            }
        }
        return null;
    }

    private static class DataSourceDescriptionRow {
        private final DataSourceFactory datasourceFactory;
        private final String datasourceName;
        private final Class implementingClass;

        public DataSourceDescriptionRow(DataSourceFactory datasourceFactory, String name, Class implementingClass) {
            this.datasourceFactory = datasourceFactory;
            this.datasourceName = name;
            this.implementingClass = implementingClass;
        }

        public DataSourceFactory getFactory() {
            return this.datasourceFactory;
        }

        public Class getImplementingClass() {
            return this.implementingClass;
        }

        public String getName() {
            return this.datasourceName;
        }
    }
}

