/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.configstore.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.jfree.report.modules.misc.configstore.base.ConfigFactory;
import org.jfree.report.modules.misc.configstore.base.ConfigStorage;
import org.jfree.report.modules.misc.configstore.base.ConfigStoreException;

public class FileConfigStorage
implements ConfigStorage {
    private final File baseDirectory;
    private static final String CONFIGHEADER = "part of the jfreereport filesystem config store";

    public FileConfigStorage(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public boolean existsProperties(String configPath) {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        File target = new File(this.baseDirectory, configPath);
        return target.exists() && target.canRead();
    }

    public Properties loadProperties(String configPath, Properties defaults) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The given path is not valid.");
        }
        try {
            Properties properties = new Properties(defaults);
            File target = new File(this.baseDirectory, configPath);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(target));
            properties.load(in);
            ((InputStream)in).close();
            return properties;
        }
        catch (Exception e) {
            throw new ConfigStoreException("Failed to read config" + configPath, e);
        }
    }

    public void storeProperties(String configPath, Properties properties) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        File target = new File(this.baseDirectory, configPath);
        if (target.exists() && !target.canWrite()) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
            properties.store(out, CONFIGHEADER);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new ConfigStoreException("Failed to write config " + configPath, e);
        }
    }

    public String toString() {
        return "FileConfigStorage={baseDir=" + this.baseDirectory + "}";
    }
}

