/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.csv;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.components.AbstractExportDialog;
import org.jfree.report.modules.gui.base.components.EncodingComboBoxModel;
import org.jfree.report.util.EncodingSupport;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.ui.LengthLimitingDocument;
import org.jfree.ui.action.ActionButton;
import org.jfree.util.Configuration;

public class CSVExportDialog
extends AbstractExportDialog {
    public static final String CSV_OUTPUT_ENCODING = "org.jfree.report.modules.gui.csv.Encoding";
    public static final String CSV_OUTPUT_ENCODING_DEFAULT = EncodingSupport.getPlatformDefaultEncoding();
    private JTextField txFilename;
    private JComboBox cbEncoding;
    private EncodingComboBoxModel encodingModel;
    private JCheckBox cbxStrictLayout;
    private JCheckBox cbxEnableReportHeader;
    private JCheckBox cbxEnableReportFooter;
    private JCheckBox cbxEnableGroupHeader;
    private JCheckBox cbxEnableGroupFooter;
    private JCheckBox cbxEnableItemband;
    private JCheckBox cbxWriteStateColumns;
    private JCheckBox cbxColumnNamesAsFirstRow;
    private JRadioButton rbSeparatorTab;
    private JRadioButton rbSeparatorColon;
    private JRadioButton rbSeparatorSemicolon;
    private JRadioButton rbSeparatorOther;
    private JTextField txSeparatorOther;
    private JRadioButton rbExportData;
    private JRadioButton rbExportPrintedElements;
    private JFileChooser fileChooser;
    private static final String COMMA_SEPARATOR = ",";
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String TAB_SEPARATOR = "\t";
    private static final String CSV_FILE_EXTENSION = ".csv";

    public CSVExportDialog() {
        this.initConstructor();
    }

    public CSVExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public CSVExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public void clear() {
        this.txFilename.setText("");
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(EncodingSupport.getPlatformDefaultEncoding()));
        this.rbExportPrintedElements.setSelected(true);
        this.rbSeparatorColon.setSelected(true);
        this.cbxStrictLayout.setSelected(false);
        this.cbxColumnNamesAsFirstRow.setSelected(false);
        this.performSeparatorSelection();
        this.updateExportTypeSelection();
    }

    private JPanel createExportTypePanel() {
        JPanel exportTypePanel = new JPanel();
        exportTypePanel.setLayout(new GridBagLayout());
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.exporttype"));
        exportTypePanel.setBorder(tb);
        JLabel lbExportedBands = new JLabel(this.getResources().getString("csvexportdialog.exported-bands"));
        this.rbExportData = new JRadioButton(this.getResources().getString("csvexportdialog.export.data"));
        this.rbExportPrintedElements = new JRadioButton(this.getResources().getString("csvexportdialog.export.printed_elements"));
        this.cbxColumnNamesAsFirstRow = new JCheckBox(this.getResources().getString("cvsexportdialog.export.columnnames"));
        this.rbExportData.addChangeListener(new ExportTypeSelectionChangeListener());
        this.cbxStrictLayout = new JCheckBox(this.getResources().getString("csvexportdialog.strict-layout"));
        this.cbxEnableGroupFooter = new JCheckBox(this.getResources().getString("csvexportdialog.enable-report-header"));
        this.cbxEnableGroupHeader = new JCheckBox(this.getResources().getString("csvexportdialog.enable-report-footer"));
        this.cbxEnableItemband = new JCheckBox(this.getResources().getString("csvexportdialog.enable-itemband"));
        this.cbxEnableReportFooter = new JCheckBox(this.getResources().getString("csvexportdialog.enable-group-header"));
        this.cbxEnableReportHeader = new JCheckBox(this.getResources().getString("csvexportdialog.enable-group-footer"));
        this.cbxWriteStateColumns = new JCheckBox(this.getResources().getString("csvexportdialog.write-state-columns"));
        this.getFormValidator().registerButton(this.rbExportData);
        this.getFormValidator().registerButton(this.rbExportPrintedElements);
        this.getFormValidator().registerButton(this.cbxStrictLayout);
        this.getFormValidator().registerButton(this.cbxColumnNamesAsFirstRow);
        this.getFormValidator().registerButton(this.cbxEnableGroupFooter);
        this.getFormValidator().registerButton(this.cbxEnableGroupHeader);
        this.getFormValidator().registerButton(this.cbxEnableItemband);
        this.getFormValidator().registerButton(this.cbxEnableReportFooter);
        this.getFormValidator().registerButton(this.cbxEnableReportHeader);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.rbExportData);
        btg.add(this.rbExportPrintedElements);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridwidth = 2;
        exportTypePanel.add((Component)this.rbExportPrintedElements, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 20, 1, 1);
        exportTypePanel.add((Component)this.cbxStrictLayout, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridwidth = 2;
        exportTypePanel.add((Component)this.rbExportData, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 20, 1, 1);
        exportTypePanel.add((Component)this.cbxColumnNamesAsFirstRow, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 20, 1, 1);
        exportTypePanel.add((Component)this.cbxWriteStateColumns, gbc);
        JPanel rowTypePanel = new JPanel();
        rowTypePanel.setLayout(new GridLayout(2, 3, 5, 2));
        rowTypePanel.add(this.cbxEnableReportHeader);
        rowTypePanel.add(this.cbxEnableGroupHeader);
        rowTypePanel.add(this.cbxEnableItemband);
        rowTypePanel.add(this.cbxEnableReportFooter);
        rowTypePanel.add(this.cbxEnableGroupFooter);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 20, 1, 1);
        exportTypePanel.add((Component)lbExportedBands, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 20, 1, 1);
        exportTypePanel.add((Component)rowTypePanel, gbc);
        return exportTypePanel;
    }

    private JPanel createSeparatorPanel() {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setLayout(new GridBagLayout());
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.separatorchar"));
        separatorPanel.setBorder(tb);
        this.rbSeparatorTab = new JRadioButton(this.getResources().getString("csvexportdialog.separator.tab"));
        this.rbSeparatorColon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.colon"));
        this.rbSeparatorSemicolon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.semicolon"));
        this.rbSeparatorOther = new JRadioButton(this.getResources().getString("csvexportdialog.separator.other"));
        this.getFormValidator().registerButton(this.rbSeparatorColon);
        this.getFormValidator().registerButton(this.rbSeparatorOther);
        this.getFormValidator().registerButton(this.rbSeparatorSemicolon);
        this.getFormValidator().registerButton(this.rbSeparatorTab);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.rbSeparatorTab);
        btg.add(this.rbSeparatorColon);
        btg.add(this.rbSeparatorSemicolon);
        btg.add(this.rbSeparatorOther);
        ActionSelectSeparator selectAction = new ActionSelectSeparator();
        this.rbSeparatorTab.addActionListener(selectAction);
        this.rbSeparatorColon.addActionListener(selectAction);
        this.rbSeparatorSemicolon.addActionListener(selectAction);
        this.rbSeparatorOther.addActionListener(selectAction);
        LengthLimitingDocument ldoc = new LengthLimitingDocument(1);
        this.txSeparatorOther = new JTextField();
        ((JTextComponent)this.txSeparatorOther).setDocument((Document)ldoc);
        this.txSeparatorOther.setColumns(5);
        this.getFormValidator().registerTextField(this.txSeparatorOther);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorTab, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorColon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorSemicolon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorOther, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.txSeparatorOther, gbc);
        return separatorPanel;
    }

    protected String getConfigurationSuffix() {
        return "_csvexport";
    }

    public Properties getDialogContents() {
        Properties p = new Properties();
        p.setProperty("filename", this.getFilename());
        p.setProperty("encoding", this.getEncoding());
        p.setProperty("separator-string", this.getSeparatorString());
        p.setProperty("strict-layout", String.valueOf(this.isStrictLayout()));
        p.setProperty("export-raw-data", String.valueOf(this.isExportRawData()));
        return p;
    }

    public String getEncoding() {
        if (this.cbEncoding.getSelectedIndex() == -1) {
            return EncodingSupport.getPlatformDefaultEncoding();
        }
        return this.encodingModel.getEncoding(this.cbEncoding.getSelectedIndex());
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.csv.resources.csv-export-resources";
    }

    public String getSeparatorString() {
        if (this.rbSeparatorColon.isSelected()) {
            return COMMA_SEPARATOR;
        }
        if (this.rbSeparatorSemicolon.isSelected()) {
            return SEMICOLON_SEPARATOR;
        }
        if (this.rbSeparatorTab.isSelected()) {
            return TAB_SEPARATOR;
        }
        if (this.rbSeparatorOther.isSelected()) {
            return this.txSeparatorOther.getText();
        }
        return "";
    }

    private void initConstructor() {
        this.setCancelAction(new CancelAction(this.getResources()));
        this.setConfirmAction(new ConfirmAction(this.getResources()));
        this.setTitle(this.getResources().getString("csvexportdialog.dialogtitle"));
        this.initialize();
        this.clear();
        this.getFormValidator().setEnabled(true);
    }

    public void initFromConfiguration(Configuration config) {
        String tableCSVSeparator = config.getConfigProperty("org.jfree.report.modules.output.table.csv.Separator", COMMA_SEPARATOR);
        this.setSeparatorString(config.getConfigProperty("org.jfree.report.modules.output.csv.Separator", tableCSVSeparator));
        String strict = config.getConfigProperty("org.jfree.report.modules.output.table.csv.StrictLayout", config.getConfigProperty("StrictLayout", "false"));
        this.setStrictLayout(strict.equals("true"));
        String colNames = config.getConfigProperty("org.jfree.report.modules.output.csv.WriteDatarowNames", "false");
        this.setColumnNamesAsFirstRow(colNames.equals("true"));
        String encoding = config.getConfigProperty(CSV_OUTPUT_ENCODING, CSV_OUTPUT_ENCODING_DEFAULT);
        this.encodingModel.ensureEncodingAvailable(encoding);
        this.setEncoding(encoding);
        String stateCols = config.getConfigProperty("org.jfree.report.modules.output.csv.WriteStateColumns", "false");
        this.setWriteStateColumns(stateCols.equals("true"));
        String enableReportHeader = config.getConfigProperty("org.jfree.report.modules.output.csv.EnableReportHeader", "false");
        this.setEnableReportHeader(enableReportHeader.equals("true"));
        String enableReportFooter = config.getConfigProperty("org.jfree.report.modules.output.csv.EnableReportFooter", "false");
        this.setEnableReportFooter(enableReportFooter.equals("true"));
        String enableGroupHeader = config.getConfigProperty("org.jfree.report.modules.output.csv.EnableGroupHeaders", "false");
        this.setEnableGroupHeader(enableGroupHeader.equals("true"));
        String enableGroupFooter = config.getConfigProperty("org.jfree.report.modules.output.csv.EnableGroupFooters", "false");
        this.setEnableGroupFooter(enableGroupFooter.equals("true"));
        String enableItemBand = config.getConfigProperty("org.jfree.report.modules.output.csv.EnableItembands", "false");
        this.setEnableItembands(enableItemBand.equals("true"));
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("csvexportdialog.filename"));
        JLabel lblEncoding = new JLabel(this.getResources().getString("csvexportdialog.encoding"));
        ActionButton btnSelect = new ActionButton((Action)new ActionSelectFile(this.getResources()));
        this.txFilename = new JTextField();
        this.txFilename.setColumns(30);
        this.encodingModel = EncodingComboBoxModel.createDefaultModel();
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 5);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 5);
        contentPane.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 1, 5, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.insets = new Insets(1, 5, 5, 1);
        contentPane.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 1, 1, 1);
        contentPane.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        contentPane.add((Component)this.createSeparatorPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        contentPane.add((Component)this.createExportTypePanel(), gbc);
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)btnConfirm);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.gridy = 6;
        gbc.insets = new Insets(10, 0, 10, 0);
        gbc.anchor = 13;
        contentPane.add((Component)buttonPanel, gbc);
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerComboBox(this.cbEncoding);
    }

    public boolean isColumnNamesAsFirstRow() {
        return this.cbxColumnNamesAsFirstRow.isSelected();
    }

    public boolean isEnableGroupFooter() {
        return this.cbxEnableGroupFooter.isSelected();
    }

    public boolean isEnableGroupHeader() {
        return this.cbxEnableGroupHeader.isSelected();
    }

    public boolean isEnableItembands() {
        return this.cbxEnableItemband.isSelected();
    }

    public boolean isEnableReportFooter() {
        return this.cbxEnableReportFooter.isSelected();
    }

    public boolean isEnableReportHeader() {
        return this.cbxEnableReportHeader.isSelected();
    }

    public boolean isExportRawData() {
        return this.rbExportData.isSelected();
    }

    public boolean isStrictLayout() {
        return this.cbxStrictLayout.isSelected();
    }

    public boolean isWriteStateColumns() {
        return this.cbxWriteStateColumns.isSelected();
    }

    public static void main(String[] args) {
        JFreeReportBoot.getInstance().start();
        CSVExportDialog dialog = new CSVExportDialog();
        dialog.setModal(true);
        dialog.pack();
        dialog.performQueryForExport(new JFreeReport());
        System.exit(0);
    }

    protected boolean performConfirm() {
        File f = new File(this.getFilename());
        if (f.exists()) {
            String key1 = "csvexportdialog.targetOverwriteConfirmation";
            String key2 = "csvexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("csvexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("csvexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(this.getResources().getString("csvexportdialog.csv-file-description"), CSV_FILE_EXTENSION));
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        this.fileChooser.setSelectedFile(new File(this.getFilename()));
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtil.endsWithIgnoreCase(selFileName, CSV_FILE_EXTENSION)) {
                selFileName = String.valueOf(selFileName) + CSV_FILE_EXTENSION;
            }
            this.setFilename(selFileName);
        }
    }

    protected void performSeparatorSelection() {
        if (this.rbSeparatorOther.isSelected()) {
            this.txSeparatorOther.setEnabled(true);
        } else {
            this.txSeparatorOther.setEnabled(false);
        }
    }

    protected boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(3, this.getResources().getString("csvexportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("csvexportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("csvexportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("csvexportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(2, message);
        }
        if (!(!this.isExportRawData() || this.cbxEnableGroupFooter.isSelected() || this.cbxEnableGroupHeader.isSelected() || this.cbxEnableReportFooter.isSelected() || this.cbxEnableReportHeader.isSelected() || this.cbxEnableItemband.isSelected())) {
            this.getStatusBar().setStatus(3, this.getResources().getString("csvexportdialog.noContentForExport"));
            return false;
        }
        return true;
    }

    public void setColumnNamesAsFirstRow(boolean colsAsFirstRow) {
        this.cbxColumnNamesAsFirstRow.setSelected(colsAsFirstRow);
    }

    public void setDialogContents(Properties p) {
        this.setFilename(p.getProperty("filename", this.getFilename()));
        this.setEncoding(p.getProperty("encoding", this.getEncoding()));
        this.setSeparatorString(p.getProperty("separator-string", this.getSeparatorString()));
        this.setStrictLayout(StringUtil.parseBoolean(p.getProperty("strict-layout"), this.isStrictLayout()));
        this.setExportRawData(StringUtil.parseBoolean(p.getProperty("export-raw-data"), this.isExportRawData()));
    }

    public void setEnableGroupFooter(boolean enableGroupFooter) {
        this.cbxEnableGroupFooter.setSelected(enableGroupFooter);
    }

    public void setEnableGroupHeader(boolean enableGroupHeader) {
        this.cbxEnableGroupHeader.setSelected(enableGroupHeader);
    }

    public void setEnableItembands(boolean enableItembands) {
        this.cbxEnableItemband.setSelected(enableItembands);
    }

    public void setEnableReportFooter(boolean enableReportFooter) {
        this.cbxEnableReportFooter.setSelected(enableReportFooter);
    }

    public void setEnableReportHeader(boolean enableReportHeader) {
        this.cbxEnableReportHeader.setSelected(enableReportHeader);
    }

    public void setEncoding(String encoding) {
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(encoding));
    }

    public void setExportRawData(boolean b) {
        if (b) {
            this.rbExportData.setSelected(true);
        } else {
            this.rbExportPrintedElements.setSelected(true);
        }
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    public void setSeparatorString(String s) {
        if (s == null) {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText("");
        } else if (s.equals(COMMA_SEPARATOR)) {
            this.rbSeparatorColon.setSelected(true);
        } else if (s.equals(SEMICOLON_SEPARATOR)) {
            this.rbSeparatorSemicolon.setSelected(true);
        } else if (s.equals(TAB_SEPARATOR)) {
            this.rbSeparatorTab.setSelected(true);
        } else {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText(s);
        }
        this.performSeparatorSelection();
    }

    public void setStrictLayout(boolean strictLayout) {
        this.cbxStrictLayout.setSelected(strictLayout);
    }

    public void setWriteStateColumns(boolean writeStateColumns) {
        this.cbxWriteStateColumns.setSelected(writeStateColumns);
    }

    public void storeToConfiguration(ModifiableConfiguration config) {
        config.setConfigProperty("org.jfree.report.modules.output.csv.Separator", this.getSeparatorString());
        config.setConfigProperty("org.jfree.report.modules.output.table.csv.Separator", this.getSeparatorString());
        config.setConfigProperty("org.jfree.report.modules.output.table.csv.StrictLayout", String.valueOf(this.isStrictLayout()));
        config.setConfigProperty("org.jfree.report.modules.output.csv.WriteDatarowNames", String.valueOf(this.isColumnNamesAsFirstRow()));
        config.setConfigProperty(CSV_OUTPUT_ENCODING, this.getEncoding());
        config.setConfigProperty("org.jfree.report.modules.output.csv.EnableGroupFooters", String.valueOf(this.isEnableGroupFooter()));
        config.setConfigProperty("org.jfree.report.modules.output.csv.EnableGroupHeaders", String.valueOf(this.isEnableGroupHeader()));
        config.setConfigProperty("org.jfree.report.modules.output.csv.EnableItembands", String.valueOf(this.isEnableItembands()));
        config.setConfigProperty("org.jfree.report.modules.output.csv.EnableReportFooter", String.valueOf(this.isEnableReportFooter()));
        config.setConfigProperty("org.jfree.report.modules.output.csv.EnableReportHeader", String.valueOf(this.isEnableReportHeader()));
    }

    protected void updateExportTypeSelection() {
        this.cbxStrictLayout.setEnabled(this.rbExportPrintedElements.isSelected());
        this.cbxColumnNamesAsFirstRow.setEnabled(this.rbExportData.isSelected());
        this.cbxEnableGroupFooter.setEnabled(this.rbExportData.isSelected());
        this.cbxEnableGroupHeader.setEnabled(this.rbExportData.isSelected());
        this.cbxEnableItemband.setEnabled(this.rbExportData.isSelected());
        this.cbxEnableReportFooter.setEnabled(this.rbExportData.isSelected());
        this.cbxEnableReportHeader.setEnabled(this.rbExportData.isSelected());
        this.cbxWriteStateColumns.setEnabled(this.rbExportData.isSelected());
    }

    private class ActionSelectSeparator
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            CSVExportDialog.this.performSeparatorSelection();
        }
    }

    private class ActionSelectFile
    extends AbstractAction {
        public ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.selectFile"));
        }

        public void actionPerformed(ActionEvent e) {
            CSVExportDialog.this.performSelectFile();
        }
    }

    private class ExportTypeSelectionChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            CSVExportDialog.this.updateExportTypeSelection();
        }
    }

    private class CancelAction
    extends AbstractExportDialog.AbstractCancelAction {
        public CancelAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.cancel"));
        }
    }

    private class ConfirmAction
    extends AbstractExportDialog.AbstractConfirmAction {
        public ConfirmAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.confirm"));
        }
    }
}

