/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.converter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.gui.base.components.EncodingComboBoxModel;
import org.jfree.report.modules.gui.converter.components.OperationResultTableModel;
import org.jfree.report.modules.gui.converter.parser.ConverterParserFrontend;
import org.jfree.report.modules.parser.ext.factory.datasource.DefaultDataSourceFactory;
import org.jfree.report.modules.parser.ext.factory.elements.DefaultElementFactory;
import org.jfree.report.modules.parser.ext.factory.objects.BandLayoutClassFactory;
import org.jfree.report.modules.parser.ext.factory.objects.DefaultClassFactory;
import org.jfree.report.modules.parser.ext.factory.stylekey.DefaultStyleKeyFactory;
import org.jfree.report.modules.parser.ext.factory.stylekey.PageableLayoutStyleKeyFactory;
import org.jfree.report.modules.parser.ext.factory.templates.DefaultTemplateCollection;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.FilesystemFilter;
import org.jfree.ui.action.ActionButton;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.ArrayClassFactory;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.URLClassFactory;

public class ReportConverterGUI
extends JFrame {
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.converter.resources.converter-resources";
    private final JTextField sourceField;
    private final JTextField targetField;
    private final JFileChooser fileChooser;
    private ResourceBundle resources;
    private final EncodingComboBoxModel encodingModel = EncodingComboBoxModel.createDefaultModel();
    private final OperationResultTableModel resultTableModel;
    private JLabel statusHolder;

    public ReportConverterGUI() {
        this.encodingModel.ensureEncodingAvailable("UTF-16");
        this.encodingModel.setSelectedIndex(this.encodingModel.indexOf("UTF-16"));
        this.encodingModel.sort();
        this.resultTableModel = new OperationResultTableModel();
        this.sourceField = new JTextField();
        this.targetField = new JTextField();
        JTable table = new JTable(this.resultTableModel);
        table.setMinimumSize(new Dimension(100, 100));
        JSplitPane componentPane = new JSplitPane(0, this.createMainPane(), new JScrollPane(table));
        componentPane.setOneTouchExpandable(true);
        componentPane.resetToPreferredSizes();
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)componentPane, "Center");
        contentPane.add((Component)this.createStatusBar(), "South");
        this.setContentPane(contentPane);
        this.fileChooser = new JFileChooser();
        this.fileChooser.addChoosableFileFilter((FileFilter)new FilesystemFilter(new String[]{".xml"}, "XML-Report definitions", true));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.setTitle(this.getResources().getString("convertdialog.title"));
    }

    public boolean convert() {
        if (!this.performSourceValidate(this.getSourceFile())) {
            this.setStatusText("Validating the source file failed. Please check your inputs.");
            return false;
        }
        if (!this.performTargetValidate(this.getTargetFile())) {
            this.setStatusText("Validating the target file failed. Please check your inputs.");
            return false;
        }
        try {
            ConverterParserFrontend frontend = new ConverterParserFrontend();
            File sourceFile = new File(this.getSourceFile());
            File targetFile = new File(this.getTargetFile());
            String encoding = this.encodingModel.getSelectedEncoding();
            JFreeReport report = (JFreeReport)frontend.parse(sourceFile.toURL(), sourceFile.toURL());
            DefaultConfiguration config = new DefaultConfiguration();
            config.setProperty("content-base", targetFile.toURL().toExternalForm());
            ReportWriter writer = new ReportWriter(report, encoding, (Configuration)config);
            writer.addClassFactoryFactory((ClassFactory)new URLClassFactory());
            writer.addClassFactoryFactory((ClassFactory)new DefaultClassFactory());
            writer.addClassFactoryFactory((ClassFactory)new BandLayoutClassFactory());
            writer.addClassFactoryFactory((ClassFactory)new ArrayClassFactory());
            writer.addStyleKeyFactory(new DefaultStyleKeyFactory());
            writer.addStyleKeyFactory(new PageableLayoutStyleKeyFactory());
            writer.addTemplateCollection(new DefaultTemplateCollection());
            writer.addElementFactory(new DefaultElementFactory());
            writer.addDataSourceFactory(new DefaultDataSourceFactory());
            FileOutputStream base = new FileOutputStream(targetFile);
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)base, encoding));
            writer.write(w);
            ((Writer)w).close();
            this.setStatusText("Conversion done.");
            return true;
        }
        catch (Exception e) {
            Log.warn((Object)"Failed to convert the report. ", (Exception)e);
            this.setStatusText("Failed to convert the report:" + e.getMessage());
            return false;
        }
    }

    private JPanel createMainPane() {
        ActionButton selectSourceButton = new ActionButton((Action)new SelectSourceAction());
        ActionButton selectTargetButton = new ActionButton((Action)new SelectTargetAction());
        ActionButton convertFilesButton = new ActionButton((Action)new ConvertAction());
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)new JLabel(this.getResources().getString("convertdialog.sourceFile")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        contentPane.add((Component)this.sourceField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)selectSourceButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)new JLabel(this.getResources().getString("convertdialog.targetFile")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        contentPane.add((Component)this.targetField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.fill = 2;
        contentPane.add((Component)selectTargetButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)new JLabel(this.getResources().getString("convertdialog.encoding")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.ipadx = 120;
        contentPane.add(new JComboBox(this.encodingModel), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        gbc.fill = 2;
        contentPane.add((Component)convertFilesButton, gbc);
        return contentPane;
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        statusPane.setMinimumSize(this.statusHolder.getPreferredSize());
        statusPane.add((Component)this.statusHolder, "West");
        return statusPane;
    }

    protected ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = ResourceBundle.getBundle(BASE_RESOURCE_CLASS);
        }
        return this.resources;
    }

    protected String getSourceFile() {
        return this.sourceField.getText();
    }

    public String getStatusText() {
        return this.statusHolder.getText();
    }

    protected String getTargetFile() {
        return this.targetField.getText();
    }

    public static void main(String[] args) {
        ReportConverterGUI gui = new ReportConverterGUI();
        gui.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        gui.pack();
        ((Component)gui).setVisible(true);
    }

    protected String performSelectFile(String filename, boolean appendExt) {
        File file = new File(filename);
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.setSelectedFile(file);
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (appendExt && !StringUtil.endsWithIgnoreCase(selFileName, ".xml")) {
                selFileName = String.valueOf(selFileName) + ".xml";
            }
            return selFileName;
        }
        return filename;
    }

    public boolean performSourceValidate(String filename) {
        if (filename.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, this.getResources().getString("convertdialog.sourceIsEmpty"), this.getResources().getString("convertdialog.errorTitle"), 0);
            return false;
        }
        File f = new File(filename);
        if (!f.exists()) {
            return false;
        }
        if (!f.isFile()) {
            JOptionPane.showMessageDialog(this, this.getResources().getString("convertdialog.sourceIsNoFile"), this.getResources().getString("convertdialog.errorTitle"), 0);
            return false;
        }
        if (!f.canRead()) {
            JOptionPane.showMessageDialog(this, this.getResources().getString("convertdialog.sourceIsNotReadable"), this.getResources().getString("convertdialog.errorTitle"), 0);
            return false;
        }
        return true;
    }

    public boolean performTargetValidate(String filename) {
        if (filename.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, this.getResources().getString("convertdialog.targetIsEmpty"), this.getResources().getString("convertdialog.errorTitle"), 0);
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                JOptionPane.showMessageDialog(this, this.getResources().getString("convertdialog.targetIsNoFile"), this.getResources().getString("convertdialog.errorTitle"), 0);
                return false;
            }
            if (!f.canWrite()) {
                JOptionPane.showMessageDialog(this, this.getResources().getString("convertdialog.targetIsNotWritable"), this.getResources().getString("convertdialog.errorTitle"), 0);
                return false;
            }
            String key1 = "convertdialog.targetOverwriteConfirmation";
            String key2 = "convertdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("convertdialog.targetOverwriteConfirmation"), filename), this.getResources().getString("convertdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void setSourceFile(String file) {
        this.sourceField.setText(file);
    }

    public void setStatusText(String text) {
        this.statusHolder.setText(text);
    }

    protected void setTargetFile(String file) {
        this.targetField.setText(file);
    }

    private class SelectTargetAction
    extends AbstractAction {
        public SelectTargetAction() {
            this.putValue("Name", ReportConverterGUI.this.getResources().getString("convertdialog.action.selectTarget.name"));
            this.putValue("ShortDescription", ReportConverterGUI.this.getResources().getString("convertdialog.action.selectTarget.description"));
        }

        public void actionPerformed(ActionEvent e) {
            ReportConverterGUI.this.setTargetFile(ReportConverterGUI.this.performSelectFile(ReportConverterGUI.this.getTargetFile(), true));
        }
    }

    private class SelectSourceAction
    extends AbstractAction {
        public SelectSourceAction() {
            this.putValue("Name", ReportConverterGUI.this.getResources().getString("convertdialog.action.selectSource.name"));
            this.putValue("ShortDescription", ReportConverterGUI.this.getResources().getString("convertdialog.action.selectSource.description"));
        }

        public void actionPerformed(ActionEvent e) {
            ReportConverterGUI.this.setSourceFile(ReportConverterGUI.this.performSelectFile(ReportConverterGUI.this.getSourceFile(), false));
        }
    }

    private class ConvertAction
    extends AbstractAction {
        public ConvertAction() {
            this.putValue("Name", ReportConverterGUI.this.getResources().getString("convertdialog.action.convert.name"));
            this.putValue("ShortDescription", ReportConverterGUI.this.getResources().getString("convertdialog.action.convert.description"));
        }

        public void actionPerformed(ActionEvent e) {
            ReportConverterGUI.this.convert();
        }
    }
}

