/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.config.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.jfree.report.modules.gui.config.model.ConfigTreeNode;

public abstract class AbstractConfigTreeNode
implements ConfigTreeNode {
    private final ArrayList childs = new ArrayList();
    private final String name;
    private TreeNode parent;

    public AbstractConfigTreeNode(String name) {
        this.name = name;
    }

    public void add(ConfigTreeNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.childs.contains(node)) {
            this.childs.add(node);
            node.setParent(this);
        }
    }

    public Enumeration children() {
        return Collections.enumeration(this.childs);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.childs.get(childIndex);
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public int getIndex(TreeNode node) {
        return this.childs.indexOf(node);
    }

    public String getName() {
        return this.name;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return false;
    }

    protected void reset() {
        int i = 0;
        while (i < this.childs.size()) {
            ConfigTreeNode node = (ConfigTreeNode)this.childs.get(i);
            node.setParent(null);
            ++i;
        }
        this.childs.clear();
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }
}

