/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jfree.ui.FloatingButtonEnabler;
import org.jfree.ui.action.ActionButton;
import org.jfree.util.Log;

public class ExceptionDialog
extends JDialog {
    private final JTextArea backtraceArea;
    private final JLabel messageLabel;
    private Exception currentEx;
    private OKAction okAction;
    private DetailsAction detailsAction;
    private final JScrollPane scroller;
    private final JPanel filler;
    private static ExceptionDialog defaultDialog;

    public ExceptionDialog() {
        this.setModal(true);
        this.messageLabel = new JLabel();
        this.backtraceArea = new JTextArea();
        this.scroller = new JScrollPane(this.backtraceArea);
        this.scroller.setVisible(false);
        JPanel detailPane = new JPanel();
        detailPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JLabel icon = new JLabel(UIManager.getDefaults().getIcon("OptionPane.errorIcon"));
        icon.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        detailPane.add((Component)icon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        detailPane.add(this.messageLabel);
        gbc = new GridBagConstraints();
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        detailPane.add((Component)this.createButtonPane(), gbc);
        this.filler = new JPanel();
        this.filler.setPreferredSize(new Dimension(0, 0));
        this.filler.setBackground(Color.green);
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 5.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        detailPane.add((Component)this.filler, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 16;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 5.0;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        detailPane.add((Component)this.scroller, gbc);
        this.setContentPane(detailPane);
    }

    public void adjustSize() {
        Dimension scSize = this.scroller.getPreferredSize();
        Dimension cbase = this.filler.getPreferredSize();
        cbase.width = Math.max(scSize.width, cbase.width);
        cbase.height = 0;
        this.filler.setMinimumSize(cbase);
        this.pack();
    }

    private JPanel createButtonPane() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        class Org_jfree_report_modules_gui_base_components_ExceptionDialog$1 {
            /* synthetic */ Org_jfree_report_modules_gui_base_components_ExceptionDialog$1() {
            }
        }
        this.okAction = new OKAction();
        this.detailsAction = new DetailsAction();
        ActionButton ok = new ActionButton((Action)this.okAction);
        ActionButton details = new ActionButton((Action)this.detailsAction);
        FloatingButtonEnabler.getInstance().addButton((AbstractButton)ok);
        FloatingButtonEnabler.getInstance().addButton((AbstractButton)details);
        buttonPane.add((Component)ok);
        buttonPane.add((Component)details);
        return buttonPane;
    }

    public Exception getException() {
        return this.currentEx;
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    protected boolean isScrollerVisible() {
        return this.scroller.isVisible();
    }

    private String readFromException(Exception e) {
        String text = "No backtrace available";
        try {
            StringWriter writer = new StringWriter();
            PrintWriter pwriter = new PrintWriter(writer);
            e.printStackTrace(pwriter);
            text = writer.toString();
            writer.close();
        }
        catch (Exception exception) {
            Log.info((Object)"ExceptionDialog: exception suppressed.");
        }
        return text;
    }

    public void setException(Exception e) {
        this.currentEx = e;
        if (e == null) {
            this.detailsAction.setEnabled(false);
            this.backtraceArea.setText("");
        } else {
            this.backtraceArea.setText(this.readFromException(e));
        }
    }

    public void setMessage(String mesg) {
        this.messageLabel.setText(mesg);
    }

    protected void setScrollerVisible(boolean b) {
        this.scroller.setVisible(b);
    }

    public static void showExceptionDialog(String title, String message, Exception e) {
        if (defaultDialog == null) {
            defaultDialog = new ExceptionDialog();
        }
        if (e != null) {
            Log.error((Object)"UserError", (Exception)e);
        }
        defaultDialog.setTitle(title);
        defaultDialog.setMessage(message);
        defaultDialog.setException(e);
        defaultDialog.adjustSize();
        ((Component)defaultDialog).setVisible(true);
    }

    private final class OKAction
    extends AbstractAction {
        private OKAction() {
            this.putValue("Name", UIManager.getDefaults().getString("OptionPane.okButtonText"));
        }

        public void actionPerformed(ActionEvent event) {
            ((Component)ExceptionDialog.this).setVisible(false);
        }
    }

    private final class DetailsAction
    extends AbstractAction {
        private DetailsAction() {
            this.putValue("Name", ">>");
        }

        public void actionPerformed(ActionEvent event) {
            ExceptionDialog.this.setScrollerVisible(ExceptionDialog.this.isScrollerVisible() ^ true);
            if (ExceptionDialog.this.isScrollerVisible()) {
                this.putValue("Name", "<<");
            } else {
                this.putValue("Name", ">>");
            }
            ExceptionDialog.this.adjustSize();
        }
    }
}

