/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.jfree.report.modules.gui.base.ExportTaskListener;
import org.jfree.util.Log;

public abstract class ExportTask
implements Runnable {
    public static final int RETURN_PENDING = -1;
    public static final int RETURN_SUCCESS = 0;
    public static final int RETURN_FAILED = 1;
    public static final int RETURN_ABORT = 2;
    private int returnValue = -1;
    private boolean taskDone;
    private Exception exception;
    private final ArrayList listeners = new ArrayList();

    public void addExportTaskListener(ExportTaskListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    protected void dispose() {
        this.listeners.clear();
        this.exception = null;
    }

    protected void fireExportAborted() {
        int i = 0;
        while (i < this.listeners.size()) {
            ExportTaskListener tl = (ExportTaskListener)this.listeners.get(i);
            tl.taskAborted(this);
            ++i;
        }
    }

    protected void fireExportDone() {
        int i = 0;
        while (i < this.listeners.size()) {
            ExportTaskListener tl = (ExportTaskListener)this.listeners.get(i);
            tl.taskDone(this);
            ++i;
        }
    }

    protected void fireExportFailed() {
        int i = 0;
        while (i < this.listeners.size()) {
            ExportTaskListener tl = (ExportTaskListener)this.listeners.get(i);
            tl.taskFailed(this);
            ++i;
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public synchronized boolean isTaskDone() {
        return this.taskDone;
    }

    protected abstract void performExport();

    public void removeExportTaskListener(ExportTaskListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ((AbstractCollection)this.listeners).remove(listener);
    }

    public final void run() {
        try {
            this.performExport();
        }
        catch (Exception e) {
            Log.warn((Object)"ExportTask.run(): Caught exception while exporting...", (Exception)e);
            this.setTaskFailed(e);
        }
        this.dispose();
    }

    protected synchronized void setTaskAborted() {
        this.taskDone = true;
        this.returnValue = 2;
        this.fireExportAborted();
    }

    protected synchronized void setTaskDone() {
        this.taskDone = true;
        this.returnValue = 0;
        this.fireExportDone();
    }

    protected synchronized void setTaskFailed(Exception ex) {
        this.taskDone = true;
        this.returnValue = 1;
        this.exception = ex;
        this.fireExportFailed();
    }
}

