/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function.strings;

import org.jfree.report.function.AbstractExpression;

public class CapitalizeStringExpression
extends AbstractExpression {
    private String field;
    private boolean firstWordOnly;

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        Object raw = this.getDataRow().get(this.getField());
        if (raw == null) {
            return null;
        }
        String text = String.valueOf(raw);
        char[] textArray = text.toCharArray();
        boolean startOfWord = true;
        int i = 0;
        while (i < textArray.length) {
            char c = textArray[i];
            if (Character.isWhitespace(c)) {
                startOfWord = true;
            } else {
                if (startOfWord) {
                    textArray[i] = Character.toTitleCase(c);
                }
                if (this.firstWordOnly) break;
                startOfWord = false;
            }
            ++i;
        }
        return new String(textArray);
    }

    public boolean isFirstWordOnly() {
        return this.firstWordOnly;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFirstWordOnly(boolean firstWordOnly) {
        this.firstWordOnly = firstWordOnly;
    }
}

