/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.function.AbstractExpression;

public class TextFormatExpression
extends AbstractExpression
implements Serializable {
    private ArrayList fields = new ArrayList();
    private String pattern;

    public Object clone() throws CloneNotSupportedException {
        TextFormatExpression tex = (TextFormatExpression)super.clone();
        tex.fields = (ArrayList)this.fields.clone();
        return tex;
    }

    public String[] getField() {
        return this.fields.toArray(new String[this.fields.size()]);
    }

    public String getField(int index) {
        return (String)this.fields.get(index);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    protected Object[] getFieldValues() {
        Object[] retval = new Object[this.fields.size()];
        int i = 0;
        while (i < this.fields.size()) {
            String field = (String)this.fields.get(i);
            retval[i] = this.getDataRow().get(field);
            ++i;
        }
        return retval;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object getValue() {
        ResourceBundleFactory factory = this.getResourceBundleFactory();
        MessageFormat format = new MessageFormat("");
        format.setLocale(factory.getLocale());
        format.applyPattern(this.getPattern());
        return format.format(this.getFieldValues());
    }

    public void setField(int index, String field) {
        if (this.fields.size() == index) {
            this.fields.add(field);
        } else {
            this.fields.set(index, field);
        }
    }

    public void setField(String[] fields) {
        this.fields.clear();
        this.fields.addAll(Arrays.asList(fields));
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

