/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.function.AbstractElementFormatFunction;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.SerializerHelper;

public class NegativeNumberPaintChangeFunction
extends AbstractElementFormatFunction {
    private String field;
    private transient Color positiveColor;
    private transient Color negativeColor;
    private transient Color zeroColor;

    public String getField() {
        return this.field;
    }

    public Color getNegativeColor() {
        return this.negativeColor;
    }

    public Color getPositiveColor() {
        return this.positiveColor;
    }

    public Object getValue() {
        return null;
    }

    public Color getZeroColor() {
        return this.zeroColor;
    }

    protected void processRootBand(Band b) {
        Element[] elements = FunctionUtilities.findAllElements(b, this.getElement());
        if (elements.length == 0) {
            return;
        }
        Color color = this.selectColor();
        int i = 0;
        while (i < elements.length) {
            elements[i].getStyle().setStyleProperty(ElementStyleSheet.PAINT, color);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.positiveColor = (Color)SerializerHelper.getInstance().readObject(in);
        this.negativeColor = (Color)SerializerHelper.getInstance().readObject(in);
        this.zeroColor = (Color)SerializerHelper.getInstance().readObject(in);
    }

    protected Color selectColor() {
        Object o = this.getDataRow().get(this.getField());
        if (!(o instanceof Number)) {
            return this.getPositiveColor();
        }
        Number n = (Number)o;
        double d = n.doubleValue();
        if (d < 0.0) {
            return this.getNegativeColor();
        }
        if (d > 0.0) {
            return this.getPositiveColor();
        }
        Color zeroColor = this.getZeroColor();
        if (zeroColor == null) {
            return this.getPositiveColor();
        }
        return zeroColor;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setNegativeColor(Color negativeColor) {
        this.negativeColor = negativeColor;
    }

    public void setPositiveColor(Color positiveColor) {
        this.positiveColor = positiveColor;
    }

    public void setZeroColor(Color zeroColor) {
        this.zeroColor = zeroColor;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper.getInstance().writeObject(this.positiveColor, out);
        SerializerHelper.getInstance().writeObject(this.negativeColor, out);
        SerializerHelper.getInstance().writeObject(this.zeroColor, out);
    }
}

