/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.Group;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.states.ReportState;

public class ItemCountFunction
extends AbstractFunction
implements Serializable {
    private transient int count;
    private String group;

    public ItemCountFunction() {
    }

    public ItemCountFunction(String name) {
        this.setName(name);
    }

    protected int getCount() {
        return this.count;
    }

    public String getGroup() {
        return this.group;
    }

    public Object getValue() {
        return new Integer(this.getCount());
    }

    public void groupStarted(ReportEvent event) {
        if (this.getGroup() == null) {
            return;
        }
        ReportState state = event.getState();
        Group group = event.getReport().getGroup(state.getCurrentGroupIndex());
        if (this.getGroup().equals(group.getName())) {
            this.setCount(0);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        this.setCount(this.getCount() + 1);
    }

    public void reportInitialized(ReportEvent event) {
        this.setCount(0);
    }

    protected void setCount(int count) {
        this.count = count;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

